/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.serialization.GtfsEntitySchemaFactory;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_transformer.factory.EntityRetentionGraph;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class RetainUpFromPolygon
implements GtfsTransformStrategy {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    private final WKTReader wktReader = new WKTReader(GEOMETRY_FACTORY);
    @CsvField(optional=false)
    private String polygon;
    @CsvField(ignore=true)
    private Geometry polygonGeometry;

    public void setPolygon(String polygon) {
        this.polygon = polygon;
        this.polygonGeometry = this.buildPolygon(polygon);
        if (this.polygonGeometry == null || !this.polygonGeometry.isValid() || this.polygonGeometry.isEmpty()) {
            throw new IllegalArgumentException("The provided polygon is invalid or empty.");
        }
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext transformContext, GtfsMutableRelationalDao gtfsMutableRelationalDao) {
        EntityRetentionGraph graph = new EntityRetentionGraph((GtfsRelationalDao)gtfsMutableRelationalDao);
        graph.setRetainBlocks(false);
        for (Stop stop : gtfsMutableRelationalDao.getAllStops()) {
            if (!this.insidePolygon(this.polygonGeometry, stop.getLon(), stop.getLat())) continue;
            graph.retain(stop, true);
        }
        for (Class entityClass : GtfsEntitySchemaFactory.getEntityClasses()) {
            ArrayList objectsToRemove = new ArrayList();
            for (Object entity : gtfsMutableRelationalDao.getAllEntitiesForType(entityClass)) {
                if (graph.isRetained(entity)) continue;
                objectsToRemove.add(entity);
            }
            for (Object toRemove : objectsToRemove) {
                gtfsMutableRelationalDao.removeEntity((IdentityBean)toRemove);
            }
        }
    }

    private Geometry buildPolygon(String polygonWKT) {
        try {
            return this.wktReader.read(polygonWKT);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Error parsing WKT string: %s".formatted(e.getMessage()), e);
        }
    }

    private boolean insidePolygon(Geometry geometry, double lon, double lat) {
        Point point = GEOMETRY_FACTORY.createPoint(new Coordinate(lon, lat));
        return geometry.contains((Geometry)point);
    }
}

