/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.onebusaway.csv_entities.CSVLibrary;
import org.onebusaway.csv_entities.CSVListener;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceDataFactoryImpl;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs.services.calendar.CalendarService;
import org.onebusaway.gtfs_transformer.services.CloudContextService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyReferenceService
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(VerifyReferenceService.class);
    @CsvField(optional=true)
    private String problemRoutesFile;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        CalendarService refCalendarService = CalendarServiceDataFactoryImpl.createService((GtfsRelationalDao)reference);
        String feed = CloudContextService.getLikelyFeedName(reference);
        ProblemRouteListener listener = new ProblemRouteListener();
        try {
            if (this.problemRoutesFile != null) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.problemRoutesFile));
                new CSVLibrary().parse((InputStream)is, (CSVListener)listener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collection<String> problemRoutes = listener.returnRouteIds();
        for (String route : problemRoutes) {
            this._log.info("ProblemRoutes includes: " + route);
        }
        Date today = this.removeTime(new Date());
        Date tomorrow = this.removeTime(this.addDays(new Date(), 1));
        Date nextDay = this.removeTime(this.addDays(new Date(), 2));
        Date dayAfterNext = this.removeTime(this.addDays(new Date(), 3));
        int[] tripsToday = this.hasRouteServiceForDate(dao, reference, refCalendarService, today, problemRoutes);
        int[] tripsTomorrow = this.hasRouteServiceForDate(dao, reference, refCalendarService, tomorrow, problemRoutes);
        int[] tripsNextDay = this.hasRouteServiceForDate(dao, reference, refCalendarService, nextDay, problemRoutes);
        int[] tripsDayAfterNext = this.hasRouteServiceForDate(dao, reference, refCalendarService, dayAfterNext, problemRoutes);
        this._log.info("Feed for metrics: {}", (Object)feed);
        this._log.info("Active routes {}: {}, {}: {}, {}: {}, {}: {}", new Object[]{today, tripsToday, tomorrow, tripsTomorrow, nextDay, tripsNextDay, dayAfterNext, tripsDayAfterNext});
    }

    int[] hasRouteServiceForDate(GtfsMutableRelationalDao dao, GtfsMutableRelationalDao reference, CalendarService refCalendarService, Date testDate, Collection<String> problemRoutes) {
        AgencyAndId daoAgencyAndId = ((Trip)dao.getAllTrips().iterator().next()).getId();
        int numRoutesWithTrips = 0;
        int activeRoutes = 0;
        int alarmingRoutes = 0;
        block0: for (Route route : reference.getAllRoutes()) {
            numRoutesWithTrips = 0;
            ServiceDate sDate = this.createServiceDate(testDate);
            block1: for (Trip trip : reference.getTripsForRoute(route)) {
                for (ServiceDate calDate : refCalendarService.getServiceDatesForServiceId(trip.getServiceId())) {
                    if (!calDate.equals((Object)sDate)) continue;
                    this._log.info("Reference has service for route: {} on {}", (Object)route.getId().getId(), (Object)testDate);
                    ++numRoutesWithTrips;
                    ++activeRoutes;
                    break block1;
                }
            }
            if (numRoutesWithTrips != 0) continue;
            this._log.error("No service for {} on {}", (Object)route.getId().getId(), (Object)testDate);
            Route atisRoute = dao.getRouteForId(new AgencyAndId(daoAgencyAndId.getAgencyId(), route.getId().getId()));
            if (atisRoute == null) {
                atisRoute = dao.getRouteForId(new AgencyAndId(daoAgencyAndId.getAgencyId(), route.getShortName()));
            }
            for (Trip atisTrip : dao.getTripsForRoute(atisRoute)) {
                for (ServiceCalendarDate calDate : dao.getCalendarDatesForServiceId(atisTrip.getServiceId())) {
                    Date date = this.constructDate(calDate.getDate());
                    if (!date.equals(testDate) || calDate.getExceptionType() != 1) continue;
                    if (problemRoutes.contains(route.getId().getId())) {
                        this._log.info("On {} ATIS has service for this route but Reference has none: {}. Excused route, no further action", (Object)testDate, (Object)route.getId());
                        continue block0;
                    }
                    this._log.info("On {} ATIS has service for this route but Reference has none: {}", (Object)testDate, (Object)route.getId());
                    ++alarmingRoutes;
                    continue block0;
                }
            }
        }
        return new int[]{activeRoutes, alarmingRoutes};
    }

    private Date constructDate(ServiceDate date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, date.getYear());
        calendar.set(2, date.getMonth() - 1);
        calendar.set(5, date.getDay());
        Date date1 = calendar.getTime();
        date1 = this.removeTime(date1);
        return date1;
    }

    private Date removeTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        return date;
    }

    private Date addDays(Date date, int daysToAdd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, daysToAdd);
        return cal.getTime();
    }

    private ServiceDate createServiceDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new ServiceDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public void setProblemRoutesFile(String problemRoutesFile) {
        this.problemRoutesFile = problemRoutesFile;
    }

    private static class ProblemRouteListener
    implements CSVListener {
        private Collection<String> routeIds = new HashSet<String>();

        private ProblemRouteListener() {
        }

        public void handleLine(List<String> list) {
            if (this.routeIds == null) {
                this.routeIds = list;
                return;
            }
            this.routeIds.add(list.getFirst());
        }

        private Collection<String> returnRouteIds() {
            return this.routeIds;
        }
    }
}

