/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceDataFactoryImpl;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.serialization.mappings.ServiceDateFieldMappingFactory;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs.services.calendar.CalendarService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.CalendarSimplicationLibrary;
import org.onebusaway.gtfs_transformer.updates.UpdateLibrary;

public class CalendarExtensionStrategy
implements GtfsTransformStrategy {
    private static final TimeZone _utcTimeZone = TimeZone.getTimeZone("UTC");
    @CsvField(mapping=ServiceDateFieldMappingFactory.class)
    private ServiceDate endDate;
    @CsvField(mapping=ServiceDateFieldMappingFactory.class, optional=true)
    private ServiceDate inactiveCalendarCutoff = new ServiceDate(new Date()).shift(-14);

    public ServiceDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(ServiceDate endDate) {
        this.endDate = endDate;
    }

    public ServiceDate getInactiveCalendarCutoff() {
        return this.inactiveCalendarCutoff;
    }

    public void setInactiveCalendarCutoff(ServiceDate inactiveCalendarCutoff) {
        this.inactiveCalendarCutoff = inactiveCalendarCutoff;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        CalendarService service = CalendarServiceDataFactoryImpl.createService((GtfsRelationalDao)dao);
        CalendarSimplicationLibrary simplication = new CalendarSimplicationLibrary();
        for (AgencyAndId serviceId : dao.getAllServiceIds()) {
            CalendarSimplicationLibrary.ServiceCalendarSummary summary = simplication.getSummaryForServiceDates(service.getServiceDatesForServiceId(serviceId));
            if (summary.allServiceDates.isEmpty()) continue;
            ServiceCalendar calendar = dao.getCalendarForServiceId(serviceId);
            if (calendar == null) {
                ServiceDate firstMissingDate;
                Set<Integer> daysOfTheWeekToUse;
                ServiceDate lastDate = summary.serviceDatesInOrder.get(summary.serviceDatesInOrder.size() - 1);
                if (lastDate.compareTo(this.inactiveCalendarCutoff) < 0 || (daysOfTheWeekToUse = this.getDaysOfTheWeekToUse(summary)).isEmpty()) continue;
                ServiceDate serviceDate = firstMissingDate = lastDate.next();
                while (serviceDate.compareTo(this.endDate) <= 0) {
                    Calendar serviceDateAsCalendar = serviceDate.getAsCalendar(_utcTimeZone);
                    serviceDateAsCalendar.add(11, 12);
                    int dayOfWeek = serviceDateAsCalendar.get(7);
                    if (daysOfTheWeekToUse.contains(dayOfWeek)) {
                        ServiceCalendarDate scd = new ServiceCalendarDate();
                        scd.setDate(serviceDate);
                        scd.setExceptionType(1);
                        scd.setServiceId(serviceId);
                        dao.saveEntity((Object)scd);
                    }
                    serviceDate = serviceDate.next();
                }
                continue;
            }
            if (calendar.getEndDate().compareTo(this.inactiveCalendarCutoff) < 0) continue;
            calendar.setEndDate(this.endDate);
        }
        UpdateLibrary.clearDaoCache((GtfsRelationalDao)dao);
    }

    private Set<Integer> getDaysOfTheWeekToUse(CalendarSimplicationLibrary.ServiceCalendarSummary summary) {
        HashSet<Integer> days = new HashSet<Integer>(summary.daysOfTheWeekToUse);
        for (Map.Entry<Integer, ServiceDate> entry : summary.mostRecentServiceDateByDayOfWeek.entrySet()) {
            if (entry.getValue().compareTo(this.inactiveCalendarCutoff) >= 0) continue;
            days.remove(entry.getKey());
        }
        return days;
    }
}

