/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.StopSequencePattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeduplicateTripsStrategy
implements GtfsTransformStrategy {
    private static final TripComparator _tripComparator = new TripComparator();
    private Logger _log = LoggerFactory.getLogger(DeduplicateTripsStrategy.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        FactoryMap tripsByCommonId = new FactoryMap(new ArrayList());
        int total = 0;
        int badIds = 0;
        for (Trip trip : dao.getAllTrips()) {
            AgencyAndId aid = trip.getId();
            String id = aid.getId();
            int index = id.indexOf(95);
            if (index != -1) {
                String commonId = id.substring(index + 1);
                ((List)tripsByCommonId.get(commonId)).add(trip);
                continue;
            }
            ++badIds;
        }
        this._log.info("trips=" + total + " badIds=" + badIds);
        int weird = 0;
        int pairs = 0;
        int patternMismatch = 0;
        int propertyMismatch = 0;
        for (List trips : tripsByCommonId.values()) {
            if (trips.size() == 1) continue;
            if (trips.size() != 2) {
                System.out.println("weird: " + String.valueOf(trips));
                ++weird;
                continue;
            }
            ++pairs;
            Collections.sort(trips, _tripComparator);
            Trip tripA = (Trip)trips.getFirst();
            Trip tripB = (Trip)trips.get(1);
            List stopTimesA = dao.getStopTimesForTrip(tripA);
            List stopTimesB = dao.getStopTimesForTrip(tripB);
            StopSequencePattern patternA = StopSequencePattern.getPatternForStopTimes(stopTimesA);
            StopSequencePattern patternB = StopSequencePattern.getPatternForStopTimes(stopTimesB);
            if (!patternA.equals(patternB)) {
                System.out.println("  pattern: " + String.valueOf(tripA.getId()) + " " + String.valueOf(tripB.getId()));
                ++patternMismatch;
                continue;
            }
            String property = this.areTripsEquivalent(tripA, tripB);
            if (property == null) continue;
            System.out.println("  property: " + String.valueOf(tripA.getId()) + " " + String.valueOf(tripB.getId()) + " " + property);
            ++propertyMismatch;
        }
        this._log.info("weird=" + weird + " pairs=" + pairs + " patternMismatch=" + patternMismatch + " propertyMismatch=" + propertyMismatch);
    }

    private String areTripsEquivalent(Trip tripA, Trip tripB) {
        if (!this.equals(tripA.getDirectionId(), tripB.getDirectionId())) {
            return "directionId";
        }
        if (!this.equals(tripA.getRoute(), tripB.getRoute())) {
            return "route";
        }
        if (!this.equals(tripA.getShapeId(), tripB.getShapeId())) {
            return "shapeId";
        }
        if (!this.equals(tripA.getTripHeadsign(), tripB.getTripHeadsign())) {
            return "tripHeadsign";
        }
        if (!this.equals(tripA.getTripShortName(), tripB.getTripShortName())) {
            return "tripShortName";
        }
        return null;
    }

    private boolean equals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private static class TripComparator
    implements Comparator<Trip> {
        private TripComparator() {
        }

        @Override
        public int compare(Trip o1, Trip o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }
}

