/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.factory;

import java.util.ArrayList;
import java.util.List;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.collections.IdKey;
import org.onebusaway.gtfs_transformer.collections.IdKeyMatch;
import org.onebusaway.gtfs_transformer.match.TypedEntityMatch;
import org.onebusaway.gtfs_transformer.services.EntityTransformStrategy;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class EntitiesTransformStrategy
implements GtfsTransformStrategy {
    private List<MatchAndTransform> _modifications = new ArrayList<MatchAndTransform>();

    public List<MatchAndTransform> getModifications() {
        return this._modifications;
    }

    public void addModification(TypedEntityMatch match, EntityTransformStrategy modification) {
        this._modifications.add(new MatchAndTransform(match, modification));
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        for (MatchAndTransform modification : this._modifications) {
            TypedEntityMatch match = modification.getMatch();
            Class<?> entityType = match.getType();
            EntityTransformStrategy transform = modification.getTransform();
            if (IdKey.class.isAssignableFrom(entityType)) {
                IdKeyMatch keyMatch = (IdKeyMatch)match.getPropertyMatches();
                transform.run(context, dao, keyMatch.getKey());
                continue;
            }
            ArrayList entities = new ArrayList(dao.getAllEntitiesForType(entityType));
            for (Object object : entities) {
                if (!match.isApplicableToObject(object)) continue;
                transform.run(context, dao, object);
            }
        }
    }

    public static class MatchAndTransform {
        private final TypedEntityMatch match;
        private final EntityTransformStrategy transform;

        public MatchAndTransform(TypedEntityMatch match, EntityTransformStrategy transform) {
            this.match = match;
            this.transform = transform;
        }

        public TypedEntityMatch getMatch() {
            return this.match;
        }

        public EntityTransformStrategy getTransform() {
            return this.transform;
        }
    }
}

