/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.csv.CSVUtil;
import org.onebusaway.gtfs_transformer.csv.MTAStationDirection;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MTAStationDirectionalityStrategy
implements GtfsTransformStrategy {
    private static Logger _log = LoggerFactory.getLogger(MTAStationDirectionalityStrategy.class);
    private String directionCsv;

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        File file = new File(this.directionCsv);
        if (!file.exists()) {
            throw new IllegalStateException("Direction file does not exist: " + file.getName());
        }
        List<MTAStationDirection> stationDirections = CSVUtil.readCsv(MTAStationDirection.class, this.directionCsv);
        HashMap<String, MTAStationDirection> dirByStation = new HashMap<String, MTAStationDirection>();
        for (MTAStationDirection dir : stationDirections) {
            if (dirByStation.get(dir.getGtfsStopId()) != null) {
                _log.error("Duplicate station: {}", (Object)dir.getGtfsStopId());
            }
            dirByStation.put(dir.getGtfsStopId(), dir);
        }
        for (StopTime st : dao.getAllStopTimes()) {
            MTAStationDirection dir = (MTAStationDirection)dirByStation.get(((Stop)st.getStop()).getParentStation());
            if (dir == null) {
                _log.debug("Missing station ID = {}", (Object)((Stop)st.getStop()).getParentStation());
                continue;
            }
            String stopId = st.getStop().getId().getId();
            String direction = stopId.substring(stopId.length() - 1);
            String headsign = null;
            if ("N".equals(direction)) {
                headsign = dir.getNorthDesc();
            } else if ("S".equals(direction)) {
                headsign = dir.getSouthDesc();
            }
            if (headsign == null || headsign.equals("n/a")) continue;
            st.setStopHeadsign(headsign);
        }
    }

    public void setDirectionCsv(String directionCsv) {
        this.directionCsv = directionCsv;
    }
}

