/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceDataFactoryImpl;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs.services.calendar.CalendarService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.CalendarSimplicationLibrary;
import org.onebusaway.gtfs_transformer.updates.UpdateLibrary;

public class ShiftNegativeStopTimesUpdateStrategy
implements GtfsTransformStrategy {
    private static final int SECONDS_IN_DAY = 86400;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        HashSet<ShiftedServiceCalendar> shiftedIds = new HashSet<ShiftedServiceCalendar>();
        for (Trip trip : dao.getAllTrips()) {
            List stopTimes = dao.getStopTimesForTrip(trip);
            int minTime = this.getMinStopTime(stopTimes);
            if (minTime >= 0) continue;
            int dayShift = this.getDayShiftForNegativeStopTime(minTime);
            this.shiftStopTimes(stopTimes, dayShift * 86400);
            ShiftedServiceCalendar shifted = new ShiftedServiceCalendar(trip.getServiceId(), -dayShift);
            shiftedIds.add(shifted);
            trip.setServiceId(shifted.getShiftedServiceId());
        }
        CalendarService calendarService = CalendarServiceDataFactoryImpl.createService((GtfsRelationalDao)dao);
        CalendarSimplicationLibrary library = new CalendarSimplicationLibrary();
        for (ShiftedServiceCalendar shifted : shiftedIds) {
            Set allServiceDates = calendarService.getServiceDatesForServiceId(shifted.getOriginalServiceId());
            Set<ServiceDate> shiftedServiceDates = this.shiftServiceDates(allServiceDates, shifted.getDayOffset());
            CalendarSimplicationLibrary.ServiceCalendarSummary summary = library.getSummaryForServiceDates(shiftedServiceDates);
            ArrayList<Object> newEntities = new ArrayList<Object>();
            library.computeSimplifiedCalendar(shifted.getShiftedServiceId(), summary, newEntities);
            for (Object e : newEntities) {
                dao.saveEntity(e);
            }
        }
        UpdateLibrary.clearDaoCache((GtfsRelationalDao)dao);
    }

    private int getMinStopTime(List<StopTime> stopTimes) {
        int minTime = Integer.MAX_VALUE;
        for (StopTime stopTime : stopTimes) {
            if (stopTime.isArrivalTimeSet()) {
                minTime = Math.min(minTime, stopTime.getArrivalTime());
            }
            if (!stopTime.isDepartureTimeSet()) continue;
            minTime = Math.min(minTime, stopTime.getDepartureTime());
        }
        return minTime;
    }

    private int getDayShiftForNegativeStopTime(int minTime) {
        return -((minTime - 86399) / 86400);
    }

    private void shiftStopTimes(List<StopTime> stopTimes, int time) {
        for (StopTime stopTime : stopTimes) {
            if (stopTime.isArrivalTimeSet()) {
                stopTime.setArrivalTime(stopTime.getArrivalTime() + time);
            }
            if (!stopTime.isDepartureTimeSet()) continue;
            stopTime.setDepartureTime(stopTime.getDepartureTime() + time);
        }
    }

    private Set<ServiceDate> shiftServiceDates(Set<ServiceDate> allServiceDates, int dayOffset) {
        HashSet<ServiceDate> shifted = new HashSet<ServiceDate>();
        for (ServiceDate date : allServiceDates) {
            shifted.add(date.shift(dayOffset));
        }
        return shifted;
    }

    private static class ShiftedServiceCalendar {
        private final AgencyAndId originalServiceId;
        private final int dayOffset;

        public ShiftedServiceCalendar(AgencyAndId originalServiceId, int dayOffset) {
            if (originalServiceId == null || dayOffset == 0) {
                throw new IllegalArgumentException();
            }
            this.originalServiceId = originalServiceId;
            this.dayOffset = dayOffset;
        }

        public AgencyAndId getOriginalServiceId() {
            return this.originalServiceId;
        }

        public int getDayOffset() {
            return this.dayOffset;
        }

        public AgencyAndId getShiftedServiceId() {
            String shiftedId = this.originalServiceId.getId() + " " + (this.dayOffset < 0 ? "-" : "+") + Math.abs(this.dayOffset);
            return new AgencyAndId(this.originalServiceId.getAgencyId(), shiftedId);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.dayOffset;
            result = 31 * result + this.originalServiceId.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ShiftedServiceCalendar other = (ShiftedServiceCalendar)obj;
            if (this.dayOffset != other.dayOffset) {
                return false;
            }
            return this.originalServiceId.equals((Object)other.originalServiceId);
        }
    }
}

