/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesBridgeFactory;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.CloudContextService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckForPlausibleStopTimes
implements GtfsTransformStrategy {
    private final int SECONDS_PER_MINUTE = 60;
    private final int MINUTES_PER_HOUR = 60;
    private final Logger _log = LoggerFactory.getLogger(CheckForPlausibleStopTimes.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        String feed = CloudContextService.getLikelyFeedName(dao);
        ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
        RemoveEntityLibrary removeEntityLibrary = new RemoveEntityLibrary();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        HashSet<Trip> stopsWarn = new HashSet<Trip>();
        HashSet<Trip> stopsRemove = new HashSet<Trip>();
        Object collectedWarnString = "";
        Object collectedRemoveString = "";
        block0: for (Trip trip : dao.getAllTrips()) {
            StopTime oldTime = new StopTime();
            boolean starting = true;
            for (StopTime newTime : dao.getStopTimesForTrip(trip)) {
                String message;
                Date arrival;
                Date departure;
                int timeDelta;
                if (starting) {
                    starting = false;
                    oldTime = newTime;
                }
                if ((timeDelta = newTime.getArrivalTime() - oldTime.getDepartureTime()) > 3600) {
                    departure = new Date(oldTime.getDepartureTime() * 1000);
                    arrival = new Date(newTime.getArrivalTime() * 1000);
                    message = "Trip " + trip.getId().getId() + " on Route " + String.valueOf(trip.getRoute().getId()) + " is scheduled for unrealistic transit time (>1hr) when traveling between stoptime" + oldTime.getId() + " at " + sdf.format(departure) + ", and stoptime" + newTime.getId() + " at " + sdf.format(arrival);
                    this._log.warn(message);
                    stopsWarn.add(trip);
                    collectedWarnString = (String)collectedWarnString + ", " + trip.toString() + "at " + sdf.format(departure) + "and " + sdf.format(arrival);
                }
                if (timeDelta > 10800) {
                    departure = new Date(oldTime.getDepartureTime() * 1000);
                    arrival = new Date(newTime.getArrivalTime() * 1000);
                    message = "Trip " + trip.getId().getId() + " on Route " + String.valueOf(trip.getRoute().getId()) + " is scheduled for unrealistic transit time (>3hr) when traveling between stoptime" + oldTime.getId() + " at " + sdf.format(departure) + ", and stoptime" + newTime.getId() + " at " + sdf.format(arrival) + ". This trip will be deleted.";
                    this._log.error(message);
                    collectedRemoveString = (String)collectedRemoveString + ", " + trip.toString();
                    stopsRemove.add(trip);
                    continue block0;
                }
                oldTime = newTime;
            }
        }
        if (stopsWarn.size() > 0) {
            collectedWarnString = "Total number of trips with transit times of greater than one hour: " + stopsWarn.size() + ".\n Here are the trips and stops: " + ((String)collectedWarnString).substring(2);
            this._log.info((String)collectedWarnString);
        }
        es.publishMetric(CloudContextService.getNamespace(), "TripsWith1-3HrTransitTime", "feed", feed, (double)stopsWarn.size());
        if (stopsRemove.size() > 0) {
            collectedRemoveString = "Total number of trips with transit times of greater than three hours: " + stopsRemove.size() + ".\n These trips are being removed. \nTrips being removed: " + ((String)collectedRemoveString).substring(2);
            this._log.info((String)collectedRemoveString);
        }
        es.publishMetric(CloudContextService.getNamespace(), "TripsWithRemovedForTransitTime", "feed", feed, (double)stopsRemove.size());
        for (Trip trip : stopsRemove) {
            removeEntityLibrary.removeTrip(dao, trip);
        }
    }
}

