/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.Collection;
import java.util.List;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.CheckForLengthyRouteNames;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnsureDirectionIdExists
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(CheckForLengthyRouteNames.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        Collection trips = dao.getAllTrips();
        for (Trip trip : trips) {
            if (trip.getDirectionId() != null) continue;
            trip.setDirectionId(this.getDirectionForTrip(dao, trip));
            dao.saveOrUpdateEntity((Object)trip);
        }
    }

    private String getDirectionForTrip(GtfsMutableRelationalDao dao, Trip trip) {
        List stopTimes = dao.getStopTimesForTrip(trip);
        Stop s1 = dao.getStopForId(((StopTime)stopTimes.get(0)).getStop().getId());
        Stop s2 = dao.getStopForId(((StopTime)stopTimes.get(stopTimes.size() - 1)).getStop().getId());
        return String.valueOf(this.getDirectionFromStops(s1, s2));
    }

    private int getDirectionFromStops(Stop s1, Stop s2) {
        double x = s1.getLon() - s2.getLon();
        double y = s1.getLat() - s2.getLat();
        if (y / x > 0.5 | y / x < -0.5) {
            if (y > 0.0) {
                return 0;
            }
            return 1;
        }
        if (x > 0.0) {
            return 0;
        }
        return 1;
    }
}

