/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesBridgeFactory;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.Pathway;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsDao;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.csv.CSVUtil;
import org.onebusaway.gtfs_transformer.csv.MTAElevator;
import org.onebusaway.gtfs_transformer.csv.MTAEntrance;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.util.PathwayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MTAEntrancesStrategy
implements GtfsTransformStrategy {
    private static final int LOCATION_TYPE_STOP = 0;
    private static final int LOCATION_TYPE_STATION = 1;
    private static final int LOCATION_TYPE_ENTRANCE = 2;
    private static final int LOCATION_TYPE_PAYGATE = 3;
    private static final int LOCATION_TYPE_GENERIC = 4;
    static final int WHEELCHAIR_ACCESSIBLE = 1;
    static final int NOT_WHEELCHAIR_ACCESSIBLE = 2;
    private static final String DEFAULT_MEZZ = "default";
    private static final String STOP_SEPARATOR = " ";
    private static final Logger _log = LoggerFactory.getLogger(MTAEntrancesStrategy.class);
    private static final List<String> accessibleEntranceTypes = Arrays.asList("Ramp", "Walkway", "Road_Walkway", "Elevator", "Door", "Entrance", "Tunnel");
    @CsvField(ignore=true)
    private Set<AgencyAndId> stopIdsWithPathways = new HashSet<AgencyAndId>();
    @CsvField(ignore=true)
    private Map<String, Stop> complexStopIds = new HashMap<String, Stop>();
    @CsvField(ignore=true)
    private String agencyId;
    @CsvField(ignore=true)
    private Collection<Stop> newStops;
    @CsvField(ignore=true)
    private Collection<Pathway> newPathways;
    @CsvField(ignore=true)
    private PathwayUtil pathwayUtil;
    @CsvField(optional=true)
    private String elevatorsCsv;
    private String entrancesCsv;
    @CsvField(optional=true)
    private String accessibleComplexFile;
    private boolean stopsHaveParents;
    private boolean createMissingLinks;
    private boolean contextualAccessibility;
    @CsvField(optional=true)
    private boolean markStopsAccessible = false;
    @CsvField(optional=true)
    private boolean skipStopsWithExistingPathways = true;
    @CsvField(optional=true)
    private int genericPathwayTraversalTime = 60;
    @CsvField(optional=true)
    private int stairTraversalTime = 60;
    @CsvField(optional=true)
    private int escalatorTraversalTime = 60;
    @CsvField(optional=true)
    private int walkwayTraversalTime = 60;
    @CsvField(optional=true)
    private int elevatorTraversalTime = 120;

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        Object elevatorsFile;
        File entrancesFile;
        ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
        Collection feedInfos = dao.getAllFeedInfos();
        String feed = null;
        if (feedInfos.size() > 0) {
            feed = ((FeedInfo)feedInfos.iterator().next()).getPublisherName();
        }
        if (!(entrancesFile = new File(this.entrancesCsv)).exists()) {
            es.publishMultiDimensionalMetric(this.getNamespace(), "MissingControlFiles", new String[]{"feed", "controlFileName"}, new String[]{feed, this.entrancesCsv}, 1.0);
            throw new IllegalStateException("Entrances file does not exist: " + entrancesFile.getName());
        }
        if (this.elevatorsCsv != null && !((File)(elevatorsFile = new File(this.elevatorsCsv))).exists()) {
            es.publishMultiDimensionalMetric(this.getNamespace(), "MissingControlFiles", new String[]{"feed", "controlFileName"}, new String[]{feed, this.elevatorsCsv}, 1.0);
            throw new IllegalStateException("Elevators file does not exist: " + ((File)elevatorsFile).getName());
        }
        _log.info("elevatorCsv={}, entrancesCsv={}, accessibleComplexFile={}", new Object[]{this.elevatorsCsv, this.entrancesCsv, this.accessibleComplexFile});
        this.agencyId = ((Agency)dao.getAllAgencies().iterator().next()).getId();
        this.newStops = new HashSet<Stop>();
        this.newPathways = new HashSet<Pathway>();
        this.pathwayUtil = new PathwayUtil(this.agencyId, this.newPathways);
        for (Pathway pathway : dao.getAllPathways()) {
            this.stopIdsWithPathways.add(pathway.getFromStop().getId());
            this.stopIdsWithPathways.add(pathway.getToStop().getId());
        }
        HashMap<String, StopGroup> stopGroups = new HashMap<String, StopGroup>();
        for (Stop stop : dao.getAllStops()) {
            if (this.stopsHaveParents) {
                String gid;
                String string = gid = stop.getLocationType() == 0 ? stop.getParentStation() : stop.getId().getId();
                if (gid == null) {
                    gid = stop.getId().getId();
                    if (stop.getName().contains("SHUTTLE BUS STOP")) continue;
                    _log.warn("stop {} didn't have a parent set--using own stop ID.", (Object)stop.getName());
                    continue;
                }
                StopGroup group = (StopGroup)stopGroups.get(gid);
                if (group == null) {
                    group = new StopGroup();
                    stopGroups.put(gid, group);
                }
                if (stop.getLocationType() == 1) {
                    group.parent = stop;
                    continue;
                }
                if (stop.getId().getId().endsWith("S")) {
                    group.downtown = stop;
                    continue;
                }
                if (stop.getId().getId().endsWith("N")) {
                    group.uptown = stop;
                    continue;
                }
                if (stop.getLocationType() >= 2 || stop.getName().contains("SHUTTLE BUS STOP")) continue;
                _log.error("unexpected stop not of parent type but of {} for stop {}: {}", new Object[]{stop.getLocationType(), stop.getId(), stop.getName()});
                continue;
            }
            StopGroup group = new StopGroup();
            group.parent = stop;
            String gid = stop.getId().getId();
            stopGroups.put(gid, group);
        }
        this.readEntranceData(stopGroups);
        if (this.elevatorsCsv != null) {
            this.readElevatorData(stopGroups, this.getComplexList((GtfsDao)dao));
        }
        _log.info("found {} complex stops to mark as accessible and mark={}", (Object)this.complexStopIds.size(), (Object)this.markStopsAccessible);
        if (this.markStopsAccessible) {
            for (String idOnly : this.complexStopIds.keySet()) {
                Stop stop = this.complexStopIds.get(idOnly);
                stop.setWheelchairBoarding(1);
                _log.info("marking stop {} as accessible", (Object)stop.getId());
                dao.updateEntity((Object)stop);
            }
        }
        for (Stop s : this.newStops) {
            dao.saveEntity((Object)s);
        }
        for (Pathway pathway : this.newPathways) {
            dao.saveEntity((Object)pathway);
        }
    }

    private void readEntranceData(Map<String, StopGroup> stopGroups) {
        ArrayList<String> whitelist = new ArrayList<String>(Arrays.asList("Door", "Escalator", "Ramp", "Stair", "Walkway", "Stair_Escalator", "Road_Walkway", "Entrance", "Tunnel"));
        if (this.contextualAccessibility) {
            whitelist.add("Elevator");
        }
        List<MTAEntrance> entrances = this.getEntrances();
        for (MTAEntrance e : entrances) {
            if (!whitelist.contains(e.getEntranceType()) || !e.hasLocation()) continue;
            StopGroup g = stopGroups.get(e.getStopId());
            if (g == null) {
                _log.error("No stop group for station {}", (Object)e.getStopId());
                continue;
            }
            g.entrances.add(e);
        }
        for (StopGroup group : stopGroups.values()) {
            if (this.skipStopsWithExistingPathways && (group.parent != null && this.stopIdsWithPathways.contains(group.parent.getId()) || group.uptown != null && this.stopIdsWithPathways.contains(group.uptown.getId()) || group.downtown != null && this.stopIdsWithPathways.contains(group.downtown.getId()))) {
                _log.info("Stop {} already has pathways from other sources; skipping.", (Object)group);
                continue;
            }
            if (group.entrances.isEmpty() && this.createMissingLinks) {
                _log.error("Station {} has no entrances", (Object)group.parent.getId());
                Stop entrance = this.createNonAccessibleStreetEntrance(group.parent);
                this.pathwayUtil.createPathway(entrance, group.uptown, 1, this.genericPathwayTraversalTime, "GENERIC", null);
                this.pathwayUtil.createPathway(entrance, group.downtown, 1, this.genericPathwayTraversalTime, "GENERIC", null);
                continue;
            }
            int i = 0;
            for (MTAEntrance entrance : group.entrances) {
                int pathwayMode;
                Stop entranceStop = this.createStopFromMTAEntrance(group.parent, entrance, i);
                if (entranceStop == null) {
                    _log.error("data issue with entrance={}", (Object)entrance.getStopId());
                    continue;
                }
                int traversalTime = switch (entrance.getEntranceType()) {
                    case "Stair_Escalator", "Stair" -> {
                        pathwayMode = 2;
                        yield this.stairTraversalTime;
                    }
                    case "Ramp", "Walkway", "Road_Walkway" -> {
                        pathwayMode = 2;
                        yield this.walkwayTraversalTime;
                    }
                    case "Escalator" -> {
                        pathwayMode = 4;
                        yield this.escalatorTraversalTime;
                    }
                    case "Elevator" -> {
                        pathwayMode = 5;
                        yield this.elevatorTraversalTime;
                    }
                    default -> {
                        pathwayMode = 2;
                        yield this.genericPathwayTraversalTime;
                    }
                };
                String id = entrance.getEntranceType() + "-" + i;
                if (this.stopsHaveParents) {
                    if (!entrance.hasDirection() || entrance.getDirection().equals("N")) {
                        if (group.uptown != null) {
                            this.pathwayUtil.createPathway(entranceStop, group.uptown, pathwayMode, traversalTime, id, null);
                        } else {
                            _log.warn("Entrance file refers to stop {} and direction {} which is not in the GTFS. Check your data.", (Object)entrance.getStopId(), (Object)entrance.getDirection());
                        }
                    }
                    if (!entrance.hasDirection() || entrance.getDirection().equals("S")) {
                        if (group.downtown != null) {
                            this.pathwayUtil.createPathway(entranceStop, group.downtown, pathwayMode, traversalTime, id, null);
                        } else {
                            _log.warn("Entrance file refers to stop {} and direction {} which is not in the GTFS. Check your data.", (Object)entrance.getStopId(), (Object)entrance.getDirection());
                        }
                    }
                } else {
                    this.pathwayUtil.createPathway(entranceStop, group.parent, pathwayMode, traversalTime, id, null);
                }
                ++i;
            }
        }
    }

    private void readElevatorData(Map<String, StopGroup> stopGroups, Map<String, List<Stop>> complexIdToStops) {
        List<MTAElevator> elevators = this.getElevators();
        for (MTAElevator e : elevators) {
            StopGroup g = stopGroups.get(e.getStopId());
            if (g == null) {
                _log.error("No stop group for elevator={}, stop={}", (Object)e.getId(), (Object)e.getStopId());
                continue;
            }
            g.elevators.add(e);
        }
        int unknown = 0;
        for (StopGroup group : stopGroups.values()) {
            if (this.skipStopsWithExistingPathways && (group.parent != null && this.stopIdsWithPathways.contains(group.parent.getId()) || group.uptown != null && this.stopIdsWithPathways.contains(group.uptown.getId()) || group.downtown != null && this.stopIdsWithPathways.contains(group.downtown.getId()))) {
                _log.info("Stop {} already has pathways from other sources; skipping.", (Object)group);
                continue;
            }
            Stop entrance = null;
            HashSet<String> seenElevatorPathways = new HashSet<String>();
            HashMap<String, Object> mezzByName = new HashMap<String, Object>();
            for (MTAElevator e : group.elevators) {
                String id;
                Stop mezz;
                String id_base;
                ElevatorPathwayType type = ElevatorPathwayType.valueOf(e.getLoc());
                type.resolveElevatorNames(e);
                if (type == ElevatorPathwayType.UNKNOWN) {
                    ++unknown;
                    _log.debug("unknown type={}, elev={}", (Object)e.getLoc(), (Object)e.getId());
                    continue;
                }
                if (entrance == null && type.shouldCreateStreetEntrance()) {
                    entrance = this.createAccessibleStreetEntrance(group.parent);
                }
                Stop platform = null;
                if (e.getDirection() != null) {
                    if (e.getDirection().equals("N")) {
                        platform = group.uptown;
                        if (platform == null) {
                            _log.warn("Elevator file refers to platform {} and direction {} which is not in the GTFS. Check your data.", (Object)e.getStopId(), (Object)e.getDirection());
                            continue;
                        }
                    } else if (e.getDirection().equals("S")) {
                        platform = group.downtown;
                        if (platform == null) {
                            _log.warn("Elevator file refers to platform {} and direction {} which is not in the GTFS. Check your data.", (Object)e.getStopId(), (Object)e.getDirection());
                            continue;
                        }
                    } else {
                        _log.error("Unexpected direction={}, elev={}", (Object)e.getDirection(), (Object)e.getId());
                    }
                }
                if (type.mezzanineNames != null) {
                    ArrayList newMezzanineNames = new ArrayList();
                    for (String name : type.mezzanineNames) {
                        boolean partOfComplex = false;
                        for (String complexId : complexIdToStops.keySet()) {
                            List<Stop> stopsInComplex = complexIdToStops.get(complexId);
                            if (!stopsInComplex.contains(platform)) continue;
                            newMezzanineNames.add(complexId + "-mezz-" + name);
                            partOfComplex = true;
                            break;
                        }
                        if (partOfComplex) continue;
                        newMezzanineNames.add(group.parent.getId().getId() + "-mezz-" + name);
                    }
                    type.mezzanineNames = newMezzanineNames;
                }
                if (type.shouldCreateMezzanine()) {
                    for (String name : type.mezzanineNames) {
                        Object m = (Stop)mezzByName.get(name);
                        if (m != null) continue;
                        m = this.createMezzanineWithId(group.parent, new AgencyAndId(platform.getId().getAgencyId(), name));
                        mezzByName.put(name, m);
                    }
                }
                String code = e.getId();
                if (type.shouldCreateStreetToMezzanine()) {
                    id_base = "S2M_" + code;
                    for (String name : type.mezzanineNames) {
                        mezz = (Stop)mezzByName.get(name);
                        id = id_base + "_" + name;
                        this.createElevPathways(entrance, mezz, code, id, seenElevatorPathways);
                    }
                }
                if (type.shouldCreateMezzanineToPlatform()) {
                    id_base = "M2P_" + code + "_" + e.getDirection();
                    for (String name : type.mezzanineNames) {
                        mezz = (Stop)mezzByName.get(name);
                        id = id_base + "_" + name;
                        this.createElevPathways(mezz, platform, code, id, seenElevatorPathways);
                    }
                }
                if (type.shouldCreateStreetToPlatform()) {
                    String id2 = "S2P_" + code + "_" + e.getDirection();
                    this.createElevPathways(entrance, platform, code, id2, seenElevatorPathways);
                }
                if (!type.shouldCreateMezzanineToMezzanine()) continue;
                for (int i = 0; i < type.mezzanineNames.size(); ++i) {
                    for (int j = i + 1; j < type.mezzanineNames.size(); ++j) {
                        String name0 = type.mezzanineNames.get(i);
                        String name1 = type.mezzanineNames.get(j);
                        Stop mezz0 = (Stop)mezzByName.get(name0);
                        Stop mezz1 = (Stop)mezzByName.get(name1);
                        String id3 = "M2M_" + code + "_" + name0 + "_" + name1;
                        this.createElevPathways(mezz0, mezz1, code, id3, seenElevatorPathways);
                    }
                }
            }
        }
        _log.info("Processed {} / {} ({} are unknown)", new Object[]{elevators.size() - unknown, elevators.size(), unknown});
    }

    private Map<String, List<Stop>> getComplexList(GtfsDao dao) {
        Map<String, Stop> stops = this.getStopMap(dao);
        HashMap<String, List<Stop>> complexes = new HashMap<String, List<Stop>>();
        try (BufferedReader br = new BufferedReader(new FileReader(new File(this.accessibleComplexFile)));){
            String line;
            while ((line = br.readLine()) != null) {
                ArrayList<Stop> complex = new ArrayList<Stop>();
                for (String id : line.split(STOP_SEPARATOR)) {
                    Stop stop = stops.get(id);
                    if (stop == null) {
                        _log.info("null stop: {}", (Object)id);
                    }
                    complex.add(stop);
                    this.complexStopIds.put(id, stop);
                }
                complexes.put("complex-" + String.valueOf(UUID.randomUUID()), complex);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return complexes;
    }

    private Map<String, Stop> getStopMap(GtfsDao dao) {
        HashMap<String, Stop> map = new HashMap<String, Stop>();
        for (Stop stop : dao.getAllStops()) {
            if (stop.getLocationType() != 0) continue;
            map.put(stop.getId().getId(), stop);
        }
        return map;
    }

    private Stop createStopFromMTAEntrance(Stop parent, MTAEntrance ent, int num) {
        Stop entrance;
        int wheelchairFlag = 2;
        if (this.contextualAccessibility && accessibleEntranceTypes.contains(ent.getEntranceType())) {
            wheelchairFlag = 1;
        }
        if ((entrance = this.createStop(parent, 2, wheelchairFlag, "entrance-" + num)) == null) {
            return null;
        }
        entrance.setLat(ent.getLatitude().doubleValue());
        entrance.setLon(ent.getLongitude().doubleValue());
        return entrance;
    }

    private Stop createNonAccessibleStreetEntrance(Stop parent) {
        return this.createStop(parent, 2, 2, "ent");
    }

    private Stop createAccessibleStreetEntrance(Stop parent) {
        return this.createStop(parent, 2, 1, "ent-acs");
    }

    private Stop createMezzanineWithId(Stop parent, AgencyAndId id) {
        return this.createStop(id, parent, 4, 1);
    }

    private Stop createStop(Stop stop, int locationType, int wheelchairAccessible, String suffix) {
        AgencyAndId id = new AgencyAndId();
        id.setAgencyId(this.agencyId);
        id.setId(stop.getId().getId() + "-" + suffix);
        return this.createStop(id, stop, locationType, wheelchairAccessible);
    }

    private Stop createStop(AgencyAndId id, Stop stop, int locationType, int wheelchairAccessible) {
        if (stop == null) {
            return null;
        }
        Stop entrance = new Stop();
        entrance.setId(id);
        entrance.setName(stop.getName());
        entrance.setLat(stop.getLat());
        entrance.setLon(stop.getLon());
        entrance.setLocationType(locationType);
        entrance.setWheelchairBoarding(wheelchairAccessible);
        entrance.setParentStation(stop.getId().getId());
        this.newStops.add(entrance);
        return entrance;
    }

    private void createElevPathways(Stop from, Stop to, String code, String idStr, Set<String> seenElevatorPathways) {
        if (seenElevatorPathways.contains(idStr)) {
            _log.debug("Duplicate elevator pathway id={}", (Object)code);
            return;
        }
        seenElevatorPathways.add(idStr);
        if (from == null || to == null) {
            _log.error("The from or to vertex is null");
            return;
        }
        this.pathwayUtil.createPathway(from, to, 5, this.elevatorTraversalTime, idStr, code);
    }

    private String getTopic() {
        return System.getProperty("sns.topic");
    }

    private List<MTAElevator> getElevators() {
        return CSVUtil.readCsv(MTAElevator.class, this.elevatorsCsv);
    }

    private List<MTAEntrance> getEntrances() {
        return CSVUtil.readCsv(MTAEntrance.class, this.entrancesCsv);
    }

    public void setElevatorsCsv(String elevatorsCsv) {
        this.elevatorsCsv = elevatorsCsv;
    }

    public void setEntrancesCsv(String entrancesCsv) {
        this.entrancesCsv = entrancesCsv;
    }

    public void setAccessibleComplexFile(String accessibleCsv) {
        this.accessibleComplexFile = accessibleCsv;
    }

    public void setGenericPathwayTraversalTime(int genericPathwayTraversalTime) {
        this.genericPathwayTraversalTime = genericPathwayTraversalTime;
    }

    public void setStairTraversalTime(int stairTraversalTime) {
        this.stairTraversalTime = stairTraversalTime;
    }

    public void setEscalatorTraversalTime(int escalatorTraversalTime) {
        this.escalatorTraversalTime = escalatorTraversalTime;
    }

    public void setWalkwayTraversalTime(int walkwayTraveralTime) {
        this.walkwayTraversalTime = walkwayTraveralTime;
    }

    public void setElevatorTraversalTime(int elevatorTraversalTime) {
        this.elevatorTraversalTime = elevatorTraversalTime;
    }

    public void setStopsHaveParents(boolean stopsHaveParents) {
        this.stopsHaveParents = stopsHaveParents;
    }

    public void setCreateMissingLinks(boolean createMissingLinks) {
        this.createMissingLinks = createMissingLinks;
    }

    public void setSkipStopsWithExistingPathways(boolean skipStopsWithExistingPathways) {
        this.skipStopsWithExistingPathways = skipStopsWithExistingPathways;
    }

    public void setContextualAccessibility(boolean contextualAccessibility) {
        this.contextualAccessibility = contextualAccessibility;
    }

    private String getNamespace() {
        return System.getProperty("cloudwatch.namespace");
    }

    public void setMarkStopsAccessible(boolean flag) {
        this.markStopsAccessible = flag;
    }

    private class StopGroup {
        Stop uptown;
        Stop downtown;
        Stop parent;
        List<MTAElevator> elevators = new ArrayList<MTAElevator>();
        List<MTAEntrance> entrances = new ArrayList<MTAEntrance>();

        private StopGroup() {
        }

        public int hashCode() {
            return this.parent.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof StopGroup)) {
                return false;
            }
            return this.parent.equals((Object)((StopGroup)o).parent);
        }

        public String toString() {
            return String.valueOf(this.parent) + " -> (" + String.valueOf(this.uptown) + "," + String.valueOf(this.downtown) + ")";
        }
    }

    private static enum ElevatorPathwayType {
        STREET_TO_MEZZ_TO_PLATFORM,
        STREET_TO_MEZZ,
        MEZZ_TO_PLATFORM,
        STREET_TO_PLATFORM,
        MEZZ_TO_MEZZ,
        MEZZ_TO_MEZZ_TO_STREET,
        MEZZ_TO_MEZZ_TO_PLATFORM,
        MEZZ_TO_MEZZ_TO_STREET_TO_PLATFORM,
        UNKNOWN;

        List<String> mezzanineNames;

        boolean shouldCreateStreetEntrance() {
            return this == STREET_TO_MEZZ || this == MEZZ_TO_MEZZ_TO_STREET || this == STREET_TO_MEZZ_TO_PLATFORM || this == STREET_TO_PLATFORM || this == MEZZ_TO_MEZZ_TO_STREET_TO_PLATFORM;
        }

        boolean shouldCreateMezzanine() {
            return this == STREET_TO_MEZZ_TO_PLATFORM | this == STREET_TO_MEZZ || this == MEZZ_TO_PLATFORM || this == MEZZ_TO_MEZZ || this == MEZZ_TO_MEZZ_TO_STREET || this == MEZZ_TO_MEZZ_TO_PLATFORM || this == MEZZ_TO_MEZZ_TO_STREET_TO_PLATFORM;
        }

        boolean shouldCreateStreetToMezzanine() {
            return this == STREET_TO_MEZZ_TO_PLATFORM || this == STREET_TO_MEZZ || this == MEZZ_TO_MEZZ_TO_STREET || this == MEZZ_TO_MEZZ_TO_STREET_TO_PLATFORM;
        }

        boolean shouldCreateMezzanineToPlatform() {
            return this == STREET_TO_MEZZ_TO_PLATFORM || this == MEZZ_TO_PLATFORM || this == MEZZ_TO_MEZZ_TO_PLATFORM || this == MEZZ_TO_MEZZ_TO_STREET_TO_PLATFORM;
        }

        boolean shouldCreateStreetToPlatform() {
            return this == STREET_TO_MEZZ_TO_PLATFORM || this == STREET_TO_PLATFORM || this == MEZZ_TO_MEZZ_TO_STREET_TO_PLATFORM;
        }

        boolean shouldCreateMezzanineToMezzanine() {
            return this == MEZZ_TO_MEZZ || this == MEZZ_TO_MEZZ_TO_STREET || this == MEZZ_TO_MEZZ_TO_PLATFORM || this == MEZZ_TO_MEZZ_TO_STREET_TO_PLATFORM;
        }

        void resolveElevatorNames(MTAElevator e) {
            String mezz1 = e.getMezzanineName1();
            String mezz2 = e.getMezzanineName2();
            switch (this.ordinal()) {
                case 0: 
                case 1: 
                case 2: {
                    if (mezz1 != null) {
                        this.mezzanineNames = Collections.singletonList(mezz1);
                        break;
                    }
                    this.mezzanineNames = Collections.singletonList(MTAEntrancesStrategy.DEFAULT_MEZZ);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (mezz1 == null | mezz2 == null) {
                        throw new IllegalArgumentException("elevators with >1 mezzanine require names: " + e.getId());
                    }
                    this.mezzanineNames = Arrays.asList(mezz1, mezz2);
                }
            }
        }
    }
}

