/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesBridgeFactory;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.InputLibrary;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.CloudContextService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateStopIdFromControlStrategy
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(UpdateStopIdFromControlStrategy.class);
    private static final int LOCATION_NAME_INDEX = 0;
    private static final int DIRECTION = 3;
    private static final int ATIS_ID_INDEX = 6;
    @CsvField(ignore=true)
    private String _referenceAgencyId = null;
    @CsvField(ignore=true)
    private String _daoAgencyId = null;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        RemoveEntityLibrary removeEntityLibrary = new RemoveEntityLibrary();
        File controlFile = new File((String)context.getParameter("controlFile"));
        ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
        String feed = CloudContextService.getLikelyFeedName(dao);
        if (!controlFile.exists()) {
            es.publishMultiDimensionalMetric(CloudContextService.getNamespace(), "MissingControlFiles", new String[]{"feed", "controlFileName"}, new String[]{feed, controlFile.getName()}, 1.0);
            throw new IllegalStateException("Control file does not exist: " + controlFile.getName());
        }
        List<String> controlLines = new InputLibrary().readList((String)context.getParameter("controlFile"));
        int matched = 0;
        int unmatched = 0;
        int duplicate = 0;
        boolean inCntrlRefNotAtis = false;
        ArrayList<AgencyAndId> stopsToRemove = new ArrayList<AgencyAndId>();
        HashMap<AgencyAndId, AgencyAndId> stopsUpdated = new HashMap<AgencyAndId, AgencyAndId>();
        HashMap<String, Stop> referenceStops = new HashMap<String, Stop>();
        for (Stop stop : reference.getAllStops()) {
            referenceStops.put(stop.getId().getId(), stop);
        }
        AgencyAndId agencyAndId = ((Stop)dao.getAllStops().iterator().next()).getId();
        for (String controlLine : controlLines) {
            Stop refStop;
            String[] controlArray = controlLine.split(",");
            if (controlArray == null || controlArray.length < 2) {
                this._log.info("bad control line {}", (Object)controlLine);
                continue;
            }
            String referenceId = controlArray[0];
            String direction = controlArray[3];
            String atisId = controlArray[6];
            if (direction.isEmpty()) {
                refStop = (Stop)referenceStops.get(referenceId);
                if (refStop == null) {
                    if (!atisId.equals("0")) {
                        // empty if block
                    }
                    ++unmatched;
                    continue;
                }
            } else {
                refStop = (Stop)referenceStops.get(referenceId + direction);
                if (refStop == null) {
                    if (!atisId.equals("0")) {
                        // empty if block
                    }
                    ++unmatched;
                    continue;
                }
            }
            Stop atisStop = dao.getStopForId(new AgencyAndId(agencyAndId.getAgencyId(), atisId));
            if (stopsUpdated.containsKey(refStop.getId())) {
                ++duplicate;
                Stop persistStop = dao.getStopForId((AgencyAndId)stopsUpdated.get(refStop.getId()));
                stopsToRemove.add(new AgencyAndId(agencyAndId.getAgencyId(), atisId));
                for (StopTime stopTime : dao.getStopTimesForStop(atisStop)) {
                    stopTime.setStop((StopLocation)persistStop);
                }
                continue;
            }
            if (atisStop == null) {
                if (!atisId.equals("0")) {
                    // empty if block
                }
                ++unmatched;
                continue;
            }
            atisStop.setName(refStop.getName());
            atisStop.setDirection(refStop.getDirection());
            atisStop.setId(refStop.getId());
            atisStop.setParentStation(refStop.getParentStation());
            atisStop.setLocationType(refStop.getLocationType());
            stopsUpdated.put(atisStop.getId(), new AgencyAndId(agencyAndId.getAgencyId(), atisId));
            dao.updateEntity((Object)atisStop);
            ++matched;
        }
        this._log.info("Complete with {} matched and {} unmatched and {} duplicates", new Object[]{matched, unmatched, duplicate});
        for (AgencyAndId id : stopsToRemove) {
            Stop stop = dao.getStopForId(id);
            if (stop != null) {
                dao.removeEntity((IdentityBean)stop);
                continue;
            }
            this._log.info("expecting stop {} but it was not found", (Object)id);
        }
    }

    private String getReferenceAgencyId(GtfsMutableRelationalDao dao) {
        if (this._referenceAgencyId == null) {
            this._referenceAgencyId = ((Agency)dao.getAllAgencies().iterator().next()).getId();
        }
        return this._referenceAgencyId;
    }

    private String getDaoAgencyId(GtfsMutableRelationalDao dao) {
        if (this._daoAgencyId == null) {
            this._daoAgencyId = ((Agency)dao.getAllAgencies().iterator().next()).getId();
        }
        return this._daoAgencyId;
    }
}

