/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.util;

import java.util.Collection;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Pathway;
import org.onebusaway.gtfs.model.Stop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathwayUtil {
    private final Logger _log = LoggerFactory.getLogger(PathwayUtil.class);
    private String agencyId;
    private Collection<Pathway> newPathways;

    public PathwayUtil(String agencyId, Collection<Pathway> newPathways) {
        this.agencyId = agencyId;
        this.newPathways = newPathways;
    }

    public void createPathway(Stop from, Stop to, int mode, int traversalTime, String id, String code) {
        this.createPathway(from, to, mode, traversalTime, id, code, true);
    }

    public void createPathway(Stop from, Stop to, int mode, int traversalTime, String id, String code, boolean reverse) {
        if (to == null || to.getId() == null) {
            this._log.error("invalid to {}", (Object)to);
            return;
        }
        if (from == null || from.getId() == null) {
            this._log.error("invalid from {}", (Object)from);
            return;
        }
        Pathway pathway = new Pathway();
        pathway.setFromStop(from);
        pathway.setToStop(to);
        pathway.setPathwayMode(mode);
        pathway.setTraversalTime(traversalTime);
        pathway.setId(new AgencyAndId(this.agencyId, to.getId().getId() + "-" + id + "-IN"));
        if (reverse) {
            Pathway reversePathway = this.reverse(pathway, new AgencyAndId(this.agencyId, to.getId().getId() + "-" + id + "-OUT"));
            this.newPathways.add(reversePathway);
        }
        this.newPathways.add(pathway);
    }

    private Pathway reverse(Pathway p, AgencyAndId id) {
        Pathway q = new Pathway();
        q.setFromStop(p.getToStop());
        q.setToStop(p.getFromStop());
        q.setTraversalTime(p.getTraversalTime());
        q.setPathwayMode(p.getPathwayMode());
        q.setId(id);
        return q;
    }
}

