/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddOmnySubwayData
implements GtfsTransformStrategy {
    private static Logger _log = LoggerFactory.getLogger(AddOmnySubwayData.class);

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        int stop_count = 0;
        int route_count = 0;
        for (Stop stop : dao.getAllStops()) {
            stop.setRegionalFareCardAccepted(1);
            ++stop_count;
        }
        for (Route route : dao.getAllRoutes()) {
            route.setRegionalFareCardAccepted(1);
            ++route_count;
        }
        _log.info("Set {} stops and {} routes to omny_enabled Y", (Object)stop_count, (Object)route_count);
    }
}

