/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.ArrayList;
import java.util.HashMap;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeRouteAndRemoveShuttles
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(MergeRouteAndRemoveShuttles.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        RemoveEntityLibrary removeEntityLibrary = new RemoveEntityLibrary();
        HashMap<String, Route> referenceRoutes = new HashMap<String, Route>();
        for (Route route : reference.getAllRoutes()) {
            referenceRoutes.put(route.getId().getId(), route);
        }
        ArrayList<Route> routesToRemove = new ArrayList<Route>();
        for (Route route : dao.getAllRoutes()) {
            Route refRoute;
            String identifier = route.getId().getId();
            if (identifier.contains("-SS")) {
                this._log.info("Removing route: " + identifier);
                routesToRemove.add(route);
            } else if (identifier.length() > 2) {
                identifier = identifier.substring(0, 2);
            }
            if ((refRoute = (Route)referenceRoutes.get(identifier)) == null) continue;
            route.setShortName(refRoute.getShortName());
            route.setLongName(refRoute.getLongName());
            route.setType(refRoute.getType());
            route.setDesc(refRoute.getDesc());
            route.setUrl(refRoute.getUrl());
            route.setColor(refRoute.getColor());
            route.setTextColor(refRoute.getTextColor());
            route.setId(refRoute.getId());
        }
        for (Route route : routesToRemove) {
            removeEntityLibrary.removeRoute(dao, route);
        }
    }
}

