/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Transfer;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.collections.ServiceIdKey;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.EntityTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class RemoveEntityUpdateStrategy
implements EntityTransformStrategy {
    private RemoveEntityLibrary _library = new RemoveEntityLibrary();

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao, Object obj) {
        if (obj instanceof Agency) {
            this._library.removeAgency(dao, (Agency)obj);
        } else if (obj instanceof Route) {
            this._library.removeRoute(dao, (Route)obj);
        } else if (obj instanceof Stop) {
            this._library.removeStop(dao, (Stop)obj);
        } else if (obj instanceof Trip) {
            this._library.removeTrip(dao, (Trip)obj);
        } else if (obj instanceof StopTime) {
            this._library.removeStopTime(dao, (StopTime)obj);
        } else if (obj instanceof Frequency) {
            this._library.removeFrequency(dao, (Frequency)obj);
        } else if (obj instanceof ServiceCalendar) {
            this._library.removeServiceCalendar(dao, (ServiceCalendar)obj);
        } else if (obj instanceof ServiceCalendarDate) {
            this._library.removeServiceCalendarDate(dao, (ServiceCalendarDate)obj);
        } else if (obj instanceof ServiceIdKey) {
            this._library.removeCalendar(dao, ((ServiceIdKey)obj).getId());
        } else if (obj instanceof Transfer) {
            this._library.removeTransfer(dao, (Transfer)obj);
        } else if (obj instanceof FeedInfo) {
            this._library.removeFeedInfo(dao, (FeedInfo)obj);
        } else {
            throw new NoSuchMethodError("attempt to remove entity of type " + String.valueOf(obj.getClass()));
        }
    }
}

