/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.List;
import java.util.Map;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.TripsByBlockInSortedOrder;
import org.onebusaway.gtfs_transformer.updates.UpdateLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrivialStopTimeInterpolationStrategy
implements GtfsTransformStrategy {
    private static Logger _log = LoggerFactory.getLogger(TrivialStopTimeInterpolationStrategy.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        int updated = 0;
        int total = 0;
        Map<String, List<Trip>> tripsByBlockId = TripsByBlockInSortedOrder.getTripsByBlockInSortedOrder(dao);
        for (List<Trip> trips : tripsByBlockId.values()) {
            for (Trip trip : trips) {
                List stopTimes = dao.getStopTimesForTrip(trip);
                int i = 0;
                while (i < stopTimes.size()) {
                    StopTime stopTime = (StopTime)stopTimes.get(i);
                    ++total;
                    int matches = this.countMatches(stopTimes, i);
                    if (matches > 0) {
                        int increment = 60 / (matches + 1);
                        while (matches >= 0) {
                            stopTime.setArrivalTime(stopTime.getArrivalTime() - increment * matches);
                            stopTime.setDepartureTime(stopTime.getDepartureTime() - increment * matches);
                            --matches;
                            ++total;
                            stopTime = (StopTime)stopTimes.get(++i);
                            ++updated;
                        }
                        continue;
                    }
                    ++i;
                }
            }
        }
        _log.info("updated=" + updated + " total=" + total);
        UpdateLibrary.clearDaoCache((GtfsRelationalDao)dao);
    }

    private int countMatches(List<StopTime> stopTimes, int index) {
        int matches = 0;
        if (index < stopTimes.size() - 2) {
            StopTime current = stopTimes.get(index);
            StopTime next = stopTimes.get(index + 1);
            while (next.getArrivalTime() == current.getArrivalTime() && next.getDepartureTime() == current.getDepartureTime() && index + matches < stopTimes.size() - 2) {
                next = stopTimes.get(index + 1 + ++matches);
            }
        }
        return matches;
    }
}

