/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceDataFactoryImpl;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs.services.calendar.CalendarService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTripsForSdon
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(UpdateTripsForSdon.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        CalendarService refCalendarService = CalendarServiceDataFactoryImpl.createService((GtfsRelationalDao)reference);
        String agency = ((Trip)dao.getAllTrips().iterator().next()).getId().getAgencyId();
        HashMap<String, Object> referenceTrips = new HashMap<String, Object>();
        for (Object trip : reference.getAllTrips()) {
            referenceTrips.put(trip.getId().getId(), trip);
        }
        HashMap<String, Trip> atisTrips = new HashMap<String, Trip>();
        for (Trip trip : dao.getAllTrips()) {
            atisTrips.put(trip.getMtaTripId(), trip);
        }
        HashMap serviceDates = new HashMap();
        int service_id = this.getNextServiceId(dao);
        int countdao = 0;
        for (Map.Entry referenceTrip : referenceTrips.entrySet()) {
            String refId;
            String refIdMinusSDon;
            Trip refTrip = (Trip)referenceTrip.getValue();
            if (!refTrip.getId().getId().contains("SDon") || !atisTrips.containsKey(refIdMinusSDon = (refId = refTrip.getId().getId()).replace("-SDon", ""))) continue;
            Trip atisTrip = (Trip)atisTrips.get(refIdMinusSDon);
            Trip sdonAtisTrip = this.createTrip(dao, refTrip, atisTrip);
            Set refServiceDates = refCalendarService.getServiceDatesForServiceId(refTrip.getServiceId());
            ArrayList<ServiceDate> sdForTrip = new ArrayList<ServiceDate>();
            List atisCalendarDates = dao.getCalendarDatesForServiceId(atisTrip.getServiceId());
            for (ServiceCalendarDate atisScd : atisCalendarDates) {
                ServiceDate atisDate = atisScd.getDate();
                if (!refServiceDates.contains(atisDate)) continue;
                sdForTrip.add(atisDate);
            }
            AgencyAndId newServiceId = new AgencyAndId(agency, Integer.toString(service_id));
            if (serviceDates.isEmpty()) {
                serviceDates.put(Integer.toString(service_id), sdForTrip);
                newServiceId = new AgencyAndId(agency, Integer.toString(service_id));
                ++service_id;
            } else {
                boolean addNewServiceDate = true;
                for (Map.Entry entry : serviceDates.entrySet()) {
                    ArrayList scds = (ArrayList)entry.getValue();
                    if (!new HashSet(sdForTrip).equals(new HashSet(scds))) continue;
                    addNewServiceDate = false;
                    newServiceId = new AgencyAndId(agency, (String)entry.getKey());
                    sdonAtisTrip.setServiceId(newServiceId);
                }
                if (addNewServiceDate) {
                    serviceDates.put(Integer.toString(service_id), sdForTrip);
                    newServiceId = new AgencyAndId(agency, Integer.toString(service_id));
                    ++service_id;
                }
            }
            sdonAtisTrip.setServiceId(newServiceId);
            for (StopTime stopTime : dao.getStopTimesForTrip(atisTrip)) {
                StopTime stopTime2 = new StopTime();
                stopTime2.setTrip(sdonAtisTrip);
                stopTime2.setStop(stopTime.getStop());
                stopTime2.setArrivalTime(stopTime.getArrivalTime());
                stopTime2.setDepartureTime(stopTime.getDepartureTime());
                stopTime2.setStopSequence(stopTime.getStopSequence());
                stopTime2.setDropOffType(stopTime.getDropOffType());
                dao.saveOrUpdateEntity((Object)stopTime2);
                ++countdao;
            }
        }
        this._log.info("Adding {} service date ids. Next id {}", (Object)serviceDates.size(), (Object)this.getNextServiceId(dao));
        int serviceIds = 0;
        for (Map.Entry serviceDatesToAdd : serviceDates.entrySet()) {
            AgencyAndId newServiceId = new AgencyAndId(agency, (String)serviceDatesToAdd.getKey());
            ArrayList scds = (ArrayList)serviceDatesToAdd.getValue();
            for (ServiceDate sd : scds) {
                ++serviceIds;
                ServiceCalendarDate newScd = new ServiceCalendarDate();
                newScd.setServiceId(newServiceId);
                newScd.setDate(sd);
                newScd.setExceptionType(1);
                dao.saveOrUpdateEntity((Object)newScd);
            }
        }
        this._log.error("Dao count: {}.  Added Service dates: {}", (Object)countdao, (Object)serviceIds);
    }

    private Trip createTrip(GtfsMutableRelationalDao dao, Trip referenceTrip, Trip atisTrip) {
        Trip trip = new Trip();
        trip.setRoute(atisTrip.getRoute());
        trip.setId(referenceTrip.getId());
        trip.setTripHeadsign(atisTrip.getTripHeadsign());
        trip.setDirectionId(atisTrip.getDirectionId());
        trip.setShapeId(atisTrip.getShapeId());
        trip.setPeakOffpeak(atisTrip.getPeakOffpeak());
        trip.setMtaTripId(referenceTrip.getId().getId());
        dao.saveOrUpdateEntity((Object)trip);
        return trip;
    }

    private int getNextServiceId(GtfsMutableRelationalDao dao) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (ServiceCalendarDate svcDate : dao.getAllCalendarDates()) {
            if (!this.isInt(svcDate.getServiceId().getId())) continue;
            idList.add(Integer.parseInt(svcDate.getServiceId().getId()));
        }
        return (Integer)Collections.max(idList) + 1;
    }

    private boolean isInt(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }
}

