/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.List;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.InputLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateStopIdsFromFile
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(UpdateStopIdsFromFile.class);
    private static final int NEW_STOP_ID = 1;
    private static final int OLD_STOP_ID = 2;
    private static final int NEW_STOP_CODE = 3;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        List<String> controlLines = new InputLibrary().readList((String)context.getParameter("controlFile"));
        int matched = 0;
        int unmatched = 0;
        int duplicate = 0;
        AgencyAndId agencyAndId = ((Stop)dao.getAllStops().iterator().next()).getId();
        for (String controlLine : controlLines) {
            String[] controlArray = controlLine.split(",");
            if (controlArray == null || controlArray.length < 2) {
                this._log.info("bad control line {}", (Object)controlLine);
                continue;
            }
            String oldId = controlArray[2];
            String newId = controlArray[1];
            String newCode = controlArray[3];
            Stop stop = dao.getStopForId(new AgencyAndId(agencyAndId.getAgencyId(), newId));
            if (stop == null) {
                if (!newId.equals("0")) {
                    this._log.info("missing stop for new id {}", (Object)newId);
                } else {
                    this._log.error("No stop found for id {}", (Object)newId);
                }
                ++unmatched;
                continue;
            }
            ++matched;
            this._log.info("Setting existing new id {} to old id {}", (Object)newId, (Object)oldId);
            stop.setId(new AgencyAndId(stop.getId().getAgencyId(), oldId));
            stop.setCode(newCode);
        }
        this._log.info("Complete with {} matched and {} unmatched and {} duplicates", new Object[]{matched, unmatched, duplicate});
    }
}

