/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.List;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastStopToHeadsignStrategy
implements GtfsTransformStrategy {
    private static Logger _log = LoggerFactory.getLogger(LastStopToHeadsignStrategy.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        for (Trip trip : dao.getAllTrips()) {
            List stopTimes = dao.getStopTimesForTrip(trip);
            StopLocation lastStop = ((StopTime)stopTimes.get(stopTimes.size() - 1)).getStop();
            trip.setTripHeadsign(lastStop.getName());
        }
    }
}

