/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl.translation;

import java.util.List;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.BeanWrapperFactory;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.translation.PropertyTranslation;
import org.onebusaway.gtfs.model.translation.TranslationServiceData;
import org.onebusaway.gtfs.services.translation.TranslationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationServiceImpl
implements TranslationService {
    private static final Logger _log = LoggerFactory.getLogger(TranslationServiceImpl.class);
    private TranslationServiceData _data;

    public void setData(TranslationServiceData data) {
        this._data = data;
    }

    @Override
    public <T> T getTranslatedEntity(String language, Class<T> type, T instance) {
        T translatedInstance;
        if (this._data == null || language.equals(this._data.getFeedLanguage())) {
            return instance;
        }
        List<PropertyTranslation> translationsForClass = this._data.getTranslationsByTypeAndLanguage(type, language);
        if (translationsForClass == null || translationsForClass.isEmpty()) {
            return instance;
        }
        try {
            translatedInstance = type.getConstructor(type).newInstance(instance);
        }
        catch (Exception ex) {
            _log.error("Unable to process instance with entity type={} due to: {}", (Object)type.getName(), (Object)ex.getMessage());
            return instance;
        }
        BeanWrapper wrapper = BeanWrapperFactory.wrap(translatedInstance);
        for (PropertyTranslation translation : translationsForClass) {
            String propertyName = translation.getPropertyName();
            String translationStr = null;
            if (this.objectIdMatches(translatedInstance, translation.getEntityId(), translation.getEntitySubId())) {
                translationStr = translation.getTranslation();
            } else if (translation.getPropertyValue() != null && translation.getPropertyValue().equals(wrapper.getPropertyValue(propertyName))) {
                translationStr = translation.getTranslation();
            }
            if (translationStr == null) continue;
            wrapper.setPropertyValue(propertyName, (Object)translationStr);
        }
        return (T)wrapper.getWrappedInstance(type);
    }

    private boolean objectIdMatches(Object object, String id, String subId) {
        if (object instanceof Agency) {
            Agency agency = (Agency)object;
            return agency.getId().equals(id);
        }
        if (object instanceof Stop) {
            Stop stop = (Stop)object;
            return stop.getId().getId().equals(id);
        }
        if (object instanceof Route) {
            Route route = (Route)object;
            return route.getId().getId().equals(id);
        }
        if (object instanceof Trip) {
            Trip trip = (Trip)object;
            return trip.getId().getId().equals(id);
        }
        if (object instanceof StopTime) {
            StopTime time = (StopTime)object;
            return time.getTrip().getId().getId().equals(id) && time.getStopSequence() == Integer.parseInt(subId);
        }
        return object instanceof FeedInfo;
    }
}

