/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model.calendar;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;

public class AgencyServiceInterval
implements Serializable {
    public static final int SECONDS_IN_DAY = 86400;
    private final long _referenceTime;
    private final ServiceDate _serviceDate;
    private final Map<String, Integer> _overridesByAgencyId = new HashMap<String, Integer>();

    public AgencyServiceInterval(long referenceTime) {
        this._referenceTime = referenceTime;
        this._serviceDate = new ServiceDate(new Date(referenceTime));
    }

    public AgencyServiceInterval(ServiceDate serviceDate) {
        this._referenceTime = serviceDate.getAsDate().getTime();
        this._serviceDate = serviceDate;
    }

    public AgencyServiceInterval(long referenceTime, Map<String, Integer> agencyIdOverrides) {
        this._referenceTime = referenceTime;
        this._serviceDate = new ServiceDate(new Date(referenceTime));
        if (agencyIdOverrides != null) {
            this._overridesByAgencyId.putAll(agencyIdOverrides);
        }
    }

    public ServiceDate getServiceDate() {
        return this._serviceDate;
    }

    public ServiceInterval getServiceInterval(String agencyId) {
        if (this._overridesByAgencyId.containsKey(agencyId)) {
            ServiceDate serviceDate = new ServiceDate(new Date(this._referenceTime));
            int startSecondsIntoDay = Math.toIntExact(this._referenceTime - serviceDate.getAsDate().getTime()) / 1000;
            int endSecondsIntoDay = startSecondsIntoDay + this._overridesByAgencyId.get(agencyId) * 60;
            return new ServiceInterval(startSecondsIntoDay, endSecondsIntoDay);
        }
        return new ServiceInterval(0, 86400);
    }

    public Date getFrom(String agencyId) {
        if (this._overridesByAgencyId.containsKey(agencyId)) {
            return new Date(this._referenceTime);
        }
        return new Date(this._referenceTime);
    }

    public Date getTo(String agencyId) {
        if (this._overridesByAgencyId.containsKey(agencyId)) {
            return new Date(this._referenceTime + (long)(this._overridesByAgencyId.get(agencyId) * 60 * 1000));
        }
        return this.endOfDay(this._serviceDate);
    }

    private Date endOfDay(ServiceDate serviceDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(serviceDate.getAsDate());
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AgencyServiceInterval)) {
            return false;
        }
        AgencyServiceInterval that = (AgencyServiceInterval)other;
        return that._referenceTime == this._referenceTime;
    }

    public int hashCode() {
        return Long.valueOf(this._referenceTime).hashCode();
    }
}

