/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceDataFactoryImpl;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceImpl;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Area;
import org.onebusaway.gtfs.model.Block;
import org.onebusaway.gtfs.model.BookingRule;
import org.onebusaway.gtfs.model.DirectionEntry;
import org.onebusaway.gtfs.model.Facility;
import org.onebusaway.gtfs.model.FacilityProperty;
import org.onebusaway.gtfs.model.FacilityPropertyDefinition;
import org.onebusaway.gtfs.model.FareAttribute;
import org.onebusaway.gtfs.model.FareLegRule;
import org.onebusaway.gtfs.model.FareMedium;
import org.onebusaway.gtfs.model.FareProduct;
import org.onebusaway.gtfs.model.FareRule;
import org.onebusaway.gtfs.model.FareTransferRule;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.Level;
import org.onebusaway.gtfs.model.Location;
import org.onebusaway.gtfs.model.LocationGroup;
import org.onebusaway.gtfs.model.LocationGroupElement;
import org.onebusaway.gtfs.model.Network;
import org.onebusaway.gtfs.model.Pathway;
import org.onebusaway.gtfs.model.RiderCategory;
import org.onebusaway.gtfs.model.Ridership;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.RouteNetworkAssignment;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopAreaElement;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Timeframe;
import org.onebusaway.gtfs.model.Transfer;
import org.onebusaway.gtfs.model.Translation;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.Vehicle;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.gtfs.model.calendar.CalendarServiceData;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.model.calendar.ServiceIdIntervals;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;
import org.onebusaway.gtfs.services.GtfsDataService;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs.services.calendar.CalendarService;

public class GtfsDataServiceImpl
implements GtfsDataService {
    private GtfsRelationalDao _dao;
    private CalendarService _calendarService;

    public void setGtfsDao(GtfsRelationalDao dao) {
        CalendarServiceImpl calendarService = new CalendarServiceImpl();
        CalendarServiceDataFactoryImpl factory = new CalendarServiceDataFactoryImpl();
        factory.setGtfsDao(dao);
        calendarService.setDataFactory(factory);
        this._calendarService = calendarService;
        this._dao = dao;
    }

    @Override
    public <T> Collection<T> getAllEntitiesForType(Class<T> type) {
        return this._dao.getAllEntitiesForType(type);
    }

    @Override
    public <T> T getEntityForId(Class<T> type, Serializable id) {
        return this._dao.getEntityForId(type, id);
    }

    @Override
    public Collection<Agency> getAllAgencies() {
        return this._dao.getAllAgencies();
    }

    @Override
    public Agency getAgencyForId(String id) {
        return this._dao.getAgencyForId(id);
    }

    @Override
    public Collection<ServiceCalendar> getAllCalendars() {
        return this._dao.getAllCalendars();
    }

    @Override
    public ServiceCalendar getCalendarForId(int id) {
        return this._dao.getCalendarForId(id);
    }

    @Override
    public Collection<ServiceCalendarDate> getAllCalendarDates() {
        return this._dao.getAllCalendarDates();
    }

    @Override
    public ServiceCalendarDate getCalendarDateForId(int id) {
        return this._dao.getCalendarDateForId(id);
    }

    @Override
    public List<String> getTripAgencyIdsReferencingServiceId(AgencyAndId serviceId) {
        return this._dao.getTripAgencyIdsReferencingServiceId(serviceId);
    }

    @Override
    public Collection<FareAttribute> getAllFareAttributes() {
        return this._dao.getAllFareAttributes();
    }

    @Override
    public Collection<FareProduct> getAllFareProducts() {
        return this._dao.getAllFareProducts();
    }

    @Override
    public FareProduct getFareProductForId(AgencyAndId id) {
        return this._dao.getFareProductForId(id);
    }

    @Override
    public Collection<FareMedium> getAllFareMedia() {
        return this._dao.getAllFareMedia();
    }

    @Override
    public Collection<RiderCategory> getAllRiderCategories() {
        return this._dao.getAllRiderCategories();
    }

    @Override
    public FareAttribute getFareAttributeForId(AgencyAndId id) {
        return this._dao.getFareAttributeForId(id);
    }

    @Override
    public Collection<FareLegRule> getAllFareLegRules() {
        return this._dao.getAllFareLegRules();
    }

    @Override
    public List<Route> getRoutesForAgency(Agency agency) {
        return this._dao.getRoutesForAgency(agency);
    }

    @Override
    public Collection<FareRule> getAllFareRules() {
        return this._dao.getAllFareRules();
    }

    @Override
    public List<Stop> getStopsForStation(Stop station) {
        return this._dao.getStopsForStation(station);
    }

    @Override
    public List<Stop> getStopsForZoneId(String zoneId) {
        return this._dao.getStopsForZoneId(zoneId);
    }

    @Override
    public FareRule getFareRuleForId(int id) {
        return this._dao.getFareRuleForId(id);
    }

    @Override
    public Collection<FareTransferRule> getAllFareTransferRules() {
        return this._dao.getAllFareTransferRules();
    }

    @Override
    public List<Trip> getTripsForRoute(Route route) {
        return this._dao.getTripsForRoute(route);
    }

    @Override
    public Collection<FeedInfo> getAllFeedInfos() {
        return this._dao.getAllFeedInfos();
    }

    @Override
    public List<Trip> getTripsForShapeId(AgencyAndId shapeId) {
        return this._dao.getTripsForShapeId(shapeId);
    }

    @Override
    public FeedInfo getFeedInfoForId(String id) {
        return this._dao.getFeedInfoForId(id);
    }

    @Override
    public List<Trip> getTripsForServiceId(AgencyAndId serviceId) {
        return this._dao.getTripsForServiceId(serviceId);
    }

    @Override
    public List<Trip> getTripsForBlockId(AgencyAndId blockId) {
        return this._dao.getTripsForBlockId(blockId);
    }

    @Override
    public Collection<Frequency> getAllFrequencies() {
        return this._dao.getAllFrequencies();
    }

    @Override
    public Frequency getFrequencyForId(int id) {
        return this._dao.getFrequencyForId(id);
    }

    @Override
    public Collection<Pathway> getAllPathways() {
        return this._dao.getAllPathways();
    }

    @Override
    public Pathway getPathwayForId(AgencyAndId id) {
        return this._dao.getPathwayForId(id);
    }

    @Override
    public Collection<Level> getAllLevels() {
        return this._dao.getAllLevels();
    }

    @Override
    public Level getLevelForId(AgencyAndId id) {
        return this._dao.getLevelForId(id);
    }

    @Override
    public List<StopTime> getStopTimesForTrip(Trip trip) {
        return this._dao.getStopTimesForTrip(trip);
    }

    @Override
    public Collection<Route> getAllRoutes() {
        return this._dao.getAllRoutes();
    }

    @Override
    public Collection<RouteNetworkAssignment> getAllRouteNetworkAssignments() {
        return this._dao.getAllRouteNetworkAssignments();
    }

    @Override
    public Route getRouteForId(AgencyAndId id) {
        return this._dao.getRouteForId(id);
    }

    @Override
    public Collection<ShapePoint> getAllShapePoints() {
        return this._dao.getAllShapePoints();
    }

    @Override
    public List<StopTime> getStopTimesForStop(Stop stop) {
        return this._dao.getStopTimesForStop(stop);
    }

    @Override
    public ShapePoint getShapePointForId(int id) {
        return this._dao.getShapePointForId(id);
    }

    @Override
    public List<AgencyAndId> getAllShapeIds() {
        return this._dao.getAllShapeIds();
    }

    @Override
    public Collection<Stop> getAllStops() {
        return this._dao.getAllStops();
    }

    @Override
    public List<ShapePoint> getShapePointsForShapeId(AgencyAndId shapeId) {
        return this._dao.getShapePointsForShapeId(shapeId);
    }

    @Override
    public Stop getStopForId(AgencyAndId id) {
        return this._dao.getStopForId(id);
    }

    @Override
    public Collection<StopTime> getAllStopTimes() {
        return this._dao.getAllStopTimes();
    }

    @Override
    public List<Frequency> getFrequenciesForTrip(Trip trip) {
        return this._dao.getFrequenciesForTrip(trip);
    }

    @Override
    public StopTime getStopTimeForId(int id) {
        return this._dao.getStopTimeForId(id);
    }

    @Override
    public List<AgencyAndId> getAllServiceIds() {
        return this._dao.getAllServiceIds();
    }

    @Override
    public Collection<Transfer> getAllTransfers() {
        return this._dao.getAllTransfers();
    }

    @Override
    public ServiceCalendar getCalendarForServiceId(AgencyAndId serviceId) {
        return this._dao.getCalendarForServiceId(serviceId);
    }

    @Override
    public Transfer getTransferForId(int id) {
        return this._dao.getTransferForId(id);
    }

    @Override
    public Collection<Trip> getAllTrips() {
        return this._dao.getAllTrips();
    }

    @Override
    public Trip getTripForId(AgencyAndId id) {
        return this._dao.getTripForId(id);
    }

    @Override
    public List<ServiceCalendarDate> getCalendarDatesForServiceId(AgencyAndId serviceId) {
        return this._dao.getCalendarDatesForServiceId(serviceId);
    }

    @Override
    public Collection<Block> getAllBlocks() {
        return this._dao.getAllBlocks();
    }

    @Override
    public Block getBlockForId(int id) {
        return this._dao.getBlockForId(id);
    }

    @Override
    public List<FareRule> getFareRulesForFareAttribute(FareAttribute fareAttribute) {
        return this._dao.getFareRulesForFareAttribute(fareAttribute);
    }

    @Override
    public List<FareRule> getFareRulesForRoute(Route route) {
        return this._dao.getFareRulesForRoute(route);
    }

    @Override
    public List<FareRule> getFareRulesForZoneId(String zoneId) {
        return this._dao.getFareRulesForZoneId(zoneId);
    }

    @Override
    public Collection<Ridership> getAllRiderships() {
        return this._dao.getAllRiderships();
    }

    @Override
    public Collection<Vehicle> getAllVehicles() {
        return this._dao.getAllVehicles();
    }

    @Override
    public Vehicle getVehicleForId(AgencyAndId id) {
        return this._dao.getVehicleForId(id);
    }

    @Override
    public Collection<Area> getAllAreas() {
        return this._dao.getAllAreas();
    }

    @Override
    public Collection<LocationGroupElement> getAllLocationGroupElements() {
        return this._dao.getAllLocationGroupElements();
    }

    @Override
    public Collection<StopAreaElement> getAllStopAreaElements() {
        return this._dao.getAllStopAreaElements();
    }

    @Override
    public Collection<LocationGroup> getAllLocationGroups() {
        return this._dao.getAllLocationGroups();
    }

    @Override
    public Collection<Location> getAllLocations() {
        return this._dao.getAllLocations();
    }

    @Override
    public Collection<BookingRule> getAllBookingRules() {
        return this._dao.getAllBookingRules();
    }

    @Override
    public Collection<Timeframe> getAllTimeframes() {
        return this._dao.getAllTimeframes();
    }

    @Override
    public Collection<Translation> getAllTranslations() {
        return this._dao.getAllTranslations();
    }

    @Override
    public Collection<Network> getAllNetworks() {
        return this._dao.getAllNetworks();
    }

    @Override
    public List<Ridership> getRidershipForTrip(AgencyAndId tripId) {
        return this._dao.getRidershipForTrip(tripId);
    }

    @Override
    public Set<AgencyAndId> getServiceIds() {
        return this._calendarService.getServiceIds();
    }

    @Override
    public Set<ServiceDate> getServiceDatesForServiceId(AgencyAndId serviceId) {
        return this._calendarService.getServiceDatesForServiceId(serviceId);
    }

    @Override
    public Set<AgencyAndId> getServiceIdsOnDate(ServiceDate date) {
        return this._calendarService.getServiceIdsOnDate(date);
    }

    @Override
    public TimeZone getTimeZoneForAgencyId(String agencyId) {
        return this._calendarService.getTimeZoneForAgencyId(agencyId);
    }

    @Override
    public LocalizedServiceId getLocalizedServiceIdForAgencyAndServiceId(String agencyId, AgencyAndId serviceId) {
        return this._calendarService.getLocalizedServiceIdForAgencyAndServiceId(agencyId, serviceId);
    }

    @Override
    public List<Date> getDatesForLocalizedServiceId(LocalizedServiceId localizedServiceId) {
        return this._calendarService.getDatesForLocalizedServiceId(localizedServiceId);
    }

    @Override
    public boolean isLocalizedServiceIdActiveOnDate(LocalizedServiceId localizedServiceId, Date serviceDate) {
        return this._calendarService.isLocalizedServiceIdActiveOnDate(localizedServiceId, serviceDate);
    }

    @Override
    public List<Date> getServiceDatesWithinRange(LocalizedServiceId serviceId, ServiceInterval interval, Date from, Date to) {
        return this._calendarService.getServiceDatesWithinRange(serviceId, interval, from, to);
    }

    @Override
    public Map<LocalizedServiceId, List<Date>> getServiceDatesWithinRange(ServiceIdIntervals serviceIdIntervals, Date from, Date to) {
        return this._calendarService.getServiceDatesWithinRange(serviceIdIntervals, from, to);
    }

    @Override
    public List<Date> getServiceDateDeparturesWithinRange(LocalizedServiceId serviceId, ServiceInterval interval, Date from, Date to) {
        return this._calendarService.getServiceDateDeparturesWithinRange(serviceId, interval, from, to);
    }

    @Override
    public Map<LocalizedServiceId, List<Date>> getServiceDateDeparturesWithinRange(ServiceIdIntervals serviceIdIntervals, Date from, Date to) {
        return this._calendarService.getServiceDateDeparturesWithinRange(serviceIdIntervals, from, to);
    }

    @Override
    public List<Date> getServiceDateArrivalsWithinRange(LocalizedServiceId serviceId, ServiceInterval interval, Date from, Date to) {
        return this._calendarService.getServiceDateArrivalsWithinRange(serviceId, interval, from, to);
    }

    @Override
    public boolean isLocalizedServiceIdActiveInRange(LocalizedServiceId serviceId, ServiceInterval scheduledService, AgencyServiceInterval serviceInterval) {
        return this._calendarService.isLocalizedServiceIdActiveInRange(serviceId, scheduledService, serviceInterval);
    }

    @Override
    public Map<LocalizedServiceId, List<Date>> getServiceDateArrivalsWithinRange(ServiceIdIntervals serviceIdIntervals, Date from, Date to) {
        return this._calendarService.getServiceDateArrivalsWithinRange(serviceIdIntervals, from, to);
    }

    @Override
    public List<Date> getNextDepartureServiceDates(LocalizedServiceId serviceId, ServiceInterval interval, long targetTime) {
        return this._calendarService.getNextDepartureServiceDates(serviceId, interval, targetTime);
    }

    @Override
    public Map<LocalizedServiceId, List<Date>> getNextDepartureServiceDates(ServiceIdIntervals serviceIdIntervals, long targetTime) {
        return this._calendarService.getNextDepartureServiceDates(serviceIdIntervals, targetTime);
    }

    @Override
    public List<Date> getPreviousArrivalServiceDates(LocalizedServiceId serviceId, ServiceInterval interval, long targetTime) {
        return this._calendarService.getPreviousArrivalServiceDates(serviceId, interval, targetTime);
    }

    @Override
    public Map<LocalizedServiceId, List<Date>> getPreviousArrivalServiceDates(ServiceIdIntervals serviceIdIntervals, long targetTime) {
        return this._calendarService.getPreviousArrivalServiceDates(serviceIdIntervals, targetTime);
    }

    @Override
    public void setData(CalendarServiceData data) {
        this._calendarService.setData(data);
    }

    public Facility getFacilityForId(AgencyAndId id) {
        return this.getEntityForId(Facility.class, id);
    }

    public FacilityProperty getFacilityPropertiesForId(AgencyAndId id) {
        return this.getEntityForId(FacilityProperty.class, id);
    }

    public FacilityPropertyDefinition getFacilityPropertiesDefinitionsForId(AgencyAndId id) {
        return this.getEntityForId(FacilityPropertyDefinition.class, id);
    }

    public Collection<Facility> getAllFacilities() {
        return this.getAllEntitiesForType(Facility.class);
    }

    public Collection<FacilityProperty> getAllFacilityProperties() {
        return this.getAllEntitiesForType(FacilityProperty.class);
    }

    public Collection<FacilityPropertyDefinition> getAllFacilityPropertyDefinitions() {
        return this.getAllEntitiesForType(FacilityPropertyDefinition.class);
    }

    @Override
    public Collection<DirectionEntry> getAllDirectionEntries() {
        return this._dao.getAllDirectionEntries();
    }
}

