/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model;

import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Level;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.serialization.mappings.DefaultAgencyIdFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.EntityFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.LatLonFieldMappingFactory;

@CsvFields(filename="stops.txt", prefix="stop_", required=false)
public final class Stop
extends IdentityBean<AgencyAndId>
implements StopLocation {
    private static final long serialVersionUID = 1L;
    private static final int MISSING_VALUE = -999;
    public static final int LOCATION_TYPE_STOP = 0;
    public static final int LOCATION_TYPE_STATION = 1;
    public static final int LOCATION_TYPE_ENTRANCE_EXIT = 2;
    public static final int LOCATION_TYPE_NODE = 3;
    public static final int LOCATION_TYPE_BOARDING_AREA = 4;
    @CsvField(mapping=DefaultAgencyIdFieldMappingFactory.class)
    private AgencyAndId id;
    @CsvField(optional=true)
    private String name;
    @CsvField(mapping=LatLonFieldMappingFactory.class, optional=true)
    private double lat = -999.0;
    @CsvField(mapping=LatLonFieldMappingFactory.class, optional=true)
    private double lon = -999.0;
    @CsvField(optional=true)
    private String code;
    @CsvField(optional=true)
    private String desc;
    @CsvField(name="zone_id", optional=true)
    private String zoneId;
    @CsvField(optional=true)
    private String url;
    @CsvField(name="location_type", optional=true, defaultValue="0")
    private int locationType = 0;
    @CsvField(name="parent_station", optional=true)
    private String parentStation;
    @CsvField(name="wheelchair_boarding", optional=true, defaultValue="0")
    private int wheelchairBoarding = 0;
    @CsvField(optional=true)
    private String direction;
    @CsvField(optional=true)
    private String timezone;
    @CsvField(name="vehicle_type", optional=true)
    private int vehicleType = -999;
    @CsvField(name="platform_code", optional=true)
    private String platformCode;
    @CsvField(name="level_id", optional=true, mapping=EntityFieldMappingFactory.class)
    private Level level;
    @CsvField(optional=true, name="tts_stop_name")
    private String ttsStopName;

    public Stop() {
    }

    public Stop(Stop obj) {
        this.id = obj.id;
        this.code = obj.code;
        this.name = obj.name;
        this.desc = obj.desc;
        this.lat = obj.lat;
        this.lon = obj.lon;
        this.zoneId = obj.zoneId;
        this.url = obj.url;
        this.locationType = obj.locationType;
        this.parentStation = obj.parentStation;
        this.wheelchairBoarding = obj.wheelchairBoarding;
        this.direction = obj.direction;
        this.timezone = obj.timezone;
        this.vehicleType = obj.vehicleType;
        this.platformCode = obj.platformCode;
        this.level = obj.level;
        this.ttsStopName = obj.ttsStopName;
    }

    @Override
    public AgencyAndId getId() {
        return this.id;
    }

    @Override
    public void setId(AgencyAndId id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public boolean isLatSet() {
        return this.lat != -999.0;
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public void clearLat() {
        this.lat = -999.0;
    }

    public boolean isLonSet() {
        return this.lon != -999.0;
    }

    public double getLon() {
        return this.lon;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public void clearLon() {
        this.lon = -999.0;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getLocationType() {
        return this.locationType;
    }

    public void setLocationType(int locationType) {
        this.locationType = locationType;
    }

    public String getParentStation() {
        return this.parentStation;
    }

    public void setParentStation(String parentStation) {
        this.parentStation = parentStation;
    }

    public String toString() {
        return "<Stop " + String.valueOf(this.id) + ">";
    }

    public void setWheelchairBoarding(int wheelchairBoarding) {
        this.wheelchairBoarding = wheelchairBoarding;
    }

    public int getWheelchairBoarding() {
        return this.wheelchairBoarding;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public boolean isVehicleTypeSet() {
        return this.vehicleType != -999;
    }

    public int getVehicleType() {
        return this.vehicleType;
    }

    public void setVehicleType(int vehicleType) {
        this.vehicleType = vehicleType;
    }

    public void clearVehicleType() {
        this.vehicleType = -999;
    }

    public String getPlatformCode() {
        return this.platformCode;
    }

    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public String getTtsStopName() {
        return this.ttsStopName;
    }

    public void setTtsStopName(String ttsStopName) {
        this.ttsStopName = ttsStopName;
    }
}

