/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model;

import java.time.LocalTime;
import java.util.Objects;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.serialization.mappings.DefaultAgencyIdFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.LocalTimeFieldMappingFactory;

@CsvFields(filename="timeframes.txt", required=false)
public final class Timeframe
extends IdentityBean<AgencyAndId> {
    public static final int MISSING_VALUE = -999;
    @CsvField(name="timeframe_group_id", mapping=DefaultAgencyIdFieldMappingFactory.class)
    private AgencyAndId id;
    @CsvField(name="service_id")
    private String serviceId;
    @CsvField(optional=true, mapping=LocalTimeFieldMappingFactory.class)
    private LocalTime startTime = LocalTime.MIN;
    @CsvField(optional=true, mapping=LocalTimeFieldMappingFactory.class)
    private LocalTime endTime = LocalTime.MIDNIGHT;

    @Override
    public AgencyAndId getId() {
        String agencyID = this.id.getAgencyId();
        String id = "%s|%s|%s|%s".formatted(this.id, this.serviceId, this.startTime, this.endTime);
        return new AgencyAndId(agencyID, id);
    }

    @Override
    public void setId(AgencyAndId id) {
        this.id = id;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = Objects.requireNonNull(startTime);
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = Objects.requireNonNull(endTime);
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }
}

