/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.schema.AbstractFieldMapping;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.InvalidStopTimeException;

public class StopTimeFieldMappingFactory
implements FieldMappingFactory {
    private static final DecimalFormat _format = new DecimalFormat("00", new DecimalFormatSymbols(Locale.ENGLISH));
    private static int[][] DIGITS = new int[58][];

    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        return new StopTimeFieldMapping(entityType, csvFieldName, objFieldName, required);
    }

    public static String getSecondsAsString(int t) {
        int seconds = StopTimeFieldMappingFactory.positiveMod(t, 60);
        int hourAndMinutes = (t - seconds) / 60;
        int minutes = StopTimeFieldMappingFactory.positiveMod(hourAndMinutes, 60);
        int hours = (hourAndMinutes - minutes) / 60;
        StringBuilder b = new StringBuilder();
        b.append(_format.format(hours));
        b.append(":");
        b.append(_format.format(minutes));
        b.append(":");
        b.append(_format.format(seconds));
        return b.toString();
    }

    private static final int positiveMod(int value, int modulo) {
        int m = value % modulo;
        if (m < 0) {
            m += modulo;
        }
        return m;
    }

    public static int getStringAsSeconds(String value) {
        block6: {
            try {
                int hours;
                int length = value.length();
                int colon1Index = length - 6;
                int colon2Index = length - 3;
                if (value.charAt(colon2Index) != ':' || value.charAt(colon1Index) != ':') break block6;
                if (length == 8) {
                    char hoursDigit2 = value.charAt(1);
                    if (hoursDigit2 < '0') break block6;
                    hours = DIGITS[value.charAt(0)][hoursDigit2];
                } else {
                    hours = Integer.parseInt(value, 0, colon1Index, 10);
                }
                char secondsDigit2 = value.charAt(length - 1);
                if (secondsDigit2 >= '0') {
                    int seconds = DIGITS[value.charAt(length - 2)][secondsDigit2];
                    char minutesDigit2 = value.charAt(length - 4);
                    if (minutesDigit2 >= '0') {
                        int minutes = DIGITS[value.charAt(length - 5)][minutesDigit2];
                        return seconds + 60 * (minutes + 60 * hours);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new InvalidStopTimeException(value);
    }

    static {
        for (int i = 0; i < 10; ++i) {
            StopTimeFieldMappingFactory.DIGITS[48 + i] = new int[58];
            int base = i * 10;
            for (int k = 0; k < 10; ++k) {
                StopTimeFieldMappingFactory.DIGITS[48 + i][48 + k] = base + k;
            }
        }
    }

    private static class StopTimeFieldMapping
    extends AbstractFieldMapping
    implements Converter {
        public StopTimeFieldMapping(Class<?> entityType, String csvFieldName, String objFieldName, boolean required) {
            super(entityType, csvFieldName, objFieldName, required);
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            if (this.isMissingAndOptional(csvValues)) {
                return;
            }
            Object value = csvValues.get(this._csvFieldName);
            object.setPropertyValue(this._objFieldName, this.convert(Integer.TYPE, value));
        }

        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
            int t = (Integer)object.getPropertyValue(this._objFieldName);
            if (t < 0) {
                csvValues.put(this._csvFieldName, "");
                return;
            }
            String value = StopTimeFieldMappingFactory.getSecondsAsString(t);
            csvValues.put(this._csvFieldName, value);
        }

        public Object convert(Class type, Object value) {
            if (type == Integer.class || type == Integer.TYPE) {
                String stringValue = value.toString();
                return StopTimeFieldMappingFactory.getStringAsSeconds(stringValue);
            }
            if (type == String.class) {
                return StopTimeFieldMappingFactory.getSecondsAsString((Integer)value);
            }
            throw new ConversionException("Could not convert " + String.valueOf(value) + " of type " + String.valueOf(value.getClass()) + " to " + String.valueOf(type));
        }
    }
}

