/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.onebusaway.gtfs.model.Area;
import org.onebusaway.gtfs.model.BookingRule;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.StopTimeProxy;
import org.onebusaway.gtfs.model.Trip;

public class StopTimeArray
extends AbstractList<StopTime> {
    private int size = 0;
    private Trip[] trips = new Trip[0];
    private StopLocation[] stops = new StopLocation[0];
    private StopLocation[] locations = new StopLocation[0];
    private StopLocation[] locationGroups = new StopLocation[0];
    private Area[] startServiceAreas = new Area[0];
    private Area[] endServiceAreas = new Area[0];
    private int[] arrivalTimes = new int[0];
    private int[] departureTimes = new int[0];
    private int[] timepoints = new int[0];
    private int[] stopSequences = new int[0];
    private String[] stopHeadsigns = new String[0];
    private String[] routeShortNames = new String[0];
    private int[] pickupTypes = new int[0];
    private int[] dropOffTypes = new int[0];
    private double[] shapeDistTraveled = new double[0];
    private BookingRule[] pickupBookingRules = new BookingRule[0];
    private BookingRule[] dropOffBookingRules = new BookingRule[0];
    private double[] meanOffsets = new double[0];
    private double[] safeOffsets = new double[0];
    private double[] meanFactors = new double[0];
    private double[] safeFactors = new double[0];
    private String[] freeRunningFlags = new String[0];

    public void trimToSize() {
        this.setLength(this.size);
    }

    @Override
    public boolean add(StopTime stopTime) {
        int index = this.size++;
        this.ensureCapacity(this.size);
        this.trips[index] = stopTime.getTrip();
        this.startServiceAreas[index] = stopTime.getStartServiceArea();
        this.endServiceAreas[index] = stopTime.getEndServiceArea();
        this.stops[index] = stopTime.getStop();
        this.locations[index] = stopTime.getLocation();
        this.locationGroups[index] = stopTime.getLocationGroup();
        this.arrivalTimes[index] = stopTime.getArrivalTime();
        this.departureTimes[index] = stopTime.getDepartureTime();
        this.timepoints[index] = stopTime.getTimepoint();
        this.stopSequences[index] = stopTime.getStopSequence();
        this.stopHeadsigns[index] = stopTime.getStopHeadsign();
        this.routeShortNames[index] = stopTime.getRouteShortName();
        this.pickupTypes[index] = stopTime.getPickupType();
        this.dropOffTypes[index] = stopTime.getDropOffType();
        this.shapeDistTraveled[index] = stopTime.getShapeDistTraveled();
        this.pickupBookingRules[index] = stopTime.getPickupBookingRule();
        this.dropOffBookingRules[index] = stopTime.getDropOffBookingRule();
        this.safeOffsets[index] = stopTime.getSafeDurationOffset();
        this.safeFactors[index] = stopTime.getSafeDurationFactor();
        this.meanOffsets[index] = stopTime.getMeanDurationOffset();
        this.meanFactors[index] = stopTime.getMeanDurationFactor();
        this.freeRunningFlags[index] = stopTime.getFreeRunningFlag();
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.setLength(0);
    }

    @Override
    public Iterator<StopTime> iterator() {
        return new StopTimeIterator();
    }

    @Override
    public StopTime get(int index) {
        if (index < 0 || index >= this.size) {
            throw new NoSuchElementException();
        }
        StopTime stopTime = new StopTime();
        stopTime.setProxy(new StopTimeProxyImpl(index));
        return stopTime;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void ensureCapacity(int capacity) {
        if (this.trips.length < capacity) {
            int newLength = Math.max(8, this.trips.length << 2);
            this.setLength(newLength);
        }
    }

    private void setLength(int newLength) {
        this.trips = Arrays.copyOf(this.trips, newLength);
        this.startServiceAreas = Arrays.copyOf(this.startServiceAreas, newLength);
        this.endServiceAreas = Arrays.copyOf(this.endServiceAreas, newLength);
        this.stops = Arrays.copyOf(this.stops, newLength);
        this.locationGroups = Arrays.copyOf(this.locationGroups, newLength);
        this.locations = Arrays.copyOf(this.locations, newLength);
        this.arrivalTimes = Arrays.copyOf(this.arrivalTimes, newLength);
        this.departureTimes = Arrays.copyOf(this.departureTimes, newLength);
        this.timepoints = Arrays.copyOf(this.timepoints, newLength);
        this.stopSequences = Arrays.copyOf(this.stopSequences, newLength);
        this.stopHeadsigns = Arrays.copyOf(this.stopHeadsigns, newLength);
        this.routeShortNames = Arrays.copyOf(this.routeShortNames, newLength);
        this.pickupTypes = Arrays.copyOf(this.pickupTypes, newLength);
        this.dropOffTypes = Arrays.copyOf(this.dropOffTypes, newLength);
        this.shapeDistTraveled = Arrays.copyOf(this.shapeDistTraveled, newLength);
        this.pickupBookingRules = Arrays.copyOf(this.pickupBookingRules, newLength);
        this.dropOffBookingRules = Arrays.copyOf(this.dropOffBookingRules, newLength);
        this.safeOffsets = Arrays.copyOf(this.safeOffsets, newLength);
        this.safeFactors = Arrays.copyOf(this.safeFactors, newLength);
        this.meanOffsets = Arrays.copyOf(this.meanOffsets, newLength);
        this.meanFactors = Arrays.copyOf(this.meanFactors, newLength);
        this.freeRunningFlags = Arrays.copyOf(this.freeRunningFlags, newLength);
    }

    private class StopTimeIterator
    implements Iterator<StopTime> {
        private int index = 0;

        private StopTimeIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < StopTimeArray.this.size;
        }

        @Override
        public StopTime next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StopTime stopTime = new StopTime();
            stopTime.setProxy(new StopTimeProxyImpl(this.index));
            ++this.index;
            return stopTime;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class StopTimeProxyImpl
    implements StopTimeProxy {
        private final int index;

        public StopTimeProxyImpl(int index) {
            this.index = index;
        }

        @Override
        public Integer getId() {
            return this.index;
        }

        @Override
        public void setId(Integer id) {
        }

        @Override
        public Trip getTrip() {
            return StopTimeArray.this.trips[this.index];
        }

        @Override
        public void setTrip(Trip trip) {
            StopTimeArray.this.trips[this.index] = trip;
        }

        @Override
        public Area getStartServiceArea() {
            return StopTimeArray.this.startServiceAreas[this.index];
        }

        @Override
        public void setStartServiceArea(Area area) {
            StopTimeArray.this.startServiceAreas[this.index] = area;
        }

        @Override
        public Area getEndServiceArea() {
            return StopTimeArray.this.endServiceAreas[this.index];
        }

        @Override
        public void setEndServiceArea(Area area) {
            StopTimeArray.this.endServiceAreas[this.index] = area;
        }

        @Override
        public int getStopSequence() {
            return StopTimeArray.this.stopSequences[this.index];
        }

        @Override
        public void setStopSequence(int stopSequence) {
            StopTimeArray.this.stopSequences[this.index] = stopSequence;
        }

        @Override
        public StopLocation getStop() {
            return StopTimeArray.this.stops[this.index];
        }

        @Override
        public StopLocation getLocation() {
            return StopTimeArray.this.locations[this.index];
        }

        @Override
        public StopLocation getLocationGroup() {
            return StopTimeArray.this.locationGroups[this.index];
        }

        @Override
        public void setStop(StopLocation stop) {
            StopTimeArray.this.stops[this.index] = stop;
        }

        @Override
        public void setLocation(StopLocation location) {
            StopTimeArray.this.locations[this.index] = location;
        }

        @Override
        public void setLocationGroup(StopLocation group) {
            StopTimeArray.this.locationGroups[this.index] = group;
        }

        @Override
        public boolean isArrivalTimeSet() {
            return StopTimeArray.this.arrivalTimes[this.index] != -999;
        }

        @Override
        public int getArrivalTime() {
            return StopTimeArray.this.arrivalTimes[this.index];
        }

        @Override
        public void setArrivalTime(int arrivalTime) {
            StopTimeArray.this.arrivalTimes[this.index] = arrivalTime;
        }

        @Override
        public void clearArrivalTime() {
            StopTimeArray.this.arrivalTimes[this.index] = -999;
        }

        @Override
        public boolean isDepartureTimeSet() {
            return StopTimeArray.this.departureTimes[this.index] != -999;
        }

        @Override
        public int getDepartureTime() {
            return StopTimeArray.this.departureTimes[this.index];
        }

        @Override
        public void setDepartureTime(int departureTime) {
            StopTimeArray.this.departureTimes[this.index] = departureTime;
        }

        @Override
        public void clearDepartureTime() {
            StopTimeArray.this.departureTimes[this.index] = -999;
        }

        @Override
        public boolean isTimepointSet() {
            return StopTimeArray.this.timepoints[this.index] != -999;
        }

        @Override
        public int getTimepoint() {
            return StopTimeArray.this.timepoints[this.index];
        }

        @Override
        public void setTimepoint(int timepoint) {
            StopTimeArray.this.timepoints[this.index] = timepoint;
        }

        @Override
        public void clearTimepoint() {
            StopTimeArray.this.timepoints[this.index] = -999;
        }

        @Override
        public String getStopHeadsign() {
            return StopTimeArray.this.stopHeadsigns[this.index];
        }

        @Override
        public void setStopHeadsign(String headSign) {
            StopTimeArray.this.stopHeadsigns[this.index] = headSign;
        }

        @Override
        public String getRouteShortName() {
            return StopTimeArray.this.routeShortNames[this.index];
        }

        @Override
        public void setRouteShortName(String routeShortName) {
            StopTimeArray.this.routeShortNames[this.index] = routeShortName;
        }

        @Override
        public int getPickupType() {
            return StopTimeArray.this.pickupTypes[this.index];
        }

        @Override
        public void setPickupType(int pickupType) {
            StopTimeArray.this.pickupTypes[this.index] = pickupType;
        }

        @Override
        public int getDropOffType() {
            return StopTimeArray.this.dropOffTypes[this.index];
        }

        @Override
        public void setDropOffType(int dropOffType) {
            StopTimeArray.this.dropOffTypes[this.index] = dropOffType;
        }

        @Override
        public boolean isShapeDistTraveledSet() {
            return StopTimeArray.this.shapeDistTraveled[this.index] != -999.0;
        }

        @Override
        public double getShapeDistTraveled() {
            return StopTimeArray.this.shapeDistTraveled[this.index];
        }

        @Override
        public void setShapeDistTraveled(double shapeDistTraveled) {
            StopTimeArray.this.shapeDistTraveled[this.index] = shapeDistTraveled;
        }

        @Override
        public void clearShapeDistTraveled() {
            StopTimeArray.this.shapeDistTraveled[this.index] = -999.0;
        }

        @Override
        public BookingRule getPickupBookingRule() {
            return StopTimeArray.this.pickupBookingRules[this.index];
        }

        @Override
        public void setPickupBookingRule(BookingRule pickupBookingRule) {
            StopTimeArray.this.pickupBookingRules[this.index] = pickupBookingRule;
        }

        @Override
        public BookingRule getDropOffBookingRule() {
            return StopTimeArray.this.dropOffBookingRules[this.index];
        }

        @Override
        public void setDropOffBookingRule(BookingRule dropOffBookingRule) {
            StopTimeArray.this.dropOffBookingRules[this.index] = dropOffBookingRule;
        }

        @Override
        public double getMeanDurationFactor() {
            return StopTimeArray.this.meanOffsets[this.index];
        }

        @Override
        public void setMeanDurationFactor(double meanDurationFactor) {
            StopTimeArray.this.meanFactors[this.index] = meanDurationFactor;
        }

        @Override
        public double getMeanDurationOffset() {
            return StopTimeArray.this.meanOffsets[this.index];
        }

        @Override
        public void setMeanDurationOffset(double meanDurationOffset) {
            StopTimeArray.this.meanOffsets[this.index] = meanDurationOffset;
        }

        @Override
        public double getSafeDurationFactor() {
            return StopTimeArray.this.safeFactors[this.index];
        }

        @Override
        public void setSafeDurationFactor(double safeDurationFactor) {
            StopTimeArray.this.safeFactors[this.index] = safeDurationFactor;
        }

        @Override
        public double getSafeDurationOffset() {
            return StopTimeArray.this.safeOffsets[this.index];
        }

        @Override
        public void setSafeDurationOffset(double safeDurationOffset) {
            StopTimeArray.this.safeOffsets[this.index] = safeDurationOffset;
        }

        @Override
        public String getFreeRunningFlag() {
            return StopTimeArray.this.freeRunningFlags[this.index];
        }

        @Override
        public void setFreeRunningFlag(String freeRunningFlag) {
            StopTimeArray.this.freeRunningFlags[this.index] = freeRunningFlag;
        }
    }
}

