/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model;

import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.serialization.mappings.EntityFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.StopTimeFieldMappingFactory;

@CsvFields(filename="frequencies.txt", required=false)
public final class Frequency
extends IdentityBean<Integer> {
    private static final long serialVersionUID = 1L;
    @CsvField(ignore=true)
    private int id;
    @CsvField(name="trip_id", mapping=EntityFieldMappingFactory.class)
    private Trip trip;
    @CsvField(mapping=StopTimeFieldMappingFactory.class)
    private int startTime;
    @CsvField(mapping=StopTimeFieldMappingFactory.class)
    private int endTime;
    private int headwaySecs;
    @CsvField(optional=true, defaultValue="0")
    private int exactTimes = 0;
    @CsvField(optional=true, defaultValue="0")
    private int labelOnly = 0;

    public Frequency() {
    }

    public Frequency(Frequency f) {
        this.id = f.id;
        this.trip = f.trip;
        this.startTime = f.startTime;
        this.endTime = f.endTime;
        this.headwaySecs = f.headwaySecs;
        this.exactTimes = f.exactTimes;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public Trip getTrip() {
        return this.trip;
    }

    public void setTrip(Trip trip) {
        this.trip = trip;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public void setStartTime(int startTime) {
        this.startTime = startTime;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int endTime) {
        this.endTime = endTime;
    }

    public int getHeadwaySecs() {
        return this.headwaySecs;
    }

    public void setHeadwaySecs(int headwaySecs) {
        this.headwaySecs = headwaySecs;
    }

    public int getExactTimes() {
        return this.exactTimes;
    }

    public void setExactTimes(int exactTimes) {
        this.exactTimes = exactTimes;
    }

    public int getLabelOnly() {
        return this.labelOnly;
    }

    public void setLabelOnly(int labelOnly) {
        this.labelOnly = labelOnly;
    }

    public String toString() {
        return "<Frequency " + this.getId() + " start=" + StopTimeFieldMappingFactory.getSecondsAsString(this.startTime) + " end=" + StopTimeFieldMappingFactory.getSecondsAsString(this.endTime) + ">";
    }
}

