/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.serialization.mappings.DefaultAgencyIdFieldMappingFactory;

@CsvFields(filename="areas.txt", required=false)
public final class Area
extends IdentityBean<AgencyAndId> {
    @CsvField(name="area_id", mapping=DefaultAgencyIdFieldMappingFactory.class)
    private AgencyAndId id;
    @CsvField(name="area_name", optional=true)
    private String name;
    @CsvField(ignore=true)
    private List<Stop> stops = new ArrayList<Stop>();

    public Area() {
    }

    public Area(Area a) {
        this.id = a.id;
        this.name = a.name;
    }

    public String getAreaId() {
        return this.id.getId();
    }

    @Override
    public AgencyAndId getId() {
        return this.id;
    }

    private void setStops(Collection<Stop> stops) {
        this.stops = List.copyOf(stops);
    }

    public void addStop(Stop stop) {
        this.stops.add(stop);
    }

    @Override
    public void setId(AgencyAndId areaId) {
        this.id = areaId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<Stop> getStops() {
        return List.copyOf(this.stops);
    }
}

