/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model;

import java.util.Optional;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.FareMedium;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.RiderCategory;
import org.onebusaway.gtfs.serialization.mappings.DefaultAgencyIdFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.EntityFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.FareAmountFieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.FareProductFieldMappingFactory;

@CsvFields(filename="fare_products.txt", required=false)
public final class FareProduct
extends IdentityBean<AgencyAndId> {
    private static final long serialVersionUID = 2L;
    private static final int MISSING_VALUE = -999;
    @CsvField(name="fare_product_id", mapping=DefaultAgencyIdFieldMappingFactory.class)
    private AgencyAndId fareProductId;
    @CsvField(optional=true, name="fare_product_name")
    private String name;
    @CsvField(name="amount", optional=false, mapping=FareAmountFieldMappingFactory.class)
    private float amount = -999.0f;
    @CsvField
    private String currency;
    @CsvField(optional=true)
    private int durationAmount = -999;
    @CsvField(optional=true)
    private int durationUnit = -999;
    @CsvField(optional=true)
    private int durationType = -999;
    @CsvField(name="rider_category_id", optional=true, mapping=EntityFieldMappingFactory.class)
    private RiderCategory riderCategory;
    @CsvField(name="fare_media_id", optional=true, mapping=EntityFieldMappingFactory.class)
    private FareMedium fareMedium;

    public AgencyAndId getFareProductId() {
        return this.fareProductId;
    }

    public void setFareProductId(AgencyAndId fareProductId) {
        this.fareProductId = fareProductId;
    }

    public FareMedium getFareMedium() {
        return this.fareMedium;
    }

    public void setFareMedium(FareMedium fareMedium) {
        this.fareMedium = fareMedium;
    }

    public int getDurationAmount() {
        return this.durationAmount;
    }

    public void setDurationAmount(int durationAmount) {
        this.durationAmount = durationAmount;
    }

    public int getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(int durationUnit) {
        this.durationUnit = durationUnit;
    }

    public int getDurationType() {
        return this.durationType;
    }

    public void setDurationType(int durationType) {
        this.durationType = durationType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Override
    public AgencyAndId getId() {
        String riderCategoryId = Optional.ofNullable(this.riderCategory).map(c -> c.getId().getId()).orElse(null);
        String fareMediumId = Optional.ofNullable(this.fareMedium).map(c -> c.getId().getId()).orElse(null);
        return FareProductFieldMappingFactory.fareProductId(this.fareProductId.getAgencyId(), this.fareProductId.getId(), riderCategoryId, fareMediumId);
    }

    @Override
    public void setId(AgencyAndId id) {
    }

    public RiderCategory getRiderCategory() {
        return this.riderCategory;
    }

    public void setRiderCategory(RiderCategory riderCategory) {
        this.riderCategory = riderCategory;
    }

    public boolean isDurationUnitSet() {
        return this.durationUnit != -999;
    }

    public boolean isDurationTypeSet() {
        return this.durationType != -999;
    }

    public boolean isDurationAmountSet() {
        return this.durationAmount != -999;
    }
}

