/**
 * Copyright (C) 2011 Brian Ferris <bdferris@onebusaway.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.onebusaway.transit_data_federation.services;

import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;

import java.util.HashSet;

public class ArrivalAndDepartureQuery {

  private StopEntry stop;

  private int stopSequence;

  private TripEntry trip;

  private long serviceDate;

  private AgencyAndId vehicleId;

  private long time;

  private HashSet<String> agenciesExcludingScheduled;

  public StopEntry getStop() {
    return stop;
  }

  public void setStop(StopEntry stop) {
    this.stop = stop;
  }

  public int getStopSequence() {
    return stopSequence;
  }

  public void setStopSequence(int stopSequence) {
    this.stopSequence = stopSequence;
  }

  public TripEntry getTrip() {
    return trip;
  }

  public void setTrip(TripEntry trip) {
    this.trip = trip;
  }

  public long getServiceDate() {
    return serviceDate;
  }

  public void setServiceDate(long serviceDate) {
    this.serviceDate = serviceDate;
  }

  public AgencyAndId getVehicleId() {
    return vehicleId;
  }

  public void setVehicleId(AgencyAndId vehicleId) {
    this.vehicleId = vehicleId;
  }

  public long getTime() {
    return time;
  }

  public void setTime(long time) {
    this.time = time;
  }

  public HashSet<String> getAgenciesExcludingScheduled() {
    return this.agenciesExcludingScheduled;
  }

  public void setAgenciesExcludingScheduled(HashSet<String> agenciesExcludingScheduled) {
    this.agenciesExcludingScheduled = agenciesExcludingScheduled;
  }
}
