/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.onflow.flow.sdk.AddressRegistry;
import org.onflow.flow.sdk.AsyncFlowAccessApi;
import org.onflow.flow.sdk.FlowAccessApi;
import org.onflow.flow.sdk.FlowAddress;
import org.onflow.flow.sdk.FlowChainId;
import org.onflow.flow.sdk.cadence.CadenceNamespace;
import org.onflow.flow.sdk.cadence.Field;
import org.onflow.flow.sdk.cadence.JsonCadenceMarshalling;
import org.onflow.flow.sdk.impl.AsyncFlowAccessApiImpl;
import org.onflow.flow.sdk.impl.FlowAccessApiImpl;
import org.onflow.protobuf.access.AccessAPIGrpc;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\b2\b\b\u0002\u0010\u0015\u001a\u00020\u0004H\u0007J#\u0010\u0016\u001a\u0002H\u0017\"\f\b\u0000\u0010\u0017*\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ#\u0010\u0016\u001a\u0002H\u0017\"\f\b\u0000\u0010\u0017*\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u001c\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010\u001dJ$\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001f\"\f\b\u0000\u0010\u0017*\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001f\"\f\b\u0000\u0010\u0017*\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u001c\u001a\u00020\u000fH\u0007J#\u0010 \u001a\u00020\u001a\"\f\b\u0000\u0010\u0017*\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010!\u001a\u0002H\u0017H\u0007\u00a2\u0006\u0002\u0010\"J$\u0010#\u001a\u00020\u001a\"\f\b\u0000\u0010\u0017*\u0006\u0012\u0002\b\u00030\u00182\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u00170%H\u0007J;\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0018\"\b\b\u0000\u0010\u0017*\u00020\u00012\u0006\u0010'\u001a\u0002H\u00172\u000e\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00170)2\u0006\u0010*\u001a\u00020+H\u0007\u00a2\u0006\u0002\u0010,J=\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0018\"\b\b\u0000\u0010\u0017*\u00020\u00012\u0006\u0010'\u001a\u0002H\u00172\u000e\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00170)2\b\b\u0002\u0010*\u001a\u00020-H\u0007\u00a2\u0006\u0002\u0010.J+\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0018\"\b\b\u0000\u0010\u0017*\u00020\u00012\u0006\u0010'\u001a\u0002H\u00172\u0006\u0010*\u001a\u00020+H\u0007\u00a2\u0006\u0002\u0010/J-\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0018\"\b\b\u0000\u0010\u0017*\u00020\u00012\u0006\u0010'\u001a\u0002H\u00172\b\b\u0002\u0010*\u001a\u00020-H\u0007\u00a2\u0006\u0002\u00100J8\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000f2\b\b\u0002\u00104\u001a\u00020\r2\b\b\u0002\u00105\u001a\u0002062\b\b\u0002\u00107\u001a\u00020\u000f2\b\b\u0002\u00108\u001a\u00020\rH\u0007J8\u00109\u001a\u00020:2\u0006\u00103\u001a\u00020\u000f2\b\b\u0002\u00104\u001a\u00020\r2\b\b\u0002\u00105\u001a\u0002062\b\b\u0002\u00107\u001a\u00020\u000f2\b\b\u0002\u00108\u001a\u00020\rH\u0007J0\u0010;\u001a\u00020<2\u0006\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\r2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\rH\u0003J9\u0010=\u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00012\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H\u00170)2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010*\u001a\u00020+H\u0007\u00a2\u0006\u0002\u0010?J;\u0010=\u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00012\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H\u00170)2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u00182\b\b\u0002\u0010*\u001a\u00020-H\u0007\u00a2\u0006\u0002\u0010@R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/onflow/flow/sdk/Flow;", "", "()V", "<set-?>", "Lorg/onflow/flow/sdk/AddressRegistry;", "DEFAULT_ADDRESS_REGISTRY", "getDEFAULT_ADDRESS_REGISTRY", "()Lorg/onflow/flow/sdk/AddressRegistry;", "Lorg/onflow/flow/sdk/FlowChainId;", "DEFAULT_CHAIN_ID", "getDEFAULT_CHAIN_ID", "()Lorg/onflow/flow/sdk/FlowChainId;", "DEFAULT_MAX_MESSAGE_SIZE", "", "DEFAULT_USER_AGENT", "", "OBJECT_MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "configureDefaults", "", "chainId", "addressRegistry", "decodeJsonCadence", "T", "Lorg/onflow/flow/sdk/cadence/Field;", "bytes", "", "([B)Lorg/onflow/flow/sdk/cadence/Field;", "string", "(Ljava/lang/String;)Lorg/onflow/flow/sdk/cadence/Field;", "decodeJsonCadenceList", "", "encodeJsonCadence", "jsonCadence", "(Lorg/onflow/flow/sdk/cadence/Field;)[B", "encodeJsonCadenceList", "jsonCadences", "", "marshall", "value", "clazz", "Lkotlin/reflect/KClass;", "namespace", "Lorg/onflow/flow/sdk/FlowAddress;", "(Ljava/lang/Object;Lkotlin/reflect/KClass;Lorg/onflow/flow/sdk/FlowAddress;)Lorg/onflow/flow/sdk/cadence/Field;", "Lorg/onflow/flow/sdk/cadence/CadenceNamespace;", "(Ljava/lang/Object;Lkotlin/reflect/KClass;Lorg/onflow/flow/sdk/cadence/CadenceNamespace;)Lorg/onflow/flow/sdk/cadence/Field;", "(Ljava/lang/Object;Lorg/onflow/flow/sdk/FlowAddress;)Lorg/onflow/flow/sdk/cadence/Field;", "(Ljava/lang/Object;Lorg/onflow/flow/sdk/cadence/CadenceNamespace;)Lorg/onflow/flow/sdk/cadence/Field;", "newAccessApi", "Lorg/onflow/flow/sdk/FlowAccessApi;", "host", "port", "secure", "", "userAgent", "maxMessageSize", "newAsyncAccessApi", "Lorg/onflow/flow/sdk/AsyncFlowAccessApi;", "openChannel", "Lio/grpc/ManagedChannel;", "unmarshall", "type", "(Lkotlin/reflect/KClass;Lorg/onflow/flow/sdk/cadence/Field;Lorg/onflow/flow/sdk/FlowAddress;)Ljava/lang/Object;", "(Lkotlin/reflect/KClass;Lorg/onflow/flow/sdk/cadence/Field;Lorg/onflow/flow/sdk/cadence/CadenceNamespace;)Ljava/lang/Object;", "flow-jvm-sdk"})
public final class Flow {
    @NotNull
    public static final Flow INSTANCE = new Flow();
    @NotNull
    private static final String DEFAULT_USER_AGENT = "Flow JVM SDK";
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 0x1000000;
    @NotNull
    private static ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @NotNull
    private static FlowChainId DEFAULT_CHAIN_ID = FlowChainId.MAINNET;
    @NotNull
    private static AddressRegistry DEFAULT_ADDRESS_REGISTRY = new AddressRegistry();

    private Flow() {
    }

    @NotNull
    public final FlowChainId getDEFAULT_CHAIN_ID() {
        return DEFAULT_CHAIN_ID;
    }

    @NotNull
    public final AddressRegistry getDEFAULT_ADDRESS_REGISTRY() {
        return DEFAULT_ADDRESS_REGISTRY;
    }

    @JvmStatic
    @JvmOverloads
    public static final void configureDefaults(@NotNull FlowChainId chainId, @NotNull AddressRegistry addressRegistry) {
        Intrinsics.checkNotNullParameter((Object)((Object)chainId), (String)"chainId");
        Intrinsics.checkNotNullParameter((Object)addressRegistry, (String)"addressRegistry");
        DEFAULT_CHAIN_ID = chainId;
        DEFAULT_ADDRESS_REGISTRY = addressRegistry;
    }

    public static /* synthetic */ void configureDefaults$default(FlowChainId flowChainId, AddressRegistry addressRegistry, int n, Object object) {
        if ((n & 1) != 0) {
            flowChainId = DEFAULT_CHAIN_ID;
        }
        if ((n & 2) != 0) {
            addressRegistry = DEFAULT_ADDRESS_REGISTRY;
        }
        Flow.configureDefaults(flowChainId, addressRegistry);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final FlowAccessApi newAccessApi(@NotNull String host, int port, boolean secure, @NotNull String userAgent, int maxMessageSize) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
        ManagedChannel channel = Flow.openChannel(host, port, secure, userAgent, maxMessageSize);
        AccessAPIGrpc.AccessAPIBlockingStub accessAPIBlockingStub = AccessAPIGrpc.newBlockingStub((Channel)((Channel)channel));
        Intrinsics.checkNotNullExpressionValue((Object)accessAPIBlockingStub, (String)"newBlockingStub(...)");
        return new FlowAccessApiImpl(accessAPIBlockingStub);
    }

    public static /* synthetic */ FlowAccessApi newAccessApi$default(String string, int n, boolean bl, String string2, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 9000;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            string2 = DEFAULT_USER_AGENT;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 0x1000000;
        }
        return Flow.newAccessApi(string, n, bl, string2, n2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AsyncFlowAccessApi newAsyncAccessApi(@NotNull String host, int port, boolean secure, @NotNull String userAgent, int maxMessageSize) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
        ManagedChannel channel = Flow.openChannel(host, port, secure, userAgent, maxMessageSize);
        AccessAPIGrpc.AccessAPIFutureStub accessAPIFutureStub = AccessAPIGrpc.newFutureStub((Channel)((Channel)channel));
        Intrinsics.checkNotNullExpressionValue((Object)accessAPIFutureStub, (String)"newFutureStub(...)");
        return new AsyncFlowAccessApiImpl(accessAPIFutureStub);
    }

    public static /* synthetic */ AsyncFlowAccessApi newAsyncAccessApi$default(String string, int n, boolean bl, String string2, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 9000;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            string2 = DEFAULT_USER_AGENT;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 0x1000000;
        }
        return Flow.newAsyncAccessApi(string, n, bl, string2, n2);
    }

    @JvmStatic
    private static final ManagedChannel openChannel(String host, int port, boolean secure, String userAgent, int maxMessageSize) {
        ManagedChannelBuilder channelBuilder = ManagedChannelBuilder.forAddress((String)host, (int)port).userAgent(userAgent).maxInboundMessageSize(maxMessageSize);
        channelBuilder = secure ? channelBuilder.useTransportSecurity() : channelBuilder.usePlaintext();
        ManagedChannel managedChannel = channelBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"build(...)");
        return managedChannel;
    }

    @JvmStatic
    @NotNull
    public static final <T extends Field<?>> List<T> decodeJsonCadenceList(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return Flow.decodeJsonCadenceList(byArray);
    }

    @JvmStatic
    @NotNull
    public static final <T extends Field<?>> List<T> decodeJsonCadenceList(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Object object = OBJECT_MAPPER.readValue(bytes, new TypeReference<List<? extends T>>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (List)object;
    }

    @JvmStatic
    @NotNull
    public static final <T extends Field<?>> T decodeJsonCadence(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return Flow.decodeJsonCadence(byArray);
    }

    @JvmStatic
    @NotNull
    public static final <T extends Field<?>> T decodeJsonCadence(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Object object = OBJECT_MAPPER.readValue(bytes, new TypeReference<T>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (T)((Field)object);
    }

    @JvmStatic
    @NotNull
    public static final <T extends Field<?>> byte[] encodeJsonCadenceList(@NotNull Iterable<? extends T> jsonCadences) {
        Intrinsics.checkNotNullParameter(jsonCadences, (String)"jsonCadences");
        byte[] byArray = OBJECT_MAPPER.writeValueAsBytes(jsonCadences);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"writeValueAsBytes(...)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final <T extends Field<?>> byte[] encodeJsonCadence(@NotNull T jsonCadence) {
        Intrinsics.checkNotNullParameter(jsonCadence, (String)"jsonCadence");
        byte[] byArray = OBJECT_MAPPER.writeValueAsBytes(jsonCadence);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"writeValueAsBytes(...)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final <T> T unmarshall(@NotNull KClass<T> type, @NotNull Field<?> value, @NotNull FlowAddress namespace) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return JsonCadenceMarshalling.unmarshall(type, value, namespace);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T> T unmarshall(@NotNull KClass<T> type, @NotNull Field<?> value, @NotNull CadenceNamespace namespace) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return JsonCadenceMarshalling.unmarshall(type, value, namespace);
    }

    public static /* synthetic */ Object unmarshall$default(KClass kClass, Field field, CadenceNamespace cadenceNamespace, int n, Object object) {
        if ((n & 4) != 0) {
            cadenceNamespace = new CadenceNamespace(null, 1, null);
        }
        return Flow.unmarshall(kClass, field, cadenceNamespace);
    }

    @JvmStatic
    @NotNull
    public static final <T> Field<?> marshall(@NotNull T value, @NotNull KClass<? extends T> clazz, @NotNull FlowAddress namespace) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return JsonCadenceMarshalling.marshall(value, clazz, namespace);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T> Field<?> marshall(@NotNull T value, @NotNull KClass<? extends T> clazz, @NotNull CadenceNamespace namespace) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return JsonCadenceMarshalling.marshall(value, clazz, namespace);
    }

    public static /* synthetic */ Field marshall$default(Object object, KClass kClass, CadenceNamespace cadenceNamespace, int n, Object object2) {
        if ((n & 4) != 0) {
            cadenceNamespace = new CadenceNamespace(null, 1, null);
        }
        return Flow.marshall(object, kClass, cadenceNamespace);
    }

    @JvmStatic
    @NotNull
    public static final <T> Field<?> marshall(@NotNull T value, @NotNull FlowAddress namespace) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return JsonCadenceMarshalling.marshall(value, namespace);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T> Field<?> marshall(@NotNull T value, @NotNull CadenceNamespace namespace) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return JsonCadenceMarshalling.marshall(value, namespace);
    }

    public static /* synthetic */ Field marshall$default(Object object, CadenceNamespace cadenceNamespace, int n, Object object2) {
        if ((n & 2) != 0) {
            cadenceNamespace = new CadenceNamespace(null, 1, null);
        }
        return Flow.marshall(object, cadenceNamespace);
    }

    @JvmStatic
    @JvmOverloads
    public static final void configureDefaults(@NotNull FlowChainId chainId) {
        Intrinsics.checkNotNullParameter((Object)((Object)chainId), (String)"chainId");
        Flow.configureDefaults$default(chainId, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void configureDefaults() {
        Flow.configureDefaults$default(null, null, 3, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final FlowAccessApi newAccessApi(@NotNull String host, int port, boolean secure, @NotNull String userAgent) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
        return Flow.newAccessApi$default(host, port, secure, userAgent, 0, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final FlowAccessApi newAccessApi(@NotNull String host, int port, boolean secure) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return Flow.newAccessApi$default(host, port, secure, null, 0, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final FlowAccessApi newAccessApi(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return Flow.newAccessApi$default(host, port, false, null, 0, 28, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final FlowAccessApi newAccessApi(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return Flow.newAccessApi$default(host, 0, false, null, 0, 30, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AsyncFlowAccessApi newAsyncAccessApi(@NotNull String host, int port, boolean secure, @NotNull String userAgent) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
        return Flow.newAsyncAccessApi$default(host, port, secure, userAgent, 0, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AsyncFlowAccessApi newAsyncAccessApi(@NotNull String host, int port, boolean secure) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return Flow.newAsyncAccessApi$default(host, port, secure, null, 0, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AsyncFlowAccessApi newAsyncAccessApi(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return Flow.newAsyncAccessApi$default(host, port, false, null, 0, 28, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AsyncFlowAccessApi newAsyncAccessApi(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return Flow.newAsyncAccessApi$default(host, 0, false, null, 0, 30, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T> T unmarshall(@NotNull KClass<T> type, @NotNull Field<?> value) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return (T)Flow.unmarshall$default(type, value, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T> Field<?> marshall(@NotNull T value, @NotNull KClass<? extends T> clazz) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return Flow.marshall$default(value, clazz, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final <T> Field<?> marshall(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return Flow.marshall$default(value, null, 2, null);
    }

    static {
        ExtensionsKt.registerKotlinModule((ObjectMapper)OBJECT_MAPPER);
        OBJECT_MAPPER.findAndRegisterModules();
    }
}

