/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.onflow.flow.sdk.FlowAccessApi;
import org.onflow.flow.sdk.FlowException;
import org.onflow.flow.sdk.FlowId;
import org.onflow.flow.sdk.FlowTransaction;
import org.onflow.flow.sdk.FlowTransactionResult;
import org.onflow.flow.sdk.TransactionBuilder;
import org.onflow.flow.sdk.Transaction_dslKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0013J\u0006\u0010\u0016\u001a\u00020\u0013J\u0006\u0010\u0017\u001a\u00020\u0018J6\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00180\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001b2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0006\u0010 \u001a\u00020\u0000J6\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00180\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001b2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u001a\u0010\"\u001a\u00020\u00182\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001bJ\u001a\u0010#\u001a\u00020\u00182\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lorg/onflow/flow/sdk/FlowTransactionStub;", "", "api", "Lorg/onflow/flow/sdk/FlowAccessApi;", "builder", "Lorg/onflow/flow/sdk/TransactionBuilder;", "(Lorg/onflow/flow/sdk/FlowAccessApi;Lorg/onflow/flow/sdk/TransactionBuilder;)V", "<set-?>", "Lorg/onflow/flow/sdk/FlowTransaction;", "transaction", "getTransaction", "()Lorg/onflow/flow/sdk/FlowTransaction;", "Lorg/onflow/flow/sdk/FlowId;", "transactionId", "getTransactionId", "()Lorg/onflow/flow/sdk/FlowId;", "build", "buildIfNecessary", "checkBuilt", "", "checkNotBuilt", "checkNotSent", "checkSent", "getResult", "Lorg/onflow/flow/sdk/FlowTransactionResult;", "Lkotlin/Pair;", "pauseMs", "", "timeoutMs", "validStatusCodes", "", "", "send", "sendAndGetResult", "sendAndWaitForSeal", "waitForSeal", "flow-jvm-sdk"})
@SourceDebugExtension(value={"SMAP\ntransaction-dsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 transaction-dsl.kt\norg/onflow/flow/sdk/FlowTransactionStub\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,701:1\n1#2:702\n*E\n"})
public final class FlowTransactionStub {
    @NotNull
    private final FlowAccessApi api;
    @NotNull
    private final TransactionBuilder builder;
    @Nullable
    private FlowTransaction transaction;
    @Nullable
    private FlowId transactionId;

    public FlowTransactionStub(@NotNull FlowAccessApi api, @NotNull TransactionBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.api = api;
        this.builder = builder;
    }

    @Nullable
    public final FlowTransaction getTransaction() {
        return this.transaction;
    }

    @Nullable
    public final FlowId getTransactionId() {
        return this.transactionId;
    }

    public final void checkNotBuilt() {
        if (!(this.transaction == null)) {
            boolean bl = false;
            String string = "Transaction already built";
            throw new IllegalStateException(string.toString());
        }
    }

    public final void checkBuilt() {
        if (!(this.transaction != null)) {
            boolean bl = false;
            String string = "Transaction not built";
            throw new IllegalStateException(string.toString());
        }
    }

    public final void checkNotSent() {
        if (!(this.transactionId == null)) {
            boolean bl = false;
            String string = "Transaction already sent";
            throw new IllegalStateException(string.toString());
        }
    }

    public final void checkSent() {
        if (!(this.transactionId != null)) {
            boolean bl = false;
            String string = "Transaction not sent";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final FlowTransactionStub build() {
        this.checkNotBuilt();
        this.transaction = this.builder.build();
        return this;
    }

    @NotNull
    public final FlowTransactionStub buildIfNecessary() {
        if (this.transaction == null) {
            return this.build();
        }
        return this;
    }

    @NotNull
    public final FlowTransactionStub send() {
        FlowId flowId;
        this.buildIfNecessary();
        this.checkNotSent();
        FlowTransactionStub flowTransactionStub = this;
        try {
            FlowTransactionStub flowTransactionStub2 = flowTransactionStub;
            FlowTransaction flowTransaction = this.transaction;
            Intrinsics.checkNotNull((Object)flowTransaction);
            flowId = this.api.sendTransaction(flowTransaction);
        }
        catch (Throwable t) {
            FlowTransactionStub flowTransactionStub3 = flowTransactionStub;
            throw new FlowException("Error while executing transaction", t);
        }
        flowTransactionStub2.transactionId = flowId;
        return this;
    }

    @NotNull
    public final FlowTransactionResult sendAndWaitForSeal(@NotNull Number pauseMs, @NotNull Number timeoutMs) {
        Intrinsics.checkNotNullParameter((Object)pauseMs, (String)"pauseMs");
        Intrinsics.checkNotNullParameter((Object)timeoutMs, (String)"timeoutMs");
        return this.send().waitForSeal(pauseMs, timeoutMs);
    }

    public static /* synthetic */ FlowTransactionResult sendAndWaitForSeal$default(FlowTransactionStub flowTransactionStub, Number number, Number number2, int n, Object object) {
        if ((n & 1) != 0) {
            number = 500L;
        }
        if ((n & 2) != 0) {
            number2 = 10000L;
        }
        return flowTransactionStub.sendAndWaitForSeal(number, number2);
    }

    @NotNull
    public final FlowTransactionResult getResult() {
        this.checkSent();
        FlowId flowId = this.transactionId;
        Intrinsics.checkNotNull((Object)flowId);
        FlowTransactionResult flowTransactionResult = this.api.getTransactionResultById(flowId);
        if (flowTransactionResult == null) {
            boolean bl = false;
            String string = "Transaction wasn't found";
            throw new IllegalStateException(string.toString());
        }
        return flowTransactionResult;
    }

    @NotNull
    public final FlowTransactionResult waitForSeal(@NotNull Number pauseMs, @NotNull Number timeoutMs) {
        Intrinsics.checkNotNullParameter((Object)pauseMs, (String)"pauseMs");
        Intrinsics.checkNotNullParameter((Object)timeoutMs, (String)"timeoutMs");
        this.checkSent();
        FlowId flowId = this.transactionId;
        Intrinsics.checkNotNull((Object)flowId);
        return Transaction_dslKt.waitForSeal(this.api, flowId, pauseMs, timeoutMs);
    }

    public static /* synthetic */ FlowTransactionResult waitForSeal$default(FlowTransactionStub flowTransactionStub, Number number, Number number2, int n, Object object) {
        if ((n & 1) != 0) {
            number = 500L;
        }
        if ((n & 2) != 0) {
            number2 = 10000L;
        }
        return flowTransactionStub.waitForSeal(number, number2);
    }

    @NotNull
    public final Pair<FlowId, FlowTransactionResult> getResult(@NotNull Number pauseMs, @NotNull Number timeoutMs, @NotNull Set<Integer> validStatusCodes) {
        Intrinsics.checkNotNullParameter((Object)pauseMs, (String)"pauseMs");
        Intrinsics.checkNotNullParameter((Object)timeoutMs, (String)"timeoutMs");
        Intrinsics.checkNotNullParameter(validStatusCodes, (String)"validStatusCodes");
        this.checkSent();
        FlowId flowId = this.transactionId;
        Intrinsics.checkNotNull((Object)flowId);
        return TuplesKt.to((Object)flowId, (Object)this.waitForSeal(pauseMs, timeoutMs).throwOnError(validStatusCodes));
    }

    public static /* synthetic */ Pair getResult$default(FlowTransactionStub flowTransactionStub, Number number, Number number2, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            number = 500L;
        }
        if ((n & 2) != 0) {
            number2 = 10000L;
        }
        if ((n & 4) != 0) {
            set = SetsKt.setOf((Object)0);
        }
        return flowTransactionStub.getResult(number, number2, set);
    }

    @NotNull
    public final Pair<FlowId, FlowTransactionResult> sendAndGetResult(@NotNull Number pauseMs, @NotNull Number timeoutMs, @NotNull Set<Integer> validStatusCodes) {
        Intrinsics.checkNotNullParameter((Object)pauseMs, (String)"pauseMs");
        Intrinsics.checkNotNullParameter((Object)timeoutMs, (String)"timeoutMs");
        Intrinsics.checkNotNullParameter(validStatusCodes, (String)"validStatusCodes");
        this.send();
        return this.getResult(pauseMs, timeoutMs, validStatusCodes);
    }

    public static /* synthetic */ Pair sendAndGetResult$default(FlowTransactionStub flowTransactionStub, Number number, Number number2, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            number = 500L;
        }
        if ((n & 2) != 0) {
            number2 = 10000L;
        }
        if ((n & 4) != 0) {
            set = SetsKt.setOf((Object)0);
        }
        return flowTransactionStub.sendAndGetResult(number, number2, set);
    }
}

