/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.onflow.flow.sdk.AddressRegistry;
import org.onflow.flow.sdk.Flow;
import org.onflow.flow.sdk.FlowAccessApi;
import org.onflow.flow.sdk.FlowAccount;
import org.onflow.flow.sdk.FlowAddress;
import org.onflow.flow.sdk.FlowAddressCollectionBuilder;
import org.onflow.flow.sdk.FlowArgument;
import org.onflow.flow.sdk.FlowArgumentsBuilder;
import org.onflow.flow.sdk.FlowChainId;
import org.onflow.flow.sdk.FlowId;
import org.onflow.flow.sdk.FlowScript;
import org.onflow.flow.sdk.FlowSignature;
import org.onflow.flow.sdk.FlowTransaction;
import org.onflow.flow.sdk.FlowTransactionProposalKey;
import org.onflow.flow.sdk.FlowTransactionProposalKeyBuilder;
import org.onflow.flow.sdk.FlowTransactionSignature;
import org.onflow.flow.sdk.FlowTransactionSignatureBuilder;
import org.onflow.flow.sdk.FlowTransactionSignatureCollectionBuilder;
import org.onflow.flow.sdk.PendingSignature;
import org.onflow.flow.sdk.Signer;
import org.onflow.flow.sdk.cadence.Field;
import org.onflow.flow.sdk.cadence.JsonCadenceBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b+\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010R\u001a\u00020S2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0\u0006J\u001f\u0010T\u001a\u00020S2\u0017\u00100\u001a\u0013\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u00020S0U\u00a2\u0006\u0002\bWJ\u001f\u0010X\u001a\u00020S2\u0017\u0010=\u001a\u0013\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u00020S0U\u00a2\u0006\u0002\bWJ\u001f\u0010Y\u001a\u00020S2\u0017\u0010O\u001a\u0013\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u00020S0U\u00a2\u0006\u0002\bWJ\u0014\u0010\u0019\u001a\u00020S2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u001a0[J\u000e\u0010\u0019\u001a\u00020S2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\\\u001a\u00020]2\u0006\u0010\\\u001a\u00020\u0007J\u0012\u0010\\\u001a\u00020]2\n\u0010\\\u001a\u0006\u0012\u0002\b\u00030^J#\u0010\\\u001a\u00020]2\u001b\u0010\\\u001a\u0017\u0012\u0004\u0012\u00020_\u0012\b\u0012\u0006\u0012\u0002\b\u00030^0U\u00a2\u0006\u0002\bWJ\u0014\u0010\"\u001a\u00020S2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u001f\u0010\"\u001a\u00020S2\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020`\u0012\u0004\u0012\u00020S0U\u00a2\u0006\u0002\bWJ\u0014\u0010a\u001a\u00020]2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020\t0[J\u000e\u0010a\u001a\u00020]2\u0006\u0010b\u001a\u00020cJ\u000e\u0010a\u001a\u00020]2\u0006\u0010b\u001a\u00020dJ\u000e\u0010a\u001a\u00020]2\u0006\u0010b\u001a\u00020\tJ\u0014\u0010(\u001a\u00020S2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0\u0006J\u001f\u0010(\u001a\u00020S2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020e\u0012\u0004\u0012\u00020S0U\u00a2\u0006\u0002\bWJ\u0006\u0010f\u001a\u00020gJ\u0014\u0010+\u001a\u00020S2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0[J\u000e\u0010+\u001a\u00020S2\u0006\u0010+\u001a\u00020\u000bJ\u001e\u0010h\u001a\u00020S2\u0006\u0010b\u001a\u00020\t2\u0006\u0010i\u001a\u00020\u000f2\u0006\u0010j\u001a\u00020kJ\u001e\u0010h\u001a\u00020S2\u0006\u0010b\u001a\u00020\t2\u0006\u0010i\u001a\u00020\u000f2\u0006\u0010l\u001a\u00020mJ\u000e\u0010h\u001a\u00020S2\u0006\u0010j\u001a\u00020nJ\u001f\u0010h\u001a\u00020S2\u0017\u0010h\u001a\u0013\u0012\u0004\u0012\u00020o\u0012\u0004\u0012\u00020S0U\u00a2\u0006\u0002\bWJ\u000e\u0010h\u001a\u00020]2\u0006\u0010h\u001a\u00020\rJ\u0014\u00100\u001a\u00020S2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\r0\u0006J\u001f\u00100\u001a\u00020S2\u0017\u00100\u001a\u0013\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u00020S0U\u00a2\u0006\u0002\bWJ\u0014\u00103\u001a\u00020S2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000f0[J\u000e\u00103\u001a\u00020S2\u0006\u00103\u001a\u00020\u000fJ\u0014\u00108\u001a\u00020S2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\t0[J\u000e\u00108\u001a\u00020S2\u0006\u00108\u001a\u00020cJ\u000e\u00108\u001a\u00020S2\u0006\u00108\u001a\u00020dJ\u000e\u00108\u001a\u00020S2\u0006\u00108\u001a\u00020\tJ\u0014\u0010p\u001a\u00020]2\f\u0010p\u001a\b\u0012\u0004\u0012\u00020\r0[J\u001e\u0010p\u001a\u00020S2\u0006\u0010b\u001a\u00020\t2\u0006\u0010i\u001a\u00020\u000f2\u0006\u0010j\u001a\u00020kJ\u001e\u0010p\u001a\u00020S2\u0006\u0010b\u001a\u00020\t2\u0006\u0010i\u001a\u00020\u000f2\u0006\u0010l\u001a\u00020mJ\u000e\u0010p\u001a\u00020]2\u0006\u0010p\u001a\u00020\rJ\u0014\u0010=\u001a\u00020S2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\r0\u0006J\u001f\u0010=\u001a\u00020S2\u0017\u0010=\u001a\u0013\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u00020S0U\u00a2\u0006\u0002\bWJ\u0016\u0010@\u001a\u00020S2\u0006\u0010b\u001a\u00020\t2\u0006\u0010i\u001a\u00020\u000fJ\u001e\u0010@\u001a\u00020S2\u0006\u0010b\u001a\u00020\t2\u0006\u0010i\u001a\u00020\u000f2\u0006\u0010q\u001a\u00020\u000fJ\u0016\u0010@\u001a\u00020S2\u0006\u0010b\u001a\u00020\t2\u0006\u0010r\u001a\u00020dJ\u000e\u0010@\u001a\u00020S2\u0006\u0010@\u001a\u00020\u0013J\u001f\u0010@\u001a\u00020S2\u0017\u0010@\u001a\u0013\u0012\u0004\u0012\u00020s\u0012\u0004\u0012\u00020S0U\u00a2\u0006\u0002\bWJ\u001e\u0010t\u001a\u00020S2\u0006\u0010b\u001a\u00020\t2\u0006\u0010i\u001a\u00020\u000f2\u0006\u0010l\u001a\u00020mJ&\u0010t\u001a\u00020S2\u0006\u0010b\u001a\u00020\t2\u0006\u0010i\u001a\u00020\u000f2\u0006\u0010l\u001a\u00020m2\u0006\u0010q\u001a\u00020\u000fJ\u0014\u0010E\u001a\u00020S2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00150[J\u000e\u0010E\u001a\u00020S2\u0006\u0010E\u001a\u00020cJ\u000e\u0010E\u001a\u00020S2\u0006\u0010E\u001a\u00020dJ\u000e\u0010E\u001a\u00020S2\u0006\u0010E\u001a\u00020\u0015J.\u0010J\u001a\u00020S2\u0006\u0010u\u001a\u00020c2\b\b\u0002\u0010v\u001a\u00020\u000b2\u0014\b\u0002\u0010w\u001a\u000e\u0012\u0004\u0012\u00020d\u0012\u0004\u0012\u00020\t0xJ.\u0010J\u001a\u00020S2\u0006\u0010u\u001a\u00020d2\b\b\u0002\u0010v\u001a\u00020\u000b2\u0014\b\u0002\u0010w\u001a\u000e\u0012\u0004\u0012\u00020d\u0012\u0004\u0012\u00020\t0xJ4\u0010J\u001a\u00020S2\b\b\u0002\u0010v\u001a\u00020\u000b2\u0014\b\u0002\u0010w\u001a\u000e\u0012\u0004\u0012\u00020d\u0012\u0004\u0012\u00020\t0x2\f\u0010u\u001a\b\u0012\u0004\u0012\u00020d0[J\u000e\u0010J\u001a\u00020S2\u0006\u0010J\u001a\u00020\u0017J\u0014\u0010j\u001a\u00020S2\f\u0010j\u001a\b\u0012\u0004\u0012\u00020\r0[J\u001e\u0010j\u001a\u00020S2\u0006\u0010b\u001a\u00020\t2\u0006\u0010i\u001a\u00020\u000f2\u0006\u0010j\u001a\u00020kJ\u001e\u0010j\u001a\u00020S2\u0006\u0010b\u001a\u00020\t2\u0006\u0010i\u001a\u00020\u000f2\u0006\u0010l\u001a\u00020mJ\u000e\u0010j\u001a\u00020S2\u0006\u0010j\u001a\u00020\rJ\u001f\u0010O\u001a\u00020S2\u0017\u0010O\u001a\u0013\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u00020S0U\u00a2\u0006\u0002\bWR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R0\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R0\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0'2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010$\"\u0004\b*\u0010&R$\u0010+\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R0\u00100\u001a\b\u0012\u0004\u0012\u00020\r0'2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010$\"\u0004\b2\u0010&R$\u00103\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b4\u00105\"\u0004\b6\u00107R$\u00108\u001a\u00020\t2\u0006\u0010!\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R0\u0010=\u001a\b\u0012\u0004\u0012\u00020\r0'2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010$\"\u0004\b?\u0010&R$\u0010@\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR$\u0010E\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR$\u0010J\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00178F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR0\u0010O\u001a\b\u0012\u0004\u0012\u00020\r0'2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bP\u0010$\"\u0004\bQ\u0010&\u00a8\u0006y"}, d2={"Lorg/onflow/flow/sdk/TransactionBuilder;", "", "api", "Lorg/onflow/flow/sdk/FlowAccessApi;", "(Lorg/onflow/flow/sdk/FlowAccessApi;)V", "_arguments", "", "Lorg/onflow/flow/sdk/FlowArgument;", "_authorizers", "Lorg/onflow/flow/sdk/FlowAddress;", "_chainId", "Lorg/onflow/flow/sdk/FlowChainId;", "_envelopeSignatures", "Lorg/onflow/flow/sdk/PendingSignature;", "_gasLimit", "", "_payerAddress", "_payloadSignatures", "_proposalKey", "Lorg/onflow/flow/sdk/FlowTransactionProposalKey;", "_referenceBlockId", "Lorg/onflow/flow/sdk/FlowId;", "_script", "Lorg/onflow/flow/sdk/FlowScript;", "_signatures", "addressRegistry", "Lorg/onflow/flow/sdk/AddressRegistry;", "getAddressRegistry", "()Lorg/onflow/flow/sdk/AddressRegistry;", "setAddressRegistry", "(Lorg/onflow/flow/sdk/AddressRegistry;)V", "getApi", "()Lorg/onflow/flow/sdk/FlowAccessApi;", "value", "arguments", "getArguments", "()Ljava/util/List;", "setArguments", "(Ljava/util/List;)V", "", "authorizers", "getAuthorizers", "setAuthorizers", "chainId", "getChainId", "()Lorg/onflow/flow/sdk/FlowChainId;", "setChainId", "(Lorg/onflow/flow/sdk/FlowChainId;)V", "envelopeSignatures", "getEnvelopeSignatures", "setEnvelopeSignatures", "gasLimit", "getGasLimit", "()Ljava/lang/Number;", "setGasLimit", "(Ljava/lang/Number;)V", "payerAddress", "getPayerAddress", "()Lorg/onflow/flow/sdk/FlowAddress;", "setPayerAddress", "(Lorg/onflow/flow/sdk/FlowAddress;)V", "payloadSignatures", "getPayloadSignatures", "setPayloadSignatures", "proposalKey", "getProposalKey", "()Lorg/onflow/flow/sdk/FlowTransactionProposalKey;", "setProposalKey", "(Lorg/onflow/flow/sdk/FlowTransactionProposalKey;)V", "referenceBlockId", "getReferenceBlockId", "()Lorg/onflow/flow/sdk/FlowId;", "setReferenceBlockId", "(Lorg/onflow/flow/sdk/FlowId;)V", "script", "getScript", "()Lorg/onflow/flow/sdk/FlowScript;", "setScript", "(Lorg/onflow/flow/sdk/FlowScript;)V", "signatures", "getSignatures", "setSignatures", "addAuthorizers", "", "addEnvelopeSignatures", "Lkotlin/Function1;", "Lorg/onflow/flow/sdk/FlowTransactionSignatureCollectionBuilder;", "Lkotlin/ExtensionFunctionType;", "addPayloadSignatures", "addSignatures", "block", "Lkotlin/Function0;", "argument", "", "Lorg/onflow/flow/sdk/cadence/Field;", "Lorg/onflow/flow/sdk/cadence/JsonCadenceBuilder;", "Lorg/onflow/flow/sdk/FlowArgumentsBuilder;", "authorizer", "address", "", "", "Lorg/onflow/flow/sdk/FlowAddressCollectionBuilder;", "build", "Lorg/onflow/flow/sdk/FlowTransaction;", "envelopeSignature", "keyIndex", "signature", "Lorg/onflow/flow/sdk/FlowSignature;", "signer", "Lorg/onflow/flow/sdk/Signer;", "Lorg/onflow/flow/sdk/FlowTransactionSignature;", "Lorg/onflow/flow/sdk/FlowTransactionSignatureBuilder;", "payloadSignature", "sequenceNumber", "publicKey", "Lorg/onflow/flow/sdk/FlowTransactionProposalKeyBuilder;", "proposeAndPay", "code", "chain", "addresses", "", "flow-jvm-sdk"})
@SourceDebugExtension(value={"SMAP\ntransaction-dsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 transaction-dsl.kt\norg/onflow/flow/sdk/TransactionBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,701:1\n1#2:702\n1855#3,2:703\n1855#3,2:705\n766#3:707\n857#3,2:708\n766#3:710\n857#3,2:711\n*S KotlinDebug\n*F\n+ 1 transaction-dsl.kt\norg/onflow/flow/sdk/TransactionBuilder\n*L\n298#1:703,2\n304#1:705,2\n447#1:707\n447#1:708,2\n450#1:710\n450#1:711,2\n*E\n"})
public final class TransactionBuilder {
    @Nullable
    private final FlowAccessApi api;
    @NotNull
    private AddressRegistry addressRegistry;
    @NotNull
    private FlowChainId _chainId;
    @Nullable
    private FlowScript _script;
    @NotNull
    private List<FlowArgument> _arguments;
    @Nullable
    private FlowId _referenceBlockId;
    @Nullable
    private Number _gasLimit;
    @Nullable
    private FlowTransactionProposalKey _proposalKey;
    @Nullable
    private FlowAddress _payerAddress;
    @NotNull
    private List<PendingSignature> _signatures;
    @NotNull
    private List<FlowAddress> _authorizers;
    @NotNull
    private List<PendingSignature> _payloadSignatures;
    @NotNull
    private List<PendingSignature> _envelopeSignatures;

    public TransactionBuilder(@Nullable FlowAccessApi api) {
        this.api = api;
        this.addressRegistry = Flow.INSTANCE.getDEFAULT_ADDRESS_REGISTRY();
        this._chainId = Flow.INSTANCE.getDEFAULT_CHAIN_ID();
        this._arguments = new ArrayList();
        this._signatures = new ArrayList();
        this._authorizers = new ArrayList();
        this._payloadSignatures = new ArrayList();
        this._envelopeSignatures = new ArrayList();
    }

    public /* synthetic */ TransactionBuilder(FlowAccessApi flowAccessApi, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            flowAccessApi = null;
        }
        this(flowAccessApi);
    }

    @Nullable
    public final FlowAccessApi getApi() {
        return this.api;
    }

    @NotNull
    public final AddressRegistry getAddressRegistry() {
        return this.addressRegistry;
    }

    public final void setAddressRegistry(@NotNull AddressRegistry addressRegistry) {
        Intrinsics.checkNotNullParameter((Object)addressRegistry, (String)"<set-?>");
        this.addressRegistry = addressRegistry;
    }

    public final void addressRegistry(@NotNull AddressRegistry addressRegistry) {
        Intrinsics.checkNotNullParameter((Object)addressRegistry, (String)"addressRegistry");
        this.addressRegistry = addressRegistry;
    }

    public final void addressRegistry(@NotNull Function0<AddressRegistry> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.addressRegistry((AddressRegistry)block.invoke());
    }

    @NotNull
    public final FlowScript getScript() {
        FlowScript flowScript = this._script;
        Intrinsics.checkNotNull((Object)flowScript);
        return flowScript;
    }

    public final void setScript(@NotNull FlowScript value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._script = value;
    }

    public final void script(@NotNull FlowScript script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        this.setScript(script);
    }

    public final void script(@NotNull String code, @NotNull FlowChainId chain, @NotNull Map<String, FlowAddress> addresses) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)((Object)chain), (String)"chain");
        Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
        this.script(new FlowScript(this.addressRegistry.processScript(code, chain, addresses)));
    }

    public static /* synthetic */ void script$default(TransactionBuilder transactionBuilder, String string, FlowChainId flowChainId, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            flowChainId = transactionBuilder._chainId;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        transactionBuilder.script(string, flowChainId, (Map<String, FlowAddress>)map);
    }

    public final void script(@NotNull byte[] code, @NotNull FlowChainId chain, @NotNull Map<String, FlowAddress> addresses) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)((Object)chain), (String)"chain");
        Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
        this.script(new String(code, Charsets.UTF_8), chain, addresses);
    }

    public static /* synthetic */ void script$default(TransactionBuilder transactionBuilder, byte[] byArray, FlowChainId flowChainId, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            flowChainId = transactionBuilder._chainId;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        transactionBuilder.script(byArray, flowChainId, (Map<String, FlowAddress>)map);
    }

    public final void script(@NotNull FlowChainId chain, @NotNull Map<String, FlowAddress> addresses, @NotNull Function0<String> code) {
        Intrinsics.checkNotNullParameter((Object)((Object)chain), (String)"chain");
        Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        this.script((String)code.invoke(), chain, addresses);
    }

    public static /* synthetic */ void script$default(TransactionBuilder transactionBuilder, FlowChainId flowChainId, Map map, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            flowChainId = transactionBuilder._chainId;
        }
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        transactionBuilder.script(flowChainId, map, (Function0<String>)function0);
    }

    @NotNull
    public final List<FlowArgument> getArguments() {
        return this._arguments;
    }

    public final void setArguments(@NotNull List<FlowArgument> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this._arguments.clear();
        this._arguments.addAll((Collection<FlowArgument>)value);
    }

    public final void arguments(@NotNull List<FlowArgument> arguments) {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        this.setArguments(arguments);
    }

    public final void arguments(@NotNull Function1<? super FlowArgumentsBuilder, Unit> arguments) {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        FlowArgumentsBuilder builder = new FlowArgumentsBuilder();
        arguments.invoke((Object)builder);
        this.setArguments(builder.build());
    }

    public final boolean argument(@NotNull FlowArgument argument) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return this._arguments.add(argument);
    }

    public final boolean argument(@NotNull Field<?> argument) {
        Intrinsics.checkNotNullParameter(argument, (String)"argument");
        return this._arguments.add(new FlowArgument(argument));
    }

    public final boolean argument(@NotNull Function1<? super JsonCadenceBuilder, ? extends Field<?>> argument) {
        Intrinsics.checkNotNullParameter(argument, (String)"argument");
        return this.argument((Field)argument.invoke((Object)new JsonCadenceBuilder()));
    }

    @NotNull
    public final FlowId getReferenceBlockId() {
        FlowId flowId = this._referenceBlockId;
        Intrinsics.checkNotNull((Object)flowId);
        return flowId;
    }

    public final void setReferenceBlockId(@NotNull FlowId value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._referenceBlockId = value;
    }

    public final void referenceBlockId(@NotNull FlowId referenceBlockId) {
        Intrinsics.checkNotNullParameter((Object)referenceBlockId, (String)"referenceBlockId");
        this.setReferenceBlockId(referenceBlockId);
    }

    public final void referenceBlockId(@NotNull String referenceBlockId) {
        Intrinsics.checkNotNullParameter((Object)referenceBlockId, (String)"referenceBlockId");
        this.referenceBlockId(new FlowId(referenceBlockId));
    }

    public final void referenceBlockId(@NotNull byte[] referenceBlockId) {
        Intrinsics.checkNotNullParameter((Object)referenceBlockId, (String)"referenceBlockId");
        this.referenceBlockId(FlowId.Companion.of(referenceBlockId));
    }

    public final void referenceBlockId(@NotNull Function0<FlowId> referenceBlockId) {
        Intrinsics.checkNotNullParameter(referenceBlockId, (String)"referenceBlockId");
        this.referenceBlockId((FlowId)referenceBlockId.invoke());
    }

    @NotNull
    public final Number getGasLimit() {
        Number number = this._gasLimit;
        Intrinsics.checkNotNull((Object)number);
        return number;
    }

    public final void setGasLimit(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._gasLimit = value;
    }

    public final void gasLimit(@NotNull Number gasLimit) {
        Intrinsics.checkNotNullParameter((Object)gasLimit, (String)"gasLimit");
        this.setGasLimit(gasLimit.longValue());
    }

    public final void gasLimit(@NotNull Function0<? extends Number> gasLimit) {
        Intrinsics.checkNotNullParameter(gasLimit, (String)"gasLimit");
        this.gasLimit((Number)gasLimit.invoke());
    }

    @NotNull
    public final FlowChainId getChainId() {
        return this._chainId;
    }

    public final void setChainId(@NotNull FlowChainId value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this._chainId = value;
    }

    public final void chainId(@NotNull FlowChainId chainId) {
        Intrinsics.checkNotNullParameter((Object)((Object)chainId), (String)"chainId");
        this.setChainId(chainId);
    }

    public final void chainId(@NotNull Function0<? extends FlowChainId> chainId) {
        Intrinsics.checkNotNullParameter(chainId, (String)"chainId");
        this.chainId((FlowChainId)((Object)chainId.invoke()));
    }

    @NotNull
    public final FlowTransactionProposalKey getProposalKey() {
        FlowTransactionProposalKey flowTransactionProposalKey = this._proposalKey;
        Intrinsics.checkNotNull((Object)flowTransactionProposalKey);
        return flowTransactionProposalKey;
    }

    public final void setProposalKey(@NotNull FlowTransactionProposalKey value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._proposalKey = value;
    }

    public final void proposalKey(@NotNull FlowTransactionProposalKey proposalKey) {
        Intrinsics.checkNotNullParameter((Object)proposalKey, (String)"proposalKey");
        this.setProposalKey(proposalKey);
    }

    public final void proposalKey(@NotNull FlowAddress address, @NotNull Number keyIndex, @NotNull Number sequenceNumber) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)keyIndex, (String)"keyIndex");
        Intrinsics.checkNotNullParameter((Object)sequenceNumber, (String)"sequenceNumber");
        this.proposalKey(new FlowTransactionProposalKey(address, keyIndex.intValue(), sequenceNumber.longValue()));
    }

    public final void proposalKey(@NotNull FlowAddress address, @NotNull String publicKey) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        if (!(this.api != null)) {
            boolean $i$a$-require-TransactionBuilder$proposalKey$32 = false;
            String $i$a$-require-TransactionBuilder$proposalKey$32 = "Builder not created with an API instance";
            throw new IllegalArgumentException($i$a$-require-TransactionBuilder$proposalKey$32.toString());
        }
        FlowAccount flowAccount = this.api.getAccountAtLatestBlock(address);
        if (flowAccount == null) {
            boolean bl = false;
            String string = "Account for address not found";
            throw new IllegalArgumentException(string.toString());
        }
        FlowAccount account = flowAccount;
        int keyIndex = account.getKeyIndex(publicKey);
        if (!(keyIndex != -1)) {
            boolean bl = false;
            String string = "PublicKey not found for account";
            throw new IllegalArgumentException(string.toString());
        }
        this.proposalKey(new FlowTransactionProposalKey(address, keyIndex, account.getKeys().get(keyIndex).getSequenceNumber()));
    }

    public final void proposalKey(@NotNull FlowAddress address, @NotNull Number keyIndex) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)keyIndex, (String)"keyIndex");
        if (!(this.api != null)) {
            boolean bl = false;
            String string = "Builder not created with an API instance";
            throw new IllegalArgumentException(string.toString());
        }
        FlowAccount flowAccount = this.api.getAccountAtLatestBlock(address);
        if (flowAccount == null) {
            boolean $i$a$-requireNotNull-TransactionBuilder$proposalKey$account$32 = false;
            String $i$a$-requireNotNull-TransactionBuilder$proposalKey$account$32 = "Account for address not found";
            throw new IllegalArgumentException($i$a$-requireNotNull-TransactionBuilder$proposalKey$account$32.toString());
        }
        FlowAccount account = flowAccount;
        if (!(!Intrinsics.areEqual((Object)keyIndex, (Object)-1))) {
            boolean $i$a$-require-TransactionBuilder$proposalKey$62 = false;
            String $i$a$-require-TransactionBuilder$proposalKey$62 = "PublicKey not found for account";
            throw new IllegalArgumentException($i$a$-require-TransactionBuilder$proposalKey$62.toString());
        }
        if (!(keyIndex.intValue() < account.getKeys().size())) {
            boolean bl = false;
            String string = "keyIndex out of bounds";
            throw new IllegalArgumentException(string.toString());
        }
        this.proposalKey(new FlowTransactionProposalKey(address, keyIndex.intValue(), account.getKeys().get(keyIndex.intValue()).getSequenceNumber()));
    }

    public final void proposalKey(@NotNull Function1<? super FlowTransactionProposalKeyBuilder, Unit> proposalKey) {
        Intrinsics.checkNotNullParameter(proposalKey, (String)"proposalKey");
        FlowTransactionProposalKeyBuilder builder = new FlowTransactionProposalKeyBuilder(this.api);
        proposalKey.invoke((Object)builder);
        this.proposalKey(builder.build());
    }

    public final void proposeAndPay(@NotNull FlowAddress address, @NotNull Number keyIndex, @NotNull Signer signer, @NotNull Number sequenceNumber) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)keyIndex, (String)"keyIndex");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        Intrinsics.checkNotNullParameter((Object)sequenceNumber, (String)"sequenceNumber");
        this.proposalKey(address, keyIndex, sequenceNumber);
        this.payerAddress(address);
        this.signature(address, keyIndex, signer);
    }

    public final void proposeAndPay(@NotNull FlowAddress address, @NotNull Number keyIndex, @NotNull Signer signer) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)keyIndex, (String)"keyIndex");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        if (!(this.api != null)) {
            boolean bl = false;
            String string = "Builder not created with an API instance";
            throw new IllegalArgumentException(string.toString());
        }
        FlowAccount flowAccount = this.api.getAccountAtLatestBlock(address);
        if (flowAccount == null) {
            boolean $i$a$-requireNotNull-TransactionBuilder$proposeAndPay$account$22 = false;
            String $i$a$-requireNotNull-TransactionBuilder$proposeAndPay$account$22 = "Account for address not found";
            throw new IllegalArgumentException($i$a$-requireNotNull-TransactionBuilder$proposeAndPay$account$22.toString());
        }
        FlowAccount account = flowAccount;
        if (!(keyIndex.intValue() < account.getKeys().size())) {
            boolean bl = false;
            String string = "keyIndex out of bounds";
            throw new IllegalArgumentException(string.toString());
        }
        this.proposeAndPay(address, keyIndex, signer, account.getKeys().get(keyIndex.intValue()).getSequenceNumber());
    }

    @NotNull
    public final FlowAddress getPayerAddress() {
        FlowAddress flowAddress = this._payerAddress;
        Intrinsics.checkNotNull((Object)flowAddress);
        return flowAddress;
    }

    public final void setPayerAddress(@NotNull FlowAddress value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._payerAddress = value;
    }

    public final void payerAddress(@NotNull FlowAddress payerAddress) {
        Intrinsics.checkNotNullParameter((Object)payerAddress, (String)"payerAddress");
        this.setPayerAddress(payerAddress);
    }

    public final void payerAddress(@NotNull String payerAddress) {
        Intrinsics.checkNotNullParameter((Object)payerAddress, (String)"payerAddress");
        this.payerAddress(new FlowAddress(payerAddress));
    }

    public final void payerAddress(@NotNull byte[] payerAddress) {
        Intrinsics.checkNotNullParameter((Object)payerAddress, (String)"payerAddress");
        this.payerAddress(FlowAddress.Companion.of(payerAddress));
    }

    public final void payerAddress(@NotNull Function0<FlowAddress> payerAddress) {
        Intrinsics.checkNotNullParameter(payerAddress, (String)"payerAddress");
        this.payerAddress((FlowAddress)payerAddress.invoke());
    }

    @NotNull
    public final List<FlowAddress> getAuthorizers() {
        return this._authorizers;
    }

    public final void setAuthorizers(@NotNull List<FlowAddress> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this._authorizers.clear();
        this._authorizers.addAll((Collection<FlowAddress>)value);
    }

    public final void addAuthorizers(@NotNull List<FlowAddress> authorizers) {
        Intrinsics.checkNotNullParameter(authorizers, (String)"authorizers");
        this._authorizers.addAll((Collection<FlowAddress>)authorizers);
    }

    public final void authorizers(@NotNull List<FlowAddress> authorizers) {
        Intrinsics.checkNotNullParameter(authorizers, (String)"authorizers");
        this.setAuthorizers(authorizers);
    }

    public final void authorizers(@NotNull Function1<? super FlowAddressCollectionBuilder, Unit> authorizers) {
        Intrinsics.checkNotNullParameter(authorizers, (String)"authorizers");
        FlowAddressCollectionBuilder builder = new FlowAddressCollectionBuilder();
        authorizers.invoke((Object)builder);
        this.setAuthorizers(builder.build());
    }

    public final boolean authorizer(@NotNull FlowAddress address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return this._authorizers.add(address);
    }

    public final boolean authorizer(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return this.authorizer(new FlowAddress(address));
    }

    public final boolean authorizer(@NotNull byte[] address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return this.authorizer(FlowAddress.Companion.of(address));
    }

    public final boolean authorizer(@NotNull Function0<FlowAddress> authorizer) {
        Intrinsics.checkNotNullParameter(authorizer, (String)"authorizer");
        return this.authorizer((FlowAddress)authorizer.invoke());
    }

    @NotNull
    public final List<PendingSignature> getSignatures() {
        return this._signatures;
    }

    public final void setSignatures(@NotNull List<PendingSignature> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this._signatures.clear();
        this._authorizers.clear();
        Iterable $this$forEach$iv = value;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PendingSignature p0 = (PendingSignature)element$iv;
            boolean bl = false;
            this.signature(p0);
        }
    }

    public final void addSignatures(@NotNull Function1<? super FlowTransactionSignatureCollectionBuilder, Unit> signatures) {
        Intrinsics.checkNotNullParameter(signatures, (String)"signatures");
        FlowTransactionSignatureCollectionBuilder builder = new FlowTransactionSignatureCollectionBuilder();
        signatures.invoke((Object)builder);
        Iterable $this$forEach$iv = builder.build();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PendingSignature p0 = (PendingSignature)element$iv;
            boolean bl = false;
            this.signature(p0);
        }
    }

    public final void signatures(@NotNull Function1<? super FlowTransactionSignatureCollectionBuilder, Unit> signatures) {
        Intrinsics.checkNotNullParameter(signatures, (String)"signatures");
        FlowTransactionSignatureCollectionBuilder builder = new FlowTransactionSignatureCollectionBuilder();
        signatures.invoke((Object)builder);
        this.setSignatures(builder.build());
    }

    public final void signature(@NotNull PendingSignature signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this._signatures.add(signature);
        if (signature.getAddress() != null) {
            this._authorizers.add(signature.getAddress());
        } else {
            FlowTransactionSignature flowTransactionSignature = signature.getPrepared();
            if ((flowTransactionSignature != null ? flowTransactionSignature.getAddress() : null) != null) {
                this._authorizers.add(signature.getPrepared().getAddress());
            }
        }
    }

    public final void signature(@NotNull Function0<PendingSignature> signature) {
        Intrinsics.checkNotNullParameter(signature, (String)"signature");
        this.signature((PendingSignature)signature.invoke());
    }

    public final void signature(@NotNull FlowAddress address, @NotNull Number keyIndex, @NotNull FlowSignature signature) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)keyIndex, (String)"keyIndex");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this.signature(new PendingSignature(null, address, keyIndex, null, signature, 9, null));
    }

    public final void signature(@NotNull FlowAddress address, @NotNull Number keyIndex, @NotNull Signer signer) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)keyIndex, (String)"keyIndex");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        this.signature(new PendingSignature(null, address, keyIndex, signer, null, 17, null));
    }

    @NotNull
    public final List<PendingSignature> getPayloadSignatures() {
        return this._payloadSignatures;
    }

    public final void setPayloadSignatures(@NotNull List<PendingSignature> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this._payloadSignatures.clear();
        this._payloadSignatures.addAll((Collection<PendingSignature>)value);
    }

    public final void payloadSignatures(@NotNull List<PendingSignature> payloadSignatures) {
        Intrinsics.checkNotNullParameter(payloadSignatures, (String)"payloadSignatures");
        this.setPayloadSignatures(payloadSignatures);
    }

    public final void addPayloadSignatures(@NotNull Function1<? super FlowTransactionSignatureCollectionBuilder, Unit> payloadSignatures) {
        Intrinsics.checkNotNullParameter(payloadSignatures, (String)"payloadSignatures");
        FlowTransactionSignatureCollectionBuilder builder = new FlowTransactionSignatureCollectionBuilder();
        payloadSignatures.invoke((Object)builder);
        this._payloadSignatures.addAll((Collection<PendingSignature>)builder.build());
    }

    public final void payloadSignatures(@NotNull Function1<? super FlowTransactionSignatureCollectionBuilder, Unit> payloadSignatures) {
        Intrinsics.checkNotNullParameter(payloadSignatures, (String)"payloadSignatures");
        FlowTransactionSignatureCollectionBuilder builder = new FlowTransactionSignatureCollectionBuilder();
        payloadSignatures.invoke((Object)builder);
        this.setPayloadSignatures(builder.build());
    }

    public final boolean payloadSignature(@NotNull PendingSignature payloadSignature) {
        Intrinsics.checkNotNullParameter((Object)payloadSignature, (String)"payloadSignature");
        return this._payloadSignatures.add(payloadSignature);
    }

    public final boolean payloadSignature(@NotNull Function0<PendingSignature> payloadSignature) {
        Intrinsics.checkNotNullParameter(payloadSignature, (String)"payloadSignature");
        return this.payloadSignature((PendingSignature)payloadSignature.invoke());
    }

    public final void payloadSignature(@NotNull FlowAddress address, @NotNull Number keyIndex, @NotNull FlowSignature signature) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)keyIndex, (String)"keyIndex");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this.payloadSignature(new PendingSignature(null, address, keyIndex, null, signature, 9, null));
    }

    public final void payloadSignature(@NotNull FlowAddress address, @NotNull Number keyIndex, @NotNull Signer signer) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)keyIndex, (String)"keyIndex");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        this.payloadSignature(new PendingSignature(null, address, keyIndex, signer, null, 17, null));
    }

    @NotNull
    public final List<PendingSignature> getEnvelopeSignatures() {
        return this._envelopeSignatures;
    }

    public final void setEnvelopeSignatures(@NotNull List<PendingSignature> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this._envelopeSignatures.clear();
        this._envelopeSignatures.addAll((Collection<PendingSignature>)value);
    }

    public final void envelopeSignatures(@NotNull List<PendingSignature> envelopeSignatures) {
        Intrinsics.checkNotNullParameter(envelopeSignatures, (String)"envelopeSignatures");
        this.setEnvelopeSignatures(envelopeSignatures);
    }

    public final void addEnvelopeSignatures(@NotNull Function1<? super FlowTransactionSignatureCollectionBuilder, Unit> envelopeSignatures) {
        Intrinsics.checkNotNullParameter(envelopeSignatures, (String)"envelopeSignatures");
        FlowTransactionSignatureCollectionBuilder builder = new FlowTransactionSignatureCollectionBuilder();
        envelopeSignatures.invoke((Object)builder);
        this._envelopeSignatures.addAll((Collection<PendingSignature>)builder.build());
    }

    public final void envelopeSignatures(@NotNull Function1<? super FlowTransactionSignatureCollectionBuilder, Unit> envelopeSignatures) {
        Intrinsics.checkNotNullParameter(envelopeSignatures, (String)"envelopeSignatures");
        FlowTransactionSignatureCollectionBuilder builder = new FlowTransactionSignatureCollectionBuilder();
        envelopeSignatures.invoke((Object)builder);
        this.setEnvelopeSignatures(builder.build());
    }

    public final boolean envelopeSignature(@NotNull PendingSignature envelopeSignature) {
        Intrinsics.checkNotNullParameter((Object)envelopeSignature, (String)"envelopeSignature");
        return this._envelopeSignatures.add(envelopeSignature);
    }

    public final void envelopeSignature(@NotNull Function1<? super FlowTransactionSignatureBuilder, Unit> envelopeSignature) {
        Intrinsics.checkNotNullParameter(envelopeSignature, (String)"envelopeSignature");
        FlowTransactionSignatureBuilder builder = new FlowTransactionSignatureBuilder();
        envelopeSignature.invoke((Object)builder);
        this.envelopeSignature(builder.build());
    }

    public final void envelopeSignature(@NotNull FlowTransactionSignature signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this.envelopeSignature(new PendingSignature(signature, null, null, null, null, 30, null));
    }

    public final void envelopeSignature(@NotNull FlowAddress address, @NotNull Number keyIndex, @NotNull FlowSignature signature) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)keyIndex, (String)"keyIndex");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this.envelopeSignature(new PendingSignature(null, address, keyIndex, null, signature, 9, null));
    }

    public final void envelopeSignature(@NotNull FlowAddress address, @NotNull Number keyIndex, @NotNull Signer signer) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)keyIndex, (String)"keyIndex");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        this.envelopeSignature(new PendingSignature(null, address, keyIndex, signer, null, 17, null));
    }

    @NotNull
    public final FlowTransaction build() {
        FlowScript flowScript = this._script;
        if (flowScript == null) {
            boolean $i$a$-checkNotNull-TransactionBuilder$build$tx$62 = false;
            String $i$a$-checkNotNull-TransactionBuilder$build$tx$62 = "script of FlowTransaction is required";
            throw new IllegalStateException($i$a$-checkNotNull-TransactionBuilder$build$tx$62.toString());
        }
        List<FlowArgument> list = this._arguments;
        FlowId flowId = this._referenceBlockId;
        if (flowId == null) {
            List<FlowArgument> list2 = list;
            FlowScript flowScript2 = flowScript;
            boolean $i$a$-checkNotNull-TransactionBuilder$build$tx$72 = false;
            String string = "referenceBlockId of FlowTransaction is required";
            FlowScript flowScript3 = flowScript2;
            List<FlowArgument> list3 = list2;
            String $i$a$-checkNotNull-TransactionBuilder$build$tx$72 = string;
            throw new IllegalStateException($i$a$-checkNotNull-TransactionBuilder$build$tx$72.toString());
        }
        Number number = this._gasLimit;
        Long l = number != null ? Long.valueOf(number.longValue()) : null;
        if (l == null) {
            FlowId flowId2 = flowId;
            List<FlowArgument> list4 = list;
            FlowScript flowScript4 = flowScript;
            boolean $i$a$-checkNotNull-TransactionBuilder$build$tx$82 = false;
            String string = "gasLimit of FlowTransaction is required";
            FlowScript flowScript5 = flowScript4;
            List<FlowArgument> list5 = list4;
            FlowId flowId3 = flowId2;
            String $i$a$-checkNotNull-TransactionBuilder$build$tx$82 = string;
            throw new IllegalStateException($i$a$-checkNotNull-TransactionBuilder$build$tx$82.toString());
        }
        long l2 = ((Number)l).longValue();
        FlowTransactionProposalKey flowTransactionProposalKey = this._proposalKey;
        if (flowTransactionProposalKey == null) {
            long l3 = l2;
            FlowId flowId4 = flowId;
            List<FlowArgument> list6 = list;
            FlowScript flowScript6 = flowScript;
            boolean $i$a$-checkNotNull-TransactionBuilder$build$tx$92 = false;
            String string = "proposalKey of FlowTransaction is required";
            FlowScript flowScript7 = flowScript6;
            List<FlowArgument> list7 = list6;
            FlowId flowId5 = flowId4;
            long l4 = l3;
            String $i$a$-checkNotNull-TransactionBuilder$build$tx$92 = string;
            throw new IllegalStateException($i$a$-checkNotNull-TransactionBuilder$build$tx$92.toString());
        }
        FlowAddress flowAddress = this._payerAddress;
        if (flowAddress == null) {
            FlowTransactionProposalKey flowTransactionProposalKey2 = flowTransactionProposalKey;
            long l5 = l2;
            FlowId flowId6 = flowId;
            List<FlowArgument> list8 = list;
            FlowScript flowScript8 = flowScript;
            boolean $i$a$-checkNotNull-TransactionBuilder$build$tx$102 = false;
            String string = "payerAddress of FlowTransaction is required";
            FlowScript flowScript9 = flowScript8;
            List<FlowArgument> list9 = list8;
            FlowId flowId7 = flowId6;
            long l6 = l5;
            FlowTransactionProposalKey flowTransactionProposalKey3 = flowTransactionProposalKey2;
            String $i$a$-checkNotNull-TransactionBuilder$build$tx$102 = string;
            throw new IllegalStateException($i$a$-checkNotNull-TransactionBuilder$build$tx$102.toString());
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 384;
        List list10 = null;
        List list11 = null;
        List<FlowAddress> list12 = this._authorizers;
        FlowAddress flowAddress2 = flowAddress;
        FlowTransactionProposalKey flowTransactionProposalKey4 = flowTransactionProposalKey;
        long l7 = l2;
        FlowId flowId8 = flowId;
        List<FlowArgument> list13 = list;
        FlowScript flowScript10 = flowScript;
        FlowTransaction tx = new FlowTransaction(flowScript10, list13, flowId8, l7, flowTransactionProposalKey4, flowAddress2, list12, list11, list10, n, defaultConstructorMarker);
        if (!((Collection)this.getSignatures()).isEmpty() && (!((Collection)this.getPayloadSignatures()).isEmpty() || !((Collection)this.getEnvelopeSignatures()).isEmpty())) {
            Logger.getLogger(Reflection.getOrCreateKotlinClass(TransactionBuilder.class).getQualifiedName()).warning("This transaction has both signatures, and payloadSignatures/envelopeSignatures defined. It is not recommended to use these together because it his highly likely that the transaction will be invalid. Instead use either only signatures, or only payloadSignatures/envelopeSignatures when building your transaction");
        }
        if (!((Collection)this.getSignatures()).isEmpty()) {
            PendingSignature it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.getSignatures();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (PendingSignature)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getAddress(), (Object)this.getPayerAddress()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (PendingSignature pending : (List)destination$iv$iv) {
                tx = pending.applyAsPayloadSignature(tx);
            }
            $this$filter$iv = this.getSignatures();
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (PendingSignature)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getAddress(), (Object)this.getPayerAddress())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (PendingSignature pending : (List)destination$iv$iv) {
                tx = pending.applyAsEnvelopeSignature(tx);
            }
        }
        if (!((Collection)this.getPayloadSignatures()).isEmpty() || !((Collection)this.getEnvelopeSignatures()).isEmpty()) {
            for (PendingSignature pending : this.getPayloadSignatures()) {
                tx = pending.applyAsPayloadSignature(tx);
            }
            for (PendingSignature pending : this.getEnvelopeSignatures()) {
                tx = pending.applyAsEnvelopeSignature(tx);
            }
        }
        return tx;
    }

    public TransactionBuilder() {
        this(null, 1, null);
    }
}

