/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk.crypto;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.KeySpec;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.jetbrains.annotations.NotNull;
import org.onflow.flow.sdk.ExtensionsKt;
import org.onflow.flow.sdk.HashAlgorithm;
import org.onflow.flow.sdk.Hasher;
import org.onflow.flow.sdk.SignatureAlgorithm;
import org.onflow.flow.sdk.Signer;
import org.onflow.flow.sdk.crypto.HasherImpl;
import org.onflow.flow.sdk.crypto.KeyPair;
import org.onflow.flow.sdk.crypto.PrivateKey;
import org.onflow.flow.sdk.crypto.PublicKey;
import org.onflow.flow.sdk.crypto.SignerImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007\u00a8\u0006\u001c"}, d2={"Lorg/onflow/flow/sdk/crypto/Crypto;", "", "()V", "decodePrivateKey", "Lorg/onflow/flow/sdk/crypto/PrivateKey;", "key", "", "algo", "Lorg/onflow/flow/sdk/SignatureAlgorithm;", "decodePublicKey", "Lorg/onflow/flow/sdk/crypto/PublicKey;", "extractRS", "Lkotlin/Pair;", "Ljava/math/BigInteger;", "signature", "", "generateKeyPair", "Lorg/onflow/flow/sdk/crypto/KeyPair;", "getHasher", "Lorg/onflow/flow/sdk/Hasher;", "hashAlgo", "Lorg/onflow/flow/sdk/HashAlgorithm;", "getSigner", "Lorg/onflow/flow/sdk/Signer;", "privateKey", "normalizeSignature", "ecCoupleComponentSize", "", "flow-jvm-sdk"})
public final class Crypto {
    @NotNull
    public static final Crypto INSTANCE = new Crypto();

    private Crypto() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KeyPair generateKeyPair(@NotNull SignatureAlgorithm algo) {
        Intrinsics.checkNotNullParameter((Object)((Object)algo), (String)"algo");
        KeyPairGenerator generator = KeyPairGenerator.getInstance("EC", "BC");
        generator.initialize(new ECGenParameterSpec(algo.getCurve()), new SecureRandom());
        java.security.KeyPair keyPair = generator.generateKeyPair();
        java.security.PrivateKey privateKey = keyPair.getPrivate();
        java.security.PublicKey publicKey = keyPair.getPublic();
        java.security.PrivateKey privateKey2 = keyPair.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey2, (String)"getPrivate(...)");
        int n = privateKey instanceof ECPrivateKey ? ((ECPrivateKey)privateKey).getParameters().getN().bitLength() / 8 : 0;
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new IllegalArgumentException("PrivateKey must be an ECPublicKey");
        }
        byte[] byArray = ((ECPrivateKey)privateKey).getD().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        PrivateKey privateKey3 = new PrivateKey(privateKey2, n, ExtensionsKt.bytesToHex(byArray));
        Intrinsics.checkNotNull((Object)publicKey);
        if (!(publicKey instanceof ECPublicKey)) {
            throw new IllegalArgumentException("PublicKey must be an ECPublicKey");
        }
        byte[] byArray2 = ((ECPublicKey)publicKey).getQ().getXCoord().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoded(...)");
        byte[] byArray3 = ((ECPublicKey)publicKey).getQ().getYCoord().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getEncoded(...)");
        return new KeyPair(privateKey3, new PublicKey(publicKey, ExtensionsKt.bytesToHex(ArraysKt.plus((byte[])byArray2, (byte[])byArray3))));
    }

    public static /* synthetic */ KeyPair generateKeyPair$default(SignatureAlgorithm signatureAlgorithm, int n, Object object) {
        if ((n & 1) != 0) {
            signatureAlgorithm = SignatureAlgorithm.ECDSA_P256;
        }
        return Crypto.generateKeyPair(signatureAlgorithm);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PrivateKey decodePrivateKey(@NotNull String key, @NotNull SignatureAlgorithm algo) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)algo), (String)"algo");
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)algo.getCurve());
        KeyFactory keyFactory = KeyFactory.getInstance(algo.getAlgorithm(), "BC");
        ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(new BigInteger(key, 16), (org.bouncycastle.jce.spec.ECParameterSpec)ecParameterSpec);
        java.security.PrivateKey pk = keyFactory.generatePrivate((KeySpec)ecPrivateKeySpec);
        Intrinsics.checkNotNull((Object)pk);
        int n = pk instanceof ECPrivateKey ? ((ECPrivateKey)pk).getParameters().getN().bitLength() / 8 : 0;
        if (!(pk instanceof ECPrivateKey)) {
            throw new IllegalArgumentException("PrivateKey must be an ECPublicKey");
        }
        byte[] byArray = ((ECPrivateKey)pk).getD().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return new PrivateKey(pk, n, ExtensionsKt.bytesToHex(byArray));
    }

    public static /* synthetic */ PrivateKey decodePrivateKey$default(String string, SignatureAlgorithm signatureAlgorithm, int n, Object object) {
        if ((n & 2) != 0) {
            signatureAlgorithm = SignatureAlgorithm.ECDSA_P256;
        }
        return Crypto.decodePrivateKey(string, signatureAlgorithm);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PublicKey decodePublicKey(@NotNull String key, @NotNull SignatureAlgorithm algo) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)algo), (String)"algo");
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)algo.getCurve());
        KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
        ECNamedCurveSpec params = new ECNamedCurveSpec(algo.getCurve(), ecParameterSpec.getCurve(), ecParameterSpec.getG(), ecParameterSpec.getN());
        byte[] byArray = new byte[]{4};
        ECPoint point = ECPointUtil.decodePoint((EllipticCurve)params.getCurve(), (byte[])ArraysKt.plus((byte[])byArray, (byte[])ExtensionsKt.hexToBytes(key)));
        ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(point, (ECParameterSpec)params);
        java.security.PublicKey publicKey = keyFactory.generatePublic(pubKeySpec);
        Intrinsics.checkNotNull((Object)publicKey);
        if (!(publicKey instanceof ECPublicKey)) {
            throw new IllegalArgumentException("PublicKey must be an ECPublicKey");
        }
        byte[] byArray2 = ((ECPublicKey)publicKey).getQ().getXCoord().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoded(...)");
        byte[] byArray3 = ((ECPublicKey)publicKey).getQ().getYCoord().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getEncoded(...)");
        return new PublicKey(publicKey, ExtensionsKt.bytesToHex(ArraysKt.plus((byte[])byArray2, (byte[])byArray3)));
    }

    public static /* synthetic */ PublicKey decodePublicKey$default(String string, SignatureAlgorithm signatureAlgorithm, int n, Object object) {
        if ((n & 2) != 0) {
            signatureAlgorithm = SignatureAlgorithm.ECDSA_P256;
        }
        return Crypto.decodePublicKey(string, signatureAlgorithm);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Signer getSigner(@NotNull PrivateKey privateKey, @NotNull HashAlgorithm hashAlgo) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgo), (String)"hashAlgo");
        return new SignerImpl(privateKey, hashAlgo, null, 4, null);
    }

    public static /* synthetic */ Signer getSigner$default(PrivateKey privateKey, HashAlgorithm hashAlgorithm, int n, Object object) {
        if ((n & 2) != 0) {
            hashAlgorithm = HashAlgorithm.SHA3_256;
        }
        return Crypto.getSigner(privateKey, hashAlgorithm);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Hasher getHasher(@NotNull HashAlgorithm hashAlgo) {
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgo), (String)"hashAlgo");
        return new HasherImpl(hashAlgo);
    }

    public static /* synthetic */ Hasher getHasher$default(HashAlgorithm hashAlgorithm, int n, Object object) {
        if ((n & 1) != 0) {
            hashAlgorithm = HashAlgorithm.SHA3_256;
        }
        return Crypto.getHasher(hashAlgorithm);
    }

    @JvmStatic
    @NotNull
    public static final byte[] normalizeSignature(@NotNull byte[] signature, int ecCoupleComponentSize) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Pair<BigInteger, BigInteger> pair = Crypto.extractRS(signature);
        BigInteger r = (BigInteger)pair.component1();
        BigInteger s = (BigInteger)pair.component2();
        byte[] paddedSignature = new byte[2 * ecCoupleComponentSize];
        byte[] rBytes = r.toByteArray();
        byte[] sBytes = s.toByteArray();
        Intrinsics.checkNotNull((Object)rBytes);
        ArraysKt.copyInto$default((byte[])rBytes, (byte[])paddedSignature, (int)Math.max(ecCoupleComponentSize - rBytes.length, 0), (int)Math.max(0, rBytes.length - ecCoupleComponentSize), (int)0, (int)8, null);
        Intrinsics.checkNotNull((Object)sBytes);
        ArraysKt.copyInto$default((byte[])sBytes, (byte[])paddedSignature, (int)Math.max(2 * ecCoupleComponentSize - sBytes.length, ecCoupleComponentSize), (int)Math.max(0, sBytes.length - ecCoupleComponentSize), (int)0, (int)8, null);
        return paddedSignature;
    }

    @JvmStatic
    @NotNull
    public static final Pair<BigInteger, BigInteger> extractRS(@NotNull byte[] signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        int startR = (byte)(signature[1] & 0xFFFFFF80) != 0 ? 3 : 2;
        byte lengthR = signature[startR + 1];
        int startS = startR + 2 + lengthR;
        byte lengthS = signature[startS + 1];
        byte[] byArray = signature;
        int n = startR + 2;
        int n2 = startR + 2 + lengthR;
        BigInteger bigInteger = new BigInteger(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2));
        byArray = signature;
        n = startS + 2;
        n2 = startS + 2 + lengthS;
        return new Pair((Object)bigInteger, (Object)new BigInteger(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2)));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KeyPair generateKeyPair() {
        return Crypto.generateKeyPair$default(null, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PrivateKey decodePrivateKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Crypto.decodePrivateKey$default(key, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PublicKey decodePublicKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Crypto.decodePublicKey$default(key, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Signer getSigner(@NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        return Crypto.getSigner$default(privateKey, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Hasher getHasher() {
        return Crypto.getHasher$default(null, 1, null);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

