/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk.crypto;

import java.security.Signature;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.onflow.flow.sdk.HashAlgorithm;
import org.onflow.flow.sdk.Hasher;
import org.onflow.flow.sdk.Signer;
import org.onflow.flow.sdk.crypto.Crypto;
import org.onflow.flow.sdk.crypto.HasherImpl;
import org.onflow.flow.sdk.crypto.PrivateKey;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/onflow/flow/sdk/crypto/SignerImpl;", "Lorg/onflow/flow/sdk/Signer;", "privateKey", "Lorg/onflow/flow/sdk/crypto/PrivateKey;", "hashAlgo", "Lorg/onflow/flow/sdk/HashAlgorithm;", "hasher", "Lorg/onflow/flow/sdk/Hasher;", "(Lorg/onflow/flow/sdk/crypto/PrivateKey;Lorg/onflow/flow/sdk/HashAlgorithm;Lorg/onflow/flow/sdk/Hasher;)V", "getHasher", "()Lorg/onflow/flow/sdk/Hasher;", "sign", "", "bytes", "flow-jvm-sdk"})
public final class SignerImpl
implements Signer {
    @NotNull
    private final PrivateKey privateKey;
    @NotNull
    private final HashAlgorithm hashAlgo;
    @NotNull
    private final Hasher hasher;

    public SignerImpl(@NotNull PrivateKey privateKey, @NotNull HashAlgorithm hashAlgo, @NotNull Hasher hasher) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgo), (String)"hashAlgo");
        Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
        this.privateKey = privateKey;
        this.hashAlgo = hashAlgo;
        this.hasher = hasher;
    }

    public /* synthetic */ SignerImpl(PrivateKey privateKey, HashAlgorithm hashAlgorithm, Hasher hasher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            hasher = new HasherImpl(hashAlgorithm);
        }
        this(privateKey, hashAlgorithm, hasher);
    }

    @Override
    @NotNull
    public Hasher getHasher() {
        return this.hasher;
    }

    @Override
    @NotNull
    public byte[] sign(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Signature ecdsaSign = Signature.getInstance(this.hashAlgo.getId());
        ecdsaSign.initSign(this.privateKey.getKey());
        ecdsaSign.update(bytes);
        byte[] signature = ecdsaSign.sign();
        if (this.privateKey.getEcCoupleComponentSize() <= 0) {
            Intrinsics.checkNotNull((Object)signature);
            return signature;
        }
        Intrinsics.checkNotNull((Object)signature);
        return Crypto.normalizeSignature(signature, this.privateKey.getEcCoupleComponentSize());
    }

    @Override
    @NotNull
    public byte[] signWithDomain(@NotNull byte[] bytes, @NotNull byte[] domain) {
        return Signer.DefaultImpls.signWithDomain(this, bytes, domain);
    }

    @Override
    @NotNull
    public byte[] signAsUser(@NotNull byte[] bytes) {
        return Signer.DefaultImpls.signAsUser(this, bytes);
    }

    @Override
    @NotNull
    public byte[] signAsTransaction(@NotNull byte[] bytes) {
        return Signer.DefaultImpls.signAsTransaction(this, bytes);
    }
}

