/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.onflow.flow.sdk.AddressRegistry;
import org.onflow.flow.sdk.Flow;
import org.onflow.flow.sdk.FlowAddress;
import org.onflow.flow.sdk.FlowChainId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010$\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0005H\u0007J\u0006\u0010\u0010\u001a\u00020\u0000J\u001c\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0007J0\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u00052\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0015H\u0007J\"\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00072\b\b\u0002\u0010\u000f\u001a\u00020\u0005H\u0007J\u0006\u0010\u0018\u001a\u00020\u0000R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/onflow/flow/sdk/AddressRegistry;", "", "()V", "SCRIPT_TOKEN_MAP", "", "Lorg/onflow/flow/sdk/FlowChainId;", "", "Lorg/onflow/flow/sdk/FlowAddress;", "defaultChainId", "getDefaultChainId", "()Lorg/onflow/flow/sdk/FlowChainId;", "setDefaultChainId", "(Lorg/onflow/flow/sdk/FlowChainId;)V", "addressOf", "contract", "chainId", "clear", "deregister", "processScript", "script", "addresses", "", "register", "address", "registerDefaults", "Companion", "sdk"})
@SourceDebugExtension(value={"SMAP\nAddressRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddressRegistry.kt\norg/onflow/flow/sdk/AddressRegistry\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,101:1\n215#2,2:102\n215#2,2:104\n215#2:110\n215#2,2:111\n216#2:113\n37#3,2:106\n13309#4,2:108\n*S KotlinDebug\n*F\n+ 1 AddressRegistry.kt\norg/onflow/flow/sdk/AddressRegistry\n*L\n31#1:102,2\n34#1:104,2\n93#1:110\n94#1:111,2\n93#1:113\n54#1:106,2\n56#1:108,2\n*E\n"})
public final class AddressRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<FlowChainId, Map<String, FlowAddress>> SCRIPT_TOKEN_MAP = new LinkedHashMap();
    @NotNull
    private FlowChainId defaultChainId = Flow.INSTANCE.getDEFAULT_CHAIN_ID();
    @NotNull
    public static final String FUNGIBLE_TOKEN = "0xFUNGIBLETOKEN";
    @NotNull
    public static final String FLOW_TOKEN = "0xFLOWTOKEN";
    @NotNull
    public static final String FLOW_FEES = "0xFLOWFEES";
    @NotNull
    public static final String FLOW_TABLE_STAKING = "0xFLOWTABLESTAKING";
    @NotNull
    public static final String LOCKED_TOKENS = "0xLOCKEDTOKENS";
    @NotNull
    public static final String STAKING_PROXY = "0xSTAKINGPROXY";
    @NotNull
    public static final String NON_FUNGIBLE_TOKEN = "0xNONFUNGIBLETOKEN";
    @NotNull
    public static final String NFT_STOREFRONT = "0xNFTSTOREFRONT";
    @NotNull
    public static final String TOKEN_FORWARDING = "0xTOKENFORWARDING";

    public AddressRegistry() {
        this.registerDefaults();
    }

    @NotNull
    public final FlowChainId getDefaultChainId() {
        return this.defaultChainId;
    }

    public final void setDefaultChainId(@NotNull FlowChainId flowChainId) {
        Intrinsics.checkNotNullParameter((Object)((Object)flowChainId), (String)"<set-?>");
        this.defaultChainId = flowChainId;
    }

    @JvmOverloads
    @NotNull
    public final String processScript(@NotNull String script, @NotNull FlowChainId chainId, @NotNull Map<String, FlowAddress> addresses) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)((Object)chainId), (String)"chainId");
        Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
        String ret = null;
        ret = script;
        Map<String, FlowAddress> map = this.SCRIPT_TOKEN_MAP.get((Object)chainId);
        if (map != null) {
            Map<String, FlowAddress> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, FlowAddress>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, FlowAddress> element$iv;
                Map.Entry<String, FlowAddress> it = element$iv = iterator.next();
                boolean bl = false;
                ret = StringsKt.replace$default((String)ret, (String)it.getKey(), (String)it.getValue().getFormatted(), (boolean)false, (int)4, null);
            }
        }
        Map<String, FlowAddress> $this$forEach$iv = addresses;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, FlowAddress>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, FlowAddress> element$iv;
            Map.Entry<String, FlowAddress> it = element$iv = iterator.next();
            boolean bl = false;
            ret = StringsKt.replace$default((String)ret, (String)it.getKey(), (String)it.getValue().getFormatted(), (boolean)false, (int)4, null);
        }
        return ret;
    }

    public static /* synthetic */ String processScript$default(AddressRegistry addressRegistry, String string, FlowChainId flowChainId, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            flowChainId = addressRegistry.defaultChainId;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return addressRegistry.processScript(string, flowChainId, map);
    }

    @JvmOverloads
    @Nullable
    public final FlowAddress addressOf(@NotNull String contract, @NotNull FlowChainId chainId) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        Intrinsics.checkNotNullParameter((Object)((Object)chainId), (String)"chainId");
        Map<String, FlowAddress> map = this.SCRIPT_TOKEN_MAP.get((Object)chainId);
        return map != null ? map.get(contract) : null;
    }

    public static /* synthetic */ FlowAddress addressOf$default(AddressRegistry addressRegistry, String string, FlowChainId flowChainId, int n, Object object) {
        if ((n & 2) != 0) {
            flowChainId = addressRegistry.defaultChainId;
        }
        return addressRegistry.addressOf(string, flowChainId);
    }

    @JvmOverloads
    @NotNull
    public final AddressRegistry register(@NotNull String contract, @NotNull FlowAddress address, @NotNull FlowChainId chainId) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)((Object)chainId), (String)"chainId");
        Map map = this.SCRIPT_TOKEN_MAP.computeIfAbsent(chainId, arg_0 -> AddressRegistry.register$lambda$2(register.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"computeIfAbsent(...)");
        map.put(contract, address);
        return this;
    }

    public static /* synthetic */ AddressRegistry register$default(AddressRegistry addressRegistry, String string, FlowAddress flowAddress, FlowChainId flowChainId, int n, Object object) {
        if ((n & 4) != 0) {
            flowChainId = addressRegistry.defaultChainId;
        }
        return addressRegistry.register(string, flowAddress, flowChainId);
    }

    @JvmOverloads
    @NotNull
    public final AddressRegistry deregister(@NotNull String contract, @Nullable FlowChainId chainId) {
        FlowChainId[] chains;
        FlowChainId[] flowChainIdArray;
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        if (chainId != null) {
            FlowChainId[] flowChainIdArray2 = new FlowChainId[]{chainId};
            flowChainIdArray = flowChainIdArray2;
        } else {
            Collection $this$toTypedArray$iv = (Collection)FlowChainId.getEntries();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            flowChainIdArray = thisCollection$iv.toArray(new FlowChainId[0]);
        }
        FlowChainId[] $this$forEach$iv = chains = flowChainIdArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            FlowChainId element$iv;
            FlowChainId it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Map<String, FlowAddress> map = this.SCRIPT_TOKEN_MAP.get((Object)it);
            if (map == null) continue;
            map.remove(contract);
        }
        return this;
    }

    public static /* synthetic */ AddressRegistry deregister$default(AddressRegistry addressRegistry, String string, FlowChainId flowChainId, int n, Object object) {
        if ((n & 2) != 0) {
            flowChainId = null;
        }
        return addressRegistry.deregister(string, flowChainId);
    }

    @NotNull
    public final AddressRegistry clear() {
        this.SCRIPT_TOKEN_MAP.clear();
        return this;
    }

    @NotNull
    public final AddressRegistry registerDefaults() {
        Pair[] pairArray = new Pair[3];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)FUNGIBLE_TOKEN, (Object)new FlowAddress("0xee82856bf20e2aa6")), TuplesKt.to((Object)FLOW_TOKEN, (Object)new FlowAddress("0x0ae53cb6e3f42a79")), TuplesKt.to((Object)FLOW_FEES, (Object)new FlowAddress("0xe5a8b7f23e8b548f"))};
        pairArray[0] = TuplesKt.to((Object)((Object)FlowChainId.EMULATOR), (Object)MapsKt.mutableMapOf((Pair[])pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to((Object)FUNGIBLE_TOKEN, (Object)new FlowAddress("0x9a0766d93b6608b7")), TuplesKt.to((Object)FLOW_TOKEN, (Object)new FlowAddress("0x7e60df042a9c0868")), TuplesKt.to((Object)FLOW_FEES, (Object)new FlowAddress("0x912d5440f7e3769e")), TuplesKt.to((Object)FLOW_TABLE_STAKING, (Object)new FlowAddress("0x9eca2b38b18b5dfe")), TuplesKt.to((Object)LOCKED_TOKENS, (Object)new FlowAddress("0x95e019a17d0e23d7")), TuplesKt.to((Object)STAKING_PROXY, (Object)new FlowAddress("0x7aad92e5a0715d21")), TuplesKt.to((Object)NON_FUNGIBLE_TOKEN, (Object)new FlowAddress("0x631e88ae7f1d7c20")), TuplesKt.to((Object)NFT_STOREFRONT, (Object)new FlowAddress("0x94b06cfca1d8a476"))};
        pairArray[1] = TuplesKt.to((Object)((Object)FlowChainId.TESTNET), (Object)MapsKt.mutableMapOf((Pair[])pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to((Object)FUNGIBLE_TOKEN, (Object)new FlowAddress("0xf233dcee88fe0abe")), TuplesKt.to((Object)FLOW_TOKEN, (Object)new FlowAddress("0x1654653399040a61")), TuplesKt.to((Object)FLOW_FEES, (Object)new FlowAddress("0xf919ee77447b7497")), TuplesKt.to((Object)FLOW_TABLE_STAKING, (Object)new FlowAddress("0x8624b52f9ddcd04a")), TuplesKt.to((Object)LOCKED_TOKENS, (Object)new FlowAddress("0x8d0e87b65159ae63")), TuplesKt.to((Object)STAKING_PROXY, (Object)new FlowAddress("0x62430cf28c26d095")), TuplesKt.to((Object)NON_FUNGIBLE_TOKEN, (Object)new FlowAddress("0x1d7e57aa55817448")), TuplesKt.to((Object)NFT_STOREFRONT, (Object)new FlowAddress("0x4eb8a10cb9f87357")), TuplesKt.to((Object)TOKEN_FORWARDING, (Object)new FlowAddress("0xe544175ee0461c4b"))};
        pairArray[2] = TuplesKt.to((Object)((Object)FlowChainId.MAINNET), (Object)MapsKt.mutableMapOf((Pair[])pairArray2));
        Map $this$forEach$iv = MapsKt.mapOf((Pair[])pairArray);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry chain = element$iv = iterator.next();
            boolean bl = false;
            Map $this$forEach$iv2 = (Map)chain.getValue();
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry it = element$iv2 = iterator2.next();
                boolean bl2 = false;
                this.register((String)it.getKey(), (FlowAddress)it.getValue(), (FlowChainId)((Object)chain.getKey()));
            }
        }
        return this;
    }

    @JvmOverloads
    @NotNull
    public final String processScript(@NotNull String script, @NotNull FlowChainId chainId) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)((Object)chainId), (String)"chainId");
        return AddressRegistry.processScript$default(this, script, chainId, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final String processScript(@NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return AddressRegistry.processScript$default(this, script, null, null, 6, null);
    }

    @JvmOverloads
    @Nullable
    public final FlowAddress addressOf(@NotNull String contract) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        return AddressRegistry.addressOf$default(this, contract, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final AddressRegistry register(@NotNull String contract, @NotNull FlowAddress address) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return AddressRegistry.register$default(this, contract, address, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final AddressRegistry deregister(@NotNull String contract) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        return AddressRegistry.deregister$default(this, contract, null, 2, null);
    }

    private static final Map register$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/onflow/flow/sdk/AddressRegistry$Companion;", "", "()V", "FLOW_FEES", "", "FLOW_TABLE_STAKING", "FLOW_TOKEN", "FUNGIBLE_TOKEN", "LOCKED_TOKENS", "NFT_STOREFRONT", "NON_FUNGIBLE_TOKEN", "STAKING_PROXY", "TOKEN_FORWARDING", "sdk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

