/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk;

import com.google.common.io.BaseEncoding;
import com.google.protobuf.Timestamp;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0007*\u00020\u0006\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0001\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\n\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0001\u00a8\u0006\u000e"}, d2={"fixedSize", "", "bytes", "size", "", "asLocalDateTime", "Ljava/time/LocalDateTime;", "Lcom/google/protobuf/Timestamp;", "asTimestamp", "bytesToHex", "", "hexToBytes", "sha2256Hash", "sha3256Hash", "sdk"})
public final class ExtensionsKt {
    @NotNull
    public static final String bytesToHex(@NotNull byte[] $this$bytesToHex) {
        Intrinsics.checkNotNullParameter((Object)$this$bytesToHex, (String)"<this>");
        String string = BaseEncoding.base16().lowerCase().encode($this$bytesToHex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        return string;
    }

    @NotNull
    public static final byte[] hexToBytes(@NotNull String $this$hexToBytes) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$hexToBytes, (String)"<this>");
        BaseEncoding baseEncoding = BaseEncoding.base16().lowerCase();
        String string2 = $this$hexToBytes.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (StringsKt.startsWith$default((String)string2, (String)"0x", (boolean)false, (int)2, null)) {
            String string3 = $this$hexToBytes.substring(2);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = $this$hexToBytes;
        }
        byte[] byArray = baseEncoding.decode((CharSequence)string);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        return byArray;
    }

    @NotNull
    public static final LocalDateTime asLocalDateTime(@NotNull Timestamp $this$asLocalDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$asLocalDateTime, (String)"<this>");
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond($this$asLocalDateTime.getSeconds(), $this$asLocalDateTime.getNanos(), ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofEpochSecond(...)");
        return localDateTime;
    }

    @NotNull
    public static final Timestamp asTimestamp(@NotNull LocalDateTime $this$asTimestamp) {
        Intrinsics.checkNotNullParameter((Object)$this$asTimestamp, (String)"<this>");
        Timestamp timestamp = Timestamp.newBuilder().setSeconds($this$asTimestamp.toEpochSecond(ZoneOffset.UTC)).setNanos($this$asTimestamp.getNano()).build();
        Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"build(...)");
        return timestamp;
    }

    @NotNull
    public static final byte[] sha3256Hash(@NotNull byte[] $this$sha3256Hash) {
        Intrinsics.checkNotNullParameter((Object)$this$sha3256Hash, (String)"<this>");
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] byArray = MessageDigest.getInstance("SHA3-256", "BC").digest($this$sha3256Hash);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    @NotNull
    public static final byte[] sha2256Hash(@NotNull byte[] $this$sha2256Hash) {
        Intrinsics.checkNotNullParameter((Object)$this$sha2256Hash, (String)"<this>");
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] byArray = MessageDigest.getInstance("SHA2-256", "BC").digest($this$sha2256Hash);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    @NotNull
    public static final byte[] fixedSize(@NotNull byte[] bytes, int size) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (bytes.length > size) {
            throw new IllegalArgumentException("must have no more than " + size + " bytes long");
        }
        return bytes.length < size ? ArraysKt.plus((byte[])new byte[size - bytes.length], (byte[])bytes) : bytes;
    }
}

