/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk;

import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.onflow.flow.sdk.EnvelopeSignature;
import org.onflow.flow.sdk.ExtensionsKt;
import org.onflow.flow.sdk.FlowAddress;
import org.onflow.flow.sdk.FlowArgument;
import org.onflow.flow.sdk.FlowId;
import org.onflow.flow.sdk.FlowScript;
import org.onflow.flow.sdk.FlowSignature;
import org.onflow.flow.sdk.FlowTransactionProposalKey;
import org.onflow.flow.sdk.FlowTransactionSignature;
import org.onflow.flow.sdk.Payload;
import org.onflow.flow.sdk.PayloadEnvelope;
import org.onflow.flow.sdk.PaymentEnvelope;
import org.onflow.flow.sdk.Signer;
import org.onflow.flow.sdk.TransactionEnvelope;
import org.onflow.protobuf.entities.TransactionOuterClass;
import org.tdf.rlp.RLPCodec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 b2\u00020\u0001:\u0001bBi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u0012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005\u0012\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u000e2\u0006\u0010H\u001a\u00020?2\u0006\u0010I\u001a\u00020JJ\u001e\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u000e2\u0006\u0010H\u001a\u00020?2\u0006\u0010K\u001a\u00020LJ\u001e\u0010M\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u000e2\u0006\u0010H\u001a\u00020?2\u0006\u0010I\u001a\u00020JJ\u001e\u0010M\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u000e2\u0006\u0010H\u001a\u00020?2\u0006\u0010K\u001a\u00020LJ\u0012\u0010N\u001a\u00020O2\b\b\u0002\u0010N\u001a\u00020OH\u0007J\t\u0010P\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010R\u001a\u00020\bH\u00c6\u0003J\t\u0010S\u001a\u00020\nH\u00c6\u0003J\t\u0010T\u001a\u00020\fH\u00c6\u0003J\t\u0010U\u001a\u00020\u000eH\u00c6\u0003J\u000f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005H\u00c6\u0003J\u000f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005H\u00c6\u0003J\u000f\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005H\u00c6\u0003J{\u0010Y\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00052\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005H\u00c6\u0001J\u0013\u0010Z\u001a\u00020[2\b\u0010\\\u001a\u0004\u0018\u00010]H\u00d6\u0003J\t\u0010^\u001a\u00020?H\u00d6\u0001J\t\u0010_\u001a\u00020`H\u00d6\u0001J\u0006\u0010a\u001a\u00020\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0011\u0010!\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001eR\u0011\u0010#\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001eR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0015R\u0014\u00102\u001a\u0002038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0017\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00058F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0015R\u001d\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020?0>8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0014\u0010B\u001a\u00020C8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010E\u00a8\u0006c"}, d2={"Lorg/onflow/flow/sdk/FlowTransaction;", "Ljava/io/Serializable;", "script", "Lorg/onflow/flow/sdk/FlowScript;", "arguments", "", "Lorg/onflow/flow/sdk/FlowArgument;", "referenceBlockId", "Lorg/onflow/flow/sdk/FlowId;", "gasLimit", "", "proposalKey", "Lorg/onflow/flow/sdk/FlowTransactionProposalKey;", "payerAddress", "Lorg/onflow/flow/sdk/FlowAddress;", "authorizers", "payloadSignatures", "Lorg/onflow/flow/sdk/FlowTransactionSignature;", "envelopeSignatures", "(Lorg/onflow/flow/sdk/FlowScript;Ljava/util/List;Lorg/onflow/flow/sdk/FlowId;JLorg/onflow/flow/sdk/FlowTransactionProposalKey;Lorg/onflow/flow/sdk/FlowAddress;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getArguments", "()Ljava/util/List;", "authorization", "Lorg/onflow/flow/sdk/PayloadEnvelope;", "getAuthorization", "()Lorg/onflow/flow/sdk/PayloadEnvelope;", "getAuthorizers", "canonicalAuthorizationEnvelope", "", "getCanonicalAuthorizationEnvelope", "()[B", "canonicalPayload", "getCanonicalPayload", "canonicalPaymentEnvelope", "getCanonicalPaymentEnvelope", "canonicalTransaction", "getCanonicalTransaction", "getEnvelopeSignatures", "getGasLimit", "()J", "id", "getId", "()Lorg/onflow/flow/sdk/FlowId;", "getPayerAddress", "()Lorg/onflow/flow/sdk/FlowAddress;", "payload", "Lorg/onflow/flow/sdk/Payload;", "getPayload", "()Lorg/onflow/flow/sdk/Payload;", "getPayloadSignatures", "payment", "Lorg/onflow/flow/sdk/PaymentEnvelope;", "getPayment", "()Lorg/onflow/flow/sdk/PaymentEnvelope;", "getProposalKey", "()Lorg/onflow/flow/sdk/FlowTransactionProposalKey;", "getReferenceBlockId", "getScript", "()Lorg/onflow/flow/sdk/FlowScript;", "signerList", "getSignerList", "signerMap", "", "", "getSignerMap", "()Ljava/util/Map;", "transaction", "Lorg/onflow/flow/sdk/TransactionEnvelope;", "getTransaction", "()Lorg/onflow/flow/sdk/TransactionEnvelope;", "addEnvelopeSignature", "address", "keyIndex", "signature", "Lorg/onflow/flow/sdk/FlowSignature;", "signer", "Lorg/onflow/flow/sdk/Signer;", "addPayloadSignature", "builder", "Lorg/onflow/protobuf/entities/TransactionOuterClass$Transaction$Builder;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "", "hashCode", "toString", "", "updateSignerIndices", "Companion", "sdk"})
@SourceDebugExtension(value={"SMAP\nmodels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 models.kt\norg/onflow/flow/sdk/FlowTransaction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1182:1\n1549#2:1183\n1620#2,3:1184\n1549#2:1187\n1620#2,3:1188\n1549#2:1191\n1620#2,3:1192\n1549#2:1195\n1620#2,3:1196\n1549#2:1199\n1620#2,3:1200\n1549#2:1203\n1620#2,3:1204\n1855#2,2:1207\n1549#2:1209\n1620#2,3:1210\n1549#2:1213\n1620#2,3:1214\n1549#2:1217\n1620#2,3:1218\n1549#2:1221\n1620#2,3:1222\n1549#2:1225\n1620#2,3:1226\n*S KotlinDebug\n*F\n+ 1 models.kt\norg/onflow/flow/sdk/FlowTransaction\n*L\n361#1:1183\n361#1:1184,3\n368#1:1187\n368#1:1188,3\n374#1:1191\n374#1:1192,3\n386#1:1195\n386#1:1196,3\n398#1:1199\n398#1:1200,3\n405#1:1203\n405#1:1204,3\n433#1:1207,2\n440#1:1209\n440#1:1210,3\n486#1:1213\n486#1:1214,3\n491#1:1217\n491#1:1218,3\n492#1:1221\n492#1:1222,3\n493#1:1225\n493#1:1226,3\n*E\n"})
public final class FlowTransaction
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FlowScript script;
    @NotNull
    private final List<FlowArgument> arguments;
    @NotNull
    private final FlowId referenceBlockId;
    private final long gasLimit;
    @NotNull
    private final FlowTransactionProposalKey proposalKey;
    @NotNull
    private final FlowAddress payerAddress;
    @NotNull
    private final List<FlowAddress> authorizers;
    @NotNull
    private final List<FlowTransactionSignature> payloadSignatures;
    @NotNull
    private final List<FlowTransactionSignature> envelopeSignatures;

    public FlowTransaction(@NotNull FlowScript script, @NotNull List<FlowArgument> arguments, @NotNull FlowId referenceBlockId, long gasLimit, @NotNull FlowTransactionProposalKey proposalKey, @NotNull FlowAddress payerAddress, @NotNull List<FlowAddress> authorizers, @NotNull List<FlowTransactionSignature> payloadSignatures, @NotNull List<FlowTransactionSignature> envelopeSignatures) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)referenceBlockId, (String)"referenceBlockId");
        Intrinsics.checkNotNullParameter((Object)proposalKey, (String)"proposalKey");
        Intrinsics.checkNotNullParameter((Object)payerAddress, (String)"payerAddress");
        Intrinsics.checkNotNullParameter(authorizers, (String)"authorizers");
        Intrinsics.checkNotNullParameter(payloadSignatures, (String)"payloadSignatures");
        Intrinsics.checkNotNullParameter(envelopeSignatures, (String)"envelopeSignatures");
        this.script = script;
        this.arguments = arguments;
        this.referenceBlockId = referenceBlockId;
        this.gasLimit = gasLimit;
        this.proposalKey = proposalKey;
        this.payerAddress = payerAddress;
        this.authorizers = authorizers;
        this.payloadSignatures = payloadSignatures;
        this.envelopeSignatures = envelopeSignatures;
    }

    public /* synthetic */ FlowTransaction(FlowScript flowScript, List list, FlowId flowId, long l, FlowTransactionProposalKey flowTransactionProposalKey, FlowAddress flowAddress, List list2, List list3, List list4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x100) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        this(flowScript, list, flowId, l, flowTransactionProposalKey, flowAddress, list2, list3, list4);
    }

    @NotNull
    public final FlowScript getScript() {
        return this.script;
    }

    @NotNull
    public final List<FlowArgument> getArguments() {
        return this.arguments;
    }

    @NotNull
    public final FlowId getReferenceBlockId() {
        return this.referenceBlockId;
    }

    public final long getGasLimit() {
        return this.gasLimit;
    }

    @NotNull
    public final FlowTransactionProposalKey getProposalKey() {
        return this.proposalKey;
    }

    @NotNull
    public final FlowAddress getPayerAddress() {
        return this.payerAddress;
    }

    @NotNull
    public final List<FlowAddress> getAuthorizers() {
        return this.authorizers;
    }

    @NotNull
    public final List<FlowTransactionSignature> getPayloadSignatures() {
        return this.payloadSignatures;
    }

    @NotNull
    public final List<FlowTransactionSignature> getEnvelopeSignatures() {
        return this.envelopeSignatures;
    }

    private final Payload getPayload() {
        Collection<byte[]> collection;
        FlowAddress it;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = this.arguments;
        byte[] byArray = this.script.getBytes();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FlowArgument flowArgument = (FlowArgument)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((FlowArgument)((Object)it)).getBytes());
        }
        $this$map$iv = this.authorizers;
        byte[] byArray2 = this.payerAddress.getBytes();
        long l = this.proposalKey.getSequenceNumber();
        long l2 = this.proposalKey.getKeyIndex();
        byte[] byArray3 = this.proposalKey.getAddress().getBytes();
        long l3 = this.gasLimit;
        byte[] byArray4 = this.referenceBlockId.getBytes();
        collection2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FlowAddress)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getBytes());
        }
        Collection<byte[]> collection3 = collection = (List)destination$iv$iv;
        byte[] byArray5 = byArray2;
        long l4 = l;
        long l5 = l2;
        byte[] byArray6 = byArray3;
        long l6 = l3;
        byte[] byArray7 = byArray4;
        Collection collection4 = collection2;
        byte[] byArray8 = byArray;
        return new Payload(byArray8, (List<byte[]>)collection4, byArray7, l6, byArray6, l5, l4, byArray5, (List<byte[]>)collection3);
    }

    /*
     * WARNING - void declaration
     */
    private final PayloadEnvelope getAuthorization() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.payloadSignatures;
        Payload payload = this.getPayload();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FlowTransactionSignature flowTransactionSignature = (FlowTransactionSignature)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new EnvelopeSignature(it.getSignerIndex(), it.getKeyIndex(), it.getSignature().getBytes()));
        }
        List list = (List)destination$iv$iv;
        Payload payload2 = payload;
        return new PayloadEnvelope(payload2, list);
    }

    /*
     * WARNING - void declaration
     */
    private final PaymentEnvelope getPayment() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.envelopeSignatures;
        PayloadEnvelope payloadEnvelope = this.getAuthorization();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FlowTransactionSignature flowTransactionSignature = (FlowTransactionSignature)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new EnvelopeSignature(it.getSignerIndex(), it.getKeyIndex(), it.getSignature().getBytes()));
        }
        List list = (List)destination$iv$iv;
        PayloadEnvelope payloadEnvelope2 = payloadEnvelope;
        return new PaymentEnvelope(payloadEnvelope2, list);
    }

    private final TransactionEnvelope getTransaction() {
        Collection<EnvelopeSignature> collection;
        FlowTransactionSignature it;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = this.payloadSignatures;
        Payload payload = this.getPayload();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FlowTransactionSignature flowTransactionSignature = (FlowTransactionSignature)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new EnvelopeSignature(it.getSignerIndex(), it.getKeyIndex(), it.getSignature().getBytes()));
        }
        $this$map$iv = this.envelopeSignatures;
        collection2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FlowTransactionSignature)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new EnvelopeSignature(it.getSignerIndex(), it.getKeyIndex(), it.getSignature().getBytes()));
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        Collection collection3 = collection2;
        Payload payload2 = payload;
        return new TransactionEnvelope(payload2, (List<EnvelopeSignature>)collection3, list);
    }

    @NotNull
    public final byte[] getCanonicalPayload() {
        byte[] byArray = RLPCodec.encode((Object)this.getPayload());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encode(...)");
        return byArray;
    }

    @NotNull
    public final byte[] getCanonicalAuthorizationEnvelope() {
        byte[] byArray = RLPCodec.encode((Object)this.getAuthorization());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encode(...)");
        return byArray;
    }

    @NotNull
    public final byte[] getCanonicalPaymentEnvelope() {
        byte[] byArray = RLPCodec.encode((Object)this.getPayment());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encode(...)");
        return byArray;
    }

    @NotNull
    public final byte[] getCanonicalTransaction() {
        byte[] byArray = RLPCodec.encode((Object)this.getTransaction());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encode(...)");
        return byArray;
    }

    @NotNull
    public final FlowId getId() {
        return FlowId.Companion.of(ExtensionsKt.sha3256Hash(this.getCanonicalTransaction()));
    }

    @NotNull
    public final List<FlowAddress> getSignerList() {
        List ret = new ArrayList();
        Set seen = new LinkedHashSet();
        Function1 addSigner2 = (Function1)new Function1<FlowAddress, Unit>((Set<FlowAddress>)seen, (List<FlowAddress>)ret){
            final /* synthetic */ Set<FlowAddress> $seen;
            final /* synthetic */ List<FlowAddress> $ret;
            {
                this.$seen = $seen;
                this.$ret = $ret;
                super(1);
            }

            public final void invoke(@NotNull FlowAddress address) {
                Intrinsics.checkNotNullParameter((Object)address, (String)"address");
                if (this.$seen.contains(address)) {
                    return;
                }
                this.$ret.add(address);
                this.$seen.add(address);
            }
        };
        addSigner2.invoke((Object)this.proposalKey.getAddress());
        addSigner2.invoke((Object)this.payerAddress);
        Iterable $this$forEach$iv = this.authorizers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            addSigner2.invoke(element$iv);
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<FlowAddress, Integer> getSignerMap() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)this.getSignerList());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getValue(), (Object)it.getIndex()));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @JvmOverloads
    @NotNull
    public final TransactionOuterClass.Transaction.Builder builder(@NotNull TransactionOuterClass.Transaction.Builder builder) {
        Serializable it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Iterable iterable = this.arguments;
        TransactionOuterClass.Transaction.Builder builder2 = builder.setScript(this.script.getByteStringValue());
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FlowArgument flowArgument = (FlowArgument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((FlowArgument)it).getByteStringValue());
        }
        $this$map$iv = this.authorizers;
        builder2 = builder2.addAllArguments((Iterable)((List)destination$iv$iv)).setReferenceBlockId(this.referenceBlockId.getByteStringValue()).setGasLimit(this.gasLimit).setProposalKey(FlowTransactionProposalKey.builder$default(this.proposalKey, null, 1, null).build()).setPayer(this.payerAddress.getByteStringValue());
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FlowAddress)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getByteStringValue());
        }
        $this$map$iv = this.payloadSignatures;
        builder2 = builder2.addAllAuthorizers((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FlowTransactionSignature)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FlowTransactionSignature.builder$default((FlowTransactionSignature)it, null, 1, null).build());
        }
        $this$map$iv = this.envelopeSignatures;
        builder2 = builder2.addAllPayloadSignatures((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FlowTransactionSignature)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FlowTransactionSignature.builder$default((FlowTransactionSignature)it, null, 1, null).build());
        }
        TransactionOuterClass.Transaction.Builder builder3 = builder2.addAllEnvelopeSignatures((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"addAllEnvelopeSignatures(...)");
        return builder3;
    }

    public static /* synthetic */ TransactionOuterClass.Transaction.Builder builder$default(FlowTransaction flowTransaction, TransactionOuterClass.Transaction.Builder builder, int n, Object object) {
        if ((n & 1) != 0) {
            TransactionOuterClass.Transaction.Builder builder2 = TransactionOuterClass.Transaction.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder(...)");
            builder = builder2;
        }
        return flowTransaction.builder(builder);
    }

    @NotNull
    public final FlowTransaction addPayloadSignature(@NotNull FlowAddress address, int keyIndex, @NotNull Signer signer) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        return this.addPayloadSignature(address, keyIndex, new FlowSignature(signer.signAsTransaction(this.getCanonicalPayload())));
    }

    @NotNull
    public final FlowTransaction addPayloadSignature(@NotNull FlowAddress address, int keyIndex, @NotNull FlowSignature signature) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        List payloadSignatures = CollectionsKt.toMutableList((Collection)this.payloadSignatures);
        Integer n = this.getSignerMap().get(address);
        payloadSignatures.add(new FlowTransactionSignature(address, n != null ? n : -1, keyIndex, signature));
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                FlowTransactionSignature it = (FlowTransactionSignature)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getSignerIndex());
                it = (FlowTransactionSignature)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getSignerIndex()));
            }
        };
        return FlowTransaction.copy$default(this, null, null, null, 0L, null, null, null, CollectionsKt.sortedWith((Iterable)payloadSignatures, (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    FlowTransactionSignature it = (FlowTransactionSignature)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getKeyIndex());
                    it = (FlowTransactionSignature)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getKeyIndex()));
                }
                return n;
            }
        }), null, 383, null).updateSignerIndices();
    }

    @NotNull
    public final FlowTransaction addEnvelopeSignature(@NotNull FlowAddress address, int keyIndex, @NotNull Signer signer) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        return this.addEnvelopeSignature(address, keyIndex, new FlowSignature(signer.signAsTransaction(this.getCanonicalAuthorizationEnvelope())));
    }

    @NotNull
    public final FlowTransaction addEnvelopeSignature(@NotNull FlowAddress address, int keyIndex, @NotNull FlowSignature signature) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        List envelopeSignatures = CollectionsKt.toMutableList((Collection)this.envelopeSignatures);
        Integer n = this.getSignerMap().get(address);
        envelopeSignatures.add(new FlowTransactionSignature(address, n != null ? n : -1, keyIndex, signature));
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                FlowTransactionSignature it = (FlowTransactionSignature)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getSignerIndex());
                it = (FlowTransactionSignature)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getSignerIndex()));
            }
        };
        return FlowTransaction.copy$default(this, null, null, null, 0L, null, null, null, null, CollectionsKt.sortedWith((Iterable)envelopeSignatures, (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    FlowTransactionSignature it = (FlowTransactionSignature)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getKeyIndex());
                    it = (FlowTransactionSignature)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getKeyIndex()));
                }
                return n;
            }
        }), 255, null).updateSignerIndices();
    }

    @NotNull
    public final FlowTransaction updateSignerIndices() {
        Map<FlowAddress, Integer> map = this.getSignerMap();
        List payloadSignatures = CollectionsKt.toMutableList((Collection)this.payloadSignatures);
        Iterator iterator = payloadSignatures.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            FlowTransactionSignature sig = (FlowTransactionSignature)iterator.next();
            if (map.containsKey(sig.getAddress())) continue;
            payloadSignatures.set(i, FlowTransactionSignature.copy$default((FlowTransactionSignature)payloadSignatures.get(i), null, i, 0, null, 13, null));
        }
        List envelopeSignatures = CollectionsKt.toMutableList((Collection)this.envelopeSignatures);
        Iterator iterator2 = envelopeSignatures.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int i = n2++;
            FlowTransactionSignature sig = (FlowTransactionSignature)iterator2.next();
            if (map.containsKey(sig.getAddress())) continue;
            envelopeSignatures.set(i, FlowTransactionSignature.copy$default((FlowTransactionSignature)envelopeSignatures.get(i), null, i, 0, null, 13, null));
        }
        return FlowTransaction.copy$default(this, null, null, null, 0L, null, null, null, payloadSignatures, envelopeSignatures, 127, null);
    }

    @NotNull
    public final FlowScript component1() {
        return this.script;
    }

    @NotNull
    public final List<FlowArgument> component2() {
        return this.arguments;
    }

    @NotNull
    public final FlowId component3() {
        return this.referenceBlockId;
    }

    public final long component4() {
        return this.gasLimit;
    }

    @NotNull
    public final FlowTransactionProposalKey component5() {
        return this.proposalKey;
    }

    @NotNull
    public final FlowAddress component6() {
        return this.payerAddress;
    }

    @NotNull
    public final List<FlowAddress> component7() {
        return this.authorizers;
    }

    @NotNull
    public final List<FlowTransactionSignature> component8() {
        return this.payloadSignatures;
    }

    @NotNull
    public final List<FlowTransactionSignature> component9() {
        return this.envelopeSignatures;
    }

    @NotNull
    public final FlowTransaction copy(@NotNull FlowScript script, @NotNull List<FlowArgument> arguments, @NotNull FlowId referenceBlockId, long gasLimit, @NotNull FlowTransactionProposalKey proposalKey, @NotNull FlowAddress payerAddress, @NotNull List<FlowAddress> authorizers, @NotNull List<FlowTransactionSignature> payloadSignatures, @NotNull List<FlowTransactionSignature> envelopeSignatures) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)referenceBlockId, (String)"referenceBlockId");
        Intrinsics.checkNotNullParameter((Object)proposalKey, (String)"proposalKey");
        Intrinsics.checkNotNullParameter((Object)payerAddress, (String)"payerAddress");
        Intrinsics.checkNotNullParameter(authorizers, (String)"authorizers");
        Intrinsics.checkNotNullParameter(payloadSignatures, (String)"payloadSignatures");
        Intrinsics.checkNotNullParameter(envelopeSignatures, (String)"envelopeSignatures");
        return new FlowTransaction(script, arguments, referenceBlockId, gasLimit, proposalKey, payerAddress, authorizers, payloadSignatures, envelopeSignatures);
    }

    public static /* synthetic */ FlowTransaction copy$default(FlowTransaction flowTransaction, FlowScript flowScript, List list, FlowId flowId, long l, FlowTransactionProposalKey flowTransactionProposalKey, FlowAddress flowAddress, List list2, List list3, List list4, int n, Object object) {
        if ((n & 1) != 0) {
            flowScript = flowTransaction.script;
        }
        if ((n & 2) != 0) {
            list = flowTransaction.arguments;
        }
        if ((n & 4) != 0) {
            flowId = flowTransaction.referenceBlockId;
        }
        if ((n & 8) != 0) {
            l = flowTransaction.gasLimit;
        }
        if ((n & 0x10) != 0) {
            flowTransactionProposalKey = flowTransaction.proposalKey;
        }
        if ((n & 0x20) != 0) {
            flowAddress = flowTransaction.payerAddress;
        }
        if ((n & 0x40) != 0) {
            list2 = flowTransaction.authorizers;
        }
        if ((n & 0x80) != 0) {
            list3 = flowTransaction.payloadSignatures;
        }
        if ((n & 0x100) != 0) {
            list4 = flowTransaction.envelopeSignatures;
        }
        return flowTransaction.copy(flowScript, list, flowId, l, flowTransactionProposalKey, flowAddress, list2, list3, list4);
    }

    @NotNull
    public String toString() {
        return "FlowTransaction(script=" + this.script + ", arguments=" + this.arguments + ", referenceBlockId=" + this.referenceBlockId + ", gasLimit=" + this.gasLimit + ", proposalKey=" + this.proposalKey + ", payerAddress=" + this.payerAddress + ", authorizers=" + this.authorizers + ", payloadSignatures=" + this.payloadSignatures + ", envelopeSignatures=" + this.envelopeSignatures + ")";
    }

    public int hashCode() {
        int result = this.script.hashCode();
        result = result * 31 + ((Object)this.arguments).hashCode();
        result = result * 31 + this.referenceBlockId.hashCode();
        result = result * 31 + Long.hashCode(this.gasLimit);
        result = result * 31 + this.proposalKey.hashCode();
        result = result * 31 + this.payerAddress.hashCode();
        result = result * 31 + ((Object)this.authorizers).hashCode();
        result = result * 31 + ((Object)this.payloadSignatures).hashCode();
        result = result * 31 + ((Object)this.envelopeSignatures).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FlowTransaction)) {
            return false;
        }
        FlowTransaction flowTransaction = (FlowTransaction)other;
        if (!Intrinsics.areEqual((Object)this.script, (Object)flowTransaction.script)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.arguments, flowTransaction.arguments)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.referenceBlockId, (Object)flowTransaction.referenceBlockId)) {
            return false;
        }
        if (this.gasLimit != flowTransaction.gasLimit) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.proposalKey, (Object)flowTransaction.proposalKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.payerAddress, (Object)flowTransaction.payerAddress)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.authorizers, flowTransaction.authorizers)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.payloadSignatures, flowTransaction.payloadSignatures)) {
            return false;
        }
        return Intrinsics.areEqual(this.envelopeSignatures, flowTransaction.envelopeSignatures);
    }

    @JvmOverloads
    @NotNull
    public final TransactionOuterClass.Transaction.Builder builder() {
        return FlowTransaction.builder$default(this, null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final FlowTransaction of(@NotNull TransactionOuterClass.Transaction value) {
        return Companion.of(value);
    }

    @JvmStatic
    @NotNull
    public static final FlowTransaction of(@NotNull byte[] bytes) {
        return Companion.of(bytes);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/onflow/flow/sdk/FlowTransaction$Companion;", "", "()V", "of", "Lorg/onflow/flow/sdk/FlowTransaction;", "bytes", "", "value", "Lorg/onflow/protobuf/entities/TransactionOuterClass$Transaction;", "sdk"})
    @SourceDebugExtension(value={"SMAP\nmodels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 models.kt\norg/onflow/flow/sdk/FlowTransaction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1182:1\n1549#2:1183\n1620#2,3:1184\n1549#2:1187\n1620#2,3:1188\n1549#2:1191\n1620#2,3:1192\n1549#2:1195\n1620#2,3:1196\n1549#2:1199\n1620#2,3:1200\n1549#2:1203\n1620#2,3:1204\n1549#2:1207\n1620#2,3:1208\n1549#2:1211\n1620#2,3:1212\n*S KotlinDebug\n*F\n+ 1 models.kt\norg/onflow/flow/sdk/FlowTransaction$Companion\n*L\n448#1:1183\n448#1:1184,3\n453#1:1187\n453#1:1188,3\n454#1:1191\n454#1:1192,3\n455#1:1195\n455#1:1196,3\n462#1:1199\n462#1:1200,3\n471#1:1203\n471#1:1204,3\n473#1:1207\n473#1:1208,3\n476#1:1211\n476#1:1212,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FlowTransaction of(@NotNull TransactionOuterClass.Transaction value) {
            Collection<FlowTransactionSignature> collection;
            Collection<FlowTransactionSignature> collection2;
            Collection<FlowAddress> collection3;
            ByteString it;
            Collection collection4;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            byte[] byArray = value.getScript().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            FlowScript flowScript = new FlowScript(byArray);
            List list = value.getArgumentsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArgumentsList(...)");
            Iterable iterable = list;
            FlowScript flowScript2 = flowScript;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ByteString byteString = (ByteString)item$iv$iv;
                collection4 = destination$iv$iv;
                boolean bl = false;
                byte[] byArray2 = it.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
                collection4.add(new FlowArgument(byArray2));
            }
            byte[] byArray3 = value.getReferenceBlockId().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"toByteArray(...)");
            FlowId flowId = FlowId.Companion.of(byArray3);
            long l = value.getGasLimit();
            TransactionOuterClass.Transaction.ProposalKey proposalKey = value.getProposalKey();
            Intrinsics.checkNotNullExpressionValue((Object)proposalKey, (String)"getProposalKey(...)");
            FlowTransactionProposalKey flowTransactionProposalKey = FlowTransactionProposalKey.Companion.of(proposalKey);
            byte[] byArray4 = value.getPayer().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"toByteArray(...)");
            FlowAddress flowAddress = FlowAddress.Companion.of(byArray4);
            List list2 = value.getAuthorizersList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAuthorizersList(...)");
            $this$map$iv = list2;
            FlowAddress flowAddress2 = flowAddress;
            FlowTransactionProposalKey flowTransactionProposalKey2 = flowTransactionProposalKey;
            long l2 = l;
            FlowId flowId2 = flowId;
            collection4 = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ByteString)item$iv$iv;
                collection3 = destination$iv$iv;
                boolean bl = false;
                byte[] byArray5 = it.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"toByteArray(...)");
                collection3.add(FlowAddress.Companion.of(byArray5));
            }
            collection3 = (List)destination$iv$iv;
            List list3 = value.getPayloadSignaturesList();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getPayloadSignaturesList(...)");
            $this$map$iv = list3;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TransactionOuterClass.Transaction.Signature)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection2.add(FlowTransactionSignature.Companion.of((TransactionOuterClass.Transaction.Signature)it));
            }
            collection2 = (List)destination$iv$iv;
            List list4 = value.getEnvelopeSignaturesList();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getEnvelopeSignaturesList(...)");
            $this$map$iv = list4;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TransactionOuterClass.Transaction.Signature)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(FlowTransactionSignature.Companion.of((TransactionOuterClass.Transaction.Signature)it));
            }
            Collection<FlowTransactionSignature> collection5 = collection = (List)destination$iv$iv;
            Collection<FlowTransactionSignature> collection6 = collection2;
            Collection<FlowAddress> collection7 = collection3;
            FlowAddress flowAddress3 = flowAddress2;
            FlowTransactionProposalKey flowTransactionProposalKey3 = flowTransactionProposalKey2;
            long l3 = l2;
            FlowId flowId3 = flowId2;
            Collection collection8 = collection4;
            FlowScript flowScript3 = flowScript2;
            return new FlowTransaction(flowScript3, (List<FlowArgument>)collection8, flowId3, l3, flowTransactionProposalKey3, flowAddress3, (List<FlowAddress>)collection7, (List<FlowTransactionSignature>)collection6, (List<FlowTransactionSignature>)collection5);
        }

        @JvmStatic
        @NotNull
        public final FlowTransaction of(@NotNull byte[] bytes) {
            Collection collection;
            Collection<FlowAddress> collection2;
            Object it;
            Collection collection3;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Object object = RLPCodec.decode((byte[])bytes, TransactionEnvelope.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"decode(...)");
            TransactionEnvelope txEnvelope = (TransactionEnvelope)object;
            FlowTransaction tx = null;
            Iterable iterable = txEnvelope.getPayload().getArguments();
            FlowScript flowScript = new FlowScript(txEnvelope.getPayload().getScript());
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                byte[] byArray = (byte[])item$iv$iv;
                collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(new FlowArgument((byte[])it));
            }
            $this$map$iv = txEnvelope.getPayload().getAuthorizers();
            FlowAddress flowAddress = FlowAddress.Companion.of(txEnvelope.getPayload().getPayer());
            FlowTransactionProposalKey flowTransactionProposalKey = new FlowTransactionProposalKey(FlowAddress.Companion.of(txEnvelope.getPayload().getProposalKeyAddress()), (int)txEnvelope.getPayload().getProposalKeyIndex(), txEnvelope.getPayload().getProposalKeySequenceNumber());
            long l = txEnvelope.getPayload().getGasLimit();
            FlowId flowId = FlowId.Companion.of(txEnvelope.getPayload().getReferenceBlockId());
            collection3 = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (byte[])item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(FlowAddress.Companion.of((byte[])it));
            }
            collection2 = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 384;
            List list = null;
            List list2 = null;
            Collection<FlowAddress> collection4 = collection2;
            FlowAddress flowAddress2 = flowAddress;
            FlowTransactionProposalKey flowTransactionProposalKey2 = flowTransactionProposalKey;
            long l2 = l;
            FlowId flowId2 = flowId;
            Collection collection5 = collection3;
            FlowScript flowScript2 = flowScript;
            tx = new FlowTransaction(flowScript2, (List)collection5, flowId2, l2, flowTransactionProposalKey2, flowAddress2, (List)collection4, list2, list, n, defaultConstructorMarker);
            $this$map$iv = txEnvelope.getPayloadSignatures();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (EnvelopeSignature)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                tx = tx.addPayloadSignature(tx.getSignerList().get(((EnvelopeSignature)it).getSignerIndex()), ((EnvelopeSignature)it).getKeyIndex(), new FlowSignature(((EnvelopeSignature)it).getSignature()));
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            $this$map$iv = txEnvelope.getEnvelopeSignatures();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (EnvelopeSignature)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                tx = tx.addEnvelopeSignature(tx.getSignerList().get(((EnvelopeSignature)it).getSignerIndex()), ((EnvelopeSignature)it).getKeyIndex(), new FlowSignature(((EnvelopeSignature)it).getSignature()));
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_1 = (List)destination$iv$iv;
            return tx;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

