/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.onflow.flow.sdk.FlowAccessApi;
import org.onflow.flow.sdk.FlowAccount;
import org.onflow.flow.sdk.FlowAddress;
import org.onflow.flow.sdk.FlowTransactionProposalKey;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000b\u001a\u00020\u001a2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bJ\u000e\u0010\u000b\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u001cJ\u000e\u0010\u000b\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u001dJ\u000e\u0010\u000b\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u0006J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010\u0012\u001a\u00020\u001a2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020 0\u001bJ\u000e\u0010\u0012\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\bJ\u0014\u0010\u0017\u001a\u00020\u001a2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020 0\u001bJ\u000e\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\bJ\u0016\u0010!\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u001dR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006#"}, d2={"Lorg/onflow/flow/sdk/FlowTransactionProposalKeyBuilder;", "", "api", "Lorg/onflow/flow/sdk/FlowAccessApi;", "(Lorg/onflow/flow/sdk/FlowAccessApi;)V", "_address", "Lorg/onflow/flow/sdk/FlowAddress;", "_keyIndex", "", "_sequenceNumber", "value", "address", "getAddress", "()Lorg/onflow/flow/sdk/FlowAddress;", "setAddress", "(Lorg/onflow/flow/sdk/FlowAddress;)V", "getApi", "()Lorg/onflow/flow/sdk/FlowAccessApi;", "keyIndex", "getKeyIndex", "()Ljava/lang/Number;", "setKeyIndex", "(Ljava/lang/Number;)V", "sequenceNumber", "getSequenceNumber", "setSequenceNumber", "", "Lkotlin/Function0;", "", "", "build", "Lorg/onflow/flow/sdk/FlowTransactionProposalKey;", "", "usingKeyAtAddress", "publicKey", "sdk"})
@SourceDebugExtension(value={"SMAP\ntransaction-dsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 transaction-dsl.kt\norg/onflow/flow/sdk/FlowTransactionProposalKeyBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,742:1\n1#2:743\n*E\n"})
public final class FlowTransactionProposalKeyBuilder {
    @Nullable
    private final FlowAccessApi api;
    @Nullable
    private FlowAddress _address;
    @Nullable
    private Number _keyIndex;
    @Nullable
    private Number _sequenceNumber;

    public FlowTransactionProposalKeyBuilder(@Nullable FlowAccessApi api) {
        this.api = api;
    }

    public /* synthetic */ FlowTransactionProposalKeyBuilder(FlowAccessApi flowAccessApi, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            flowAccessApi = null;
        }
        this(flowAccessApi);
    }

    @Nullable
    public final FlowAccessApi getApi() {
        return this.api;
    }

    public final void usingKeyAtAddress(@NotNull FlowAddress address, @NotNull String publicKey) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        if (!(this.api != null)) {
            boolean $i$a$-require-FlowTransactionProposalKeyBuilder$usingKeyAtAddress$32 = false;
            String $i$a$-require-FlowTransactionProposalKeyBuilder$usingKeyAtAddress$32 = "Builder not created with an API instance";
            throw new IllegalArgumentException($i$a$-require-FlowTransactionProposalKeyBuilder$usingKeyAtAddress$32.toString());
        }
        FlowAccessApi.AccessApiCallResponse<FlowAccount> result = this.api.getAccountAtLatestBlock(address);
        if (!(result instanceof FlowAccessApi.AccessApiCallResponse.Success)) {
            if (result instanceof FlowAccessApi.AccessApiCallResponse.Error) {
                throw new IllegalStateException("Account for address not found: " + ((FlowAccessApi.AccessApiCallResponse.Error)result).getMessage(), ((FlowAccessApi.AccessApiCallResponse.Error)result).getThrowable());
            }
            throw new NoWhenBranchMatchedException();
        }
        FlowAccount account = (FlowAccount)((FlowAccessApi.AccessApiCallResponse.Success)result).getData();
        int keyIndex = account.getKeyIndex(publicKey);
        if (!(keyIndex != -1)) {
            boolean bl = false;
            String string = "PublicKey not found for account";
            throw new IllegalArgumentException(string.toString());
        }
        this.address(address);
        this.keyIndex(keyIndex);
        this.sequenceNumber(account.getKeys().get(keyIndex).getSequenceNumber());
    }

    @NotNull
    public final FlowAddress getAddress() {
        FlowAddress flowAddress = this._address;
        Intrinsics.checkNotNull((Object)flowAddress);
        return flowAddress;
    }

    public final void setAddress(@NotNull FlowAddress value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._address = value;
    }

    public final void address(@NotNull FlowAddress address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.setAddress(address);
    }

    public final void address(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.address(new FlowAddress(address));
    }

    public final void address(@NotNull byte[] address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.address(FlowAddress.Companion.of(address));
    }

    public final void address(@NotNull Function0<FlowAddress> address) {
        Intrinsics.checkNotNullParameter(address, (String)"address");
        this.address((FlowAddress)address.invoke());
    }

    @NotNull
    public final Number getKeyIndex() {
        Number number = this._keyIndex;
        Intrinsics.checkNotNull((Object)number);
        return number;
    }

    public final void setKeyIndex(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._keyIndex = value;
    }

    public final void keyIndex(@NotNull Number keyIndex) {
        Intrinsics.checkNotNullParameter((Object)keyIndex, (String)"keyIndex");
        this.setKeyIndex(keyIndex.intValue());
    }

    public final void keyIndex(@NotNull Function0<Integer> keyIndex) {
        Intrinsics.checkNotNullParameter(keyIndex, (String)"keyIndex");
        this.keyIndex((Number)keyIndex.invoke());
    }

    @NotNull
    public final Number getSequenceNumber() {
        Number number = this._sequenceNumber;
        Intrinsics.checkNotNull((Object)number);
        return number;
    }

    public final void setSequenceNumber(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._sequenceNumber = value;
    }

    public final void sequenceNumber(@NotNull Number sequenceNumber) {
        Intrinsics.checkNotNullParameter((Object)sequenceNumber, (String)"sequenceNumber");
        this.setSequenceNumber(sequenceNumber.longValue());
    }

    public final void sequenceNumber(@NotNull Function0<Integer> sequenceNumber) {
        Intrinsics.checkNotNullParameter(sequenceNumber, (String)"sequenceNumber");
        this.sequenceNumber((Number)sequenceNumber.invoke());
    }

    @NotNull
    public final FlowTransactionProposalKey build() {
        FlowAddress flowAddress = this._address;
        if (flowAddress == null) {
            boolean $i$a$-checkNotNull-FlowTransactionProposalKeyBuilder$build$42 = false;
            String $i$a$-checkNotNull-FlowTransactionProposalKeyBuilder$build$42 = "address of FlowTransactionProposalKey required";
            throw new IllegalStateException($i$a$-checkNotNull-FlowTransactionProposalKeyBuilder$build$42.toString());
        }
        Number number = this._keyIndex;
        Integer n = number != null ? Integer.valueOf(number.intValue()) : null;
        if (n == null) {
            FlowAddress flowAddress2 = flowAddress;
            boolean $i$a$-checkNotNull-FlowTransactionProposalKeyBuilder$build$52 = false;
            FlowAddress flowAddress3 = flowAddress2;
            String $i$a$-checkNotNull-FlowTransactionProposalKeyBuilder$build$52 = "keyIndex of FlowTransactionProposalKey required";
            throw new IllegalStateException($i$a$-checkNotNull-FlowTransactionProposalKeyBuilder$build$52.toString());
        }
        int n2 = ((Number)n).intValue();
        Number number2 = this._sequenceNumber;
        Long l = number2 != null ? Long.valueOf(number2.longValue()) : null;
        if (l == null) {
            int n3 = n2;
            FlowAddress flowAddress4 = flowAddress;
            boolean bl = false;
            String string = "sequenceNumber of FlowTransactionProposalKey required";
            FlowAddress flowAddress5 = flowAddress4;
            int n4 = n3;
            String string2 = string;
            throw new IllegalStateException(string2.toString());
        }
        long l2 = ((Number)l).longValue();
        int n5 = n2;
        FlowAddress flowAddress6 = flowAddress;
        return new FlowTransactionProposalKey(flowAddress6, n5, l2);
    }

    public FlowTransactionProposalKeyBuilder() {
        this(null, 1, null);
    }
}

