/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk;

import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.onflow.flow.sdk.FlowAccessApi;
import org.onflow.flow.sdk.FlowAddress;
import org.onflow.flow.sdk.FlowBlockHeader;
import org.onflow.flow.sdk.FlowId;
import org.onflow.flow.sdk.FlowTransaction;
import org.onflow.flow.sdk.FlowTransactionResult;
import org.onflow.flow.sdk.FlowTransactionStatus;
import org.onflow.flow.sdk.FlowTransactionStub;
import org.onflow.flow.sdk.Signer;
import org.onflow.flow.sdk.TransactionBuilder;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001f\u0010\u0000\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u001a0\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u001a/\u0010\u0000\u001a\u00020\u0011*\u00020\u000b2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u001aG\u0010\u0013\u001a\u00020\u0011*\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u000f2\b\b\u0002\u0010\u0019\u001a\u00020\u000f2\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u001a"}, d2={"flowTransaction", "Lorg/onflow/flow/sdk/FlowTransaction;", "block", "Lkotlin/Function1;", "Lorg/onflow/flow/sdk/TransactionBuilder;", "", "Lkotlin/ExtensionFunctionType;", "waitForSeal", "Lorg/onflow/flow/sdk/FlowAccessApi$AccessApiCallResponse;", "Lorg/onflow/flow/sdk/FlowTransactionResult;", "api", "Lorg/onflow/flow/sdk/FlowAccessApi;", "transactionId", "Lorg/onflow/flow/sdk/FlowId;", "pauseMs", "", "timeoutMs", "Lorg/onflow/flow/sdk/FlowTransactionStub;", "referenceBlockId", "simpleFlowTransaction", "address", "Lorg/onflow/flow/sdk/FlowAddress;", "signer", "Lorg/onflow/flow/sdk/Signer;", "gasLimit", "keyIndex", "sdk"})
@SourceDebugExtension(value={"SMAP\ntransaction-dsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 transaction-dsl.kt\norg/onflow/flow/sdk/Transaction_dslKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,742:1\n1#2:743\n*E\n"})
public final class Transaction_dslKt {
    @NotNull
    public static final FlowAccessApi.AccessApiCallResponse<FlowTransactionResult> waitForSeal(@NotNull FlowAccessApi api, @NotNull FlowId transactionId, @NotNull Number pauseMs, @NotNull Number timeoutMs) throws TimeoutException {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        Intrinsics.checkNotNullParameter((Object)pauseMs, (String)"pauseMs");
        Intrinsics.checkNotNullParameter((Object)timeoutMs, (String)"timeoutMs");
        if (!(pauseMs.longValue() < timeoutMs.longValue())) {
            boolean bl = false;
            String string = "pause must be less than timeout";
            throw new IllegalStateException(string.toString());
        }
        long start = System.currentTimeMillis();
        do {
            FlowAccessApi.AccessApiCallResponse<FlowTransactionResult> result;
            if (!((result = api.getTransactionResultById(transactionId)) instanceof FlowAccessApi.AccessApiCallResponse.Success)) {
                if (result instanceof FlowAccessApi.AccessApiCallResponse.Error) {
                    return new FlowAccessApi.AccessApiCallResponse.Error("Failed to retrieve transaction result: " + ((FlowAccessApi.AccessApiCallResponse.Error)result).getMessage(), ((FlowAccessApi.AccessApiCallResponse.Error)result).getThrowable());
                }
                throw new NoWhenBranchMatchedException();
            }
            FlowTransactionResult ret = (FlowTransactionResult)((FlowAccessApi.AccessApiCallResponse.Success)result).getData();
            if (ret.getStatus() == FlowTransactionStatus.SEALED) {
                return new FlowAccessApi.AccessApiCallResponse.Success<FlowTransactionResult>(ret);
            }
            Thread.sleep(pauseMs.longValue());
        } while (System.currentTimeMillis() - start <= timeoutMs.longValue());
        return new FlowAccessApi.AccessApiCallResponse.Error("Timeout waiting for seal", new TimeoutException("Timeout waiting for seal"));
    }

    public static /* synthetic */ FlowAccessApi.AccessApiCallResponse waitForSeal$default(FlowAccessApi flowAccessApi, FlowId flowId, Number number, Number number2, int n, Object object) throws TimeoutException {
        if ((n & 4) != 0) {
            number = 500L;
        }
        if ((n & 8) != 0) {
            number2 = 10000L;
        }
        return Transaction_dslKt.waitForSeal(flowAccessApi, flowId, number, number2);
    }

    @NotNull
    public static final FlowTransaction flowTransaction(@NotNull Function1<? super TransactionBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        TransactionBuilder builder = new TransactionBuilder(null, 1, null);
        block.invoke((Object)builder);
        return builder.build();
    }

    @NotNull
    public static final FlowTransactionStub flowTransaction(@NotNull FlowAccessApi $this$flowTransaction, @Nullable FlowId referenceBlockId, @NotNull Function1<? super TransactionBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$flowTransaction, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        FlowId flowId = referenceBlockId;
        if (flowId == null) {
            FlowAccessApi $this$flowTransaction_u24lambda_u241 = $this$flowTransaction;
            boolean bl = false;
            FlowAccessApi.AccessApiCallResponse result = FlowAccessApi.DefaultImpls.getLatestBlockHeader$default($this$flowTransaction_u24lambda_u241, false, 1, null);
            if (result instanceof FlowAccessApi.AccessApiCallResponse.Success) {
                flowId = ((FlowBlockHeader)((FlowAccessApi.AccessApiCallResponse.Success)result).getData()).getId();
            } else {
                if (result instanceof FlowAccessApi.AccessApiCallResponse.Error) {
                    throw new IllegalStateException("Failed to retrieve latest block header: " + ((FlowAccessApi.AccessApiCallResponse.Error)result).getMessage(), ((FlowAccessApi.AccessApiCallResponse.Error)result).getThrowable());
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        FlowId actualReferenceBlockId = flowId;
        TransactionBuilder builder = new TransactionBuilder($this$flowTransaction);
        builder.setReferenceBlockId(actualReferenceBlockId);
        block.invoke((Object)builder);
        return new FlowTransactionStub($this$flowTransaction, builder);
    }

    public static /* synthetic */ FlowTransactionStub flowTransaction$default(FlowAccessApi flowAccessApi, FlowId flowId, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            flowId = null;
        }
        return Transaction_dslKt.flowTransaction(flowAccessApi, flowId, (Function1<? super TransactionBuilder, Unit>)function1);
    }

    @NotNull
    public static final FlowTransactionStub simpleFlowTransaction(@NotNull FlowAccessApi $this$simpleFlowTransaction, @NotNull FlowAddress address, @NotNull Signer signer, @NotNull Number gasLimit, @NotNull Number keyIndex, @NotNull Function1<? super TransactionBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$simpleFlowTransaction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
        Intrinsics.checkNotNullParameter((Object)gasLimit, (String)"gasLimit");
        Intrinsics.checkNotNullParameter((Object)keyIndex, (String)"keyIndex");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return Transaction_dslKt.flowTransaction$default($this$simpleFlowTransaction, null, (Function1)new Function1<TransactionBuilder, Unit>(gasLimit, address, keyIndex, signer, block){
            final /* synthetic */ Number $gasLimit;
            final /* synthetic */ FlowAddress $address;
            final /* synthetic */ Number $keyIndex;
            final /* synthetic */ Signer $signer;
            final /* synthetic */ Function1<TransactionBuilder, Unit> $block;
            {
                this.$gasLimit = $gasLimit;
                this.$address = $address;
                this.$keyIndex = $keyIndex;
                this.$signer = $signer;
                this.$block = $block;
                super(1);
            }

            public final void invoke(@NotNull TransactionBuilder $this$flowTransaction) {
                Intrinsics.checkNotNullParameter((Object)$this$flowTransaction, (String)"$this$flowTransaction");
                $this$flowTransaction.gasLimit(this.$gasLimit);
                $this$flowTransaction.proposeAndPay(this.$address, this.$keyIndex, this.$signer);
                this.$block.invoke((Object)$this$flowTransaction);
            }
        }, 1, null);
    }

    public static /* synthetic */ FlowTransactionStub simpleFlowTransaction$default(FlowAccessApi flowAccessApi, FlowAddress flowAddress, Signer signer, Number number, Number number2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            number = 100;
        }
        if ((n & 8) != 0) {
            number2 = 0;
        }
        return Transaction_dslKt.simpleFlowTransaction(flowAccessApi, flowAddress, signer, number, number2, (Function1<? super TransactionBuilder, Unit>)function1);
    }
}

