/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk.crypto;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.KeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.jetbrains.annotations.NotNull;
import org.onflow.flow.sdk.ExtensionsKt;
import org.onflow.flow.sdk.HashAlgorithm;
import org.onflow.flow.sdk.Hasher;
import org.onflow.flow.sdk.SignatureAlgorithm;
import org.onflow.flow.sdk.Signer;
import org.onflow.flow.sdk.crypto.HasherImpl;
import org.onflow.flow.sdk.crypto.KeyPair;
import org.onflow.flow.sdk.crypto.PrivateKey;
import org.onflow.flow.sdk.crypto.PublicKey;
import org.onflow.flow.sdk.crypto.SignerImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0012\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0015H\u0007J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0015H\u0007J\u0012\u0010$\u001a\u00020%2\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000b2\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010)\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0018\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u001eH\u0007\u00a8\u0006-"}, d2={"Lorg/onflow/flow/sdk/crypto/Crypto;", "", "()V", "checkHashAlgoForSigning", "", "hashAlgo", "Lorg/onflow/flow/sdk/HashAlgorithm;", "checkSupportedSignAlgo", "algo", "Lorg/onflow/flow/sdk/SignatureAlgorithm;", "decodePrivateKey", "Lorg/onflow/flow/sdk/crypto/PrivateKey;", "key", "", "decodePublicKey", "Lorg/onflow/flow/sdk/crypto/PublicKey;", "derivePublicKey", "Ljava/security/PublicKey;", "sk", "Ljava/security/PrivateKey;", "ecDomainFromECSpec", "Lorg/bouncycastle/crypto/params/ECDomainParameters;", "spec", "Lorg/bouncycastle/jce/spec/ECParameterSpec;", "formatSignature", "", "r", "Ljava/math/BigInteger;", "s", "curveOrderSize", "", "generateKeyPair", "Lorg/onflow/flow/sdk/crypto/KeyPair;", "getCurveFieldSize", "curve", "getCurveOrderSize", "getHasher", "Lorg/onflow/flow/sdk/Hasher;", "getSigner", "Lorg/onflow/flow/sdk/Signer;", "privateKey", "jsecPrivateKeyToHexString", "jsecPublicKeyToHexString", "pk", "curveFieldSize", "sdk"})
public final class Crypto {
    @NotNull
    public static final Crypto INSTANCE = new Crypto();

    private Crypto() {
    }

    @JvmStatic
    public static final void checkSupportedSignAlgo(@NotNull SignatureAlgorithm algo) {
        Intrinsics.checkNotNullParameter((Object)((Object)algo), (String)"algo");
        SignatureAlgorithm[] signatureAlgorithmArray = new SignatureAlgorithm[]{SignatureAlgorithm.ECDSA_SECP256k1, SignatureAlgorithm.ECDSA_P256};
        if (!CollectionsKt.listOf((Object[])signatureAlgorithmArray).contains((Object)algo)) {
            throw new IllegalArgumentException("algorithm " + algo + " is not supported");
        }
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KeyPair generateKeyPair(@NotNull SignatureAlgorithm algo) {
        Intrinsics.checkNotNullParameter((Object)((Object)algo), (String)"algo");
        Crypto.checkSupportedSignAlgo(algo);
        KeyPairGenerator generator = KeyPairGenerator.getInstance("EC", "BC");
        generator.initialize(new ECGenParameterSpec(algo.getCurve()), new SecureRandom());
        java.security.KeyPair keyPair = generator.generateKeyPair();
        java.security.PrivateKey sk = keyPair.getPrivate();
        java.security.PublicKey pk = keyPair.getPublic();
        ECNamedCurveParameterSpec curveSpec = ECNamedCurveTable.getParameterSpec((String)algo.getCurve());
        Intrinsics.checkNotNull((Object)curveSpec);
        int curveOrderSize = Crypto.getCurveOrderSize(Crypto.ecDomainFromECSpec((org.bouncycastle.jce.spec.ECParameterSpec)curveSpec));
        int curveFieldSize = Crypto.getCurveFieldSize(Crypto.ecDomainFromECSpec((org.bouncycastle.jce.spec.ECParameterSpec)curveSpec));
        Intrinsics.checkNotNull((Object)pk);
        PublicKey publicKey = new PublicKey(pk, algo, Crypto.jsecPublicKeyToHexString(pk, curveFieldSize));
        Intrinsics.checkNotNull((Object)sk);
        String string = Crypto.jsecPrivateKeyToHexString(sk, curveOrderSize);
        PrivateKey privateKey = new PrivateKey(sk, algo, string, publicKey);
        return new KeyPair(privateKey, publicKey);
    }

    public static /* synthetic */ KeyPair generateKeyPair$default(SignatureAlgorithm signatureAlgorithm, int n, Object object) {
        if ((n & 1) != 0) {
            signatureAlgorithm = SignatureAlgorithm.ECDSA_P256;
        }
        return Crypto.generateKeyPair(signatureAlgorithm);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PrivateKey decodePrivateKey(@NotNull String key, @NotNull SignatureAlgorithm algo) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)algo), (String)"algo");
        Crypto.checkSupportedSignAlgo(algo);
        ECNamedCurveParameterSpec curveSpec = ECNamedCurveTable.getParameterSpec((String)algo.getCurve());
        Intrinsics.checkNotNull((Object)curveSpec);
        int curveOrderSize = Crypto.getCurveOrderSize(Crypto.ecDomainFromECSpec((org.bouncycastle.jce.spec.ECParameterSpec)curveSpec));
        int curveFieldSize = Crypto.getCurveFieldSize(Crypto.ecDomainFromECSpec((org.bouncycastle.jce.spec.ECParameterSpec)curveSpec));
        if (key.length() != 2 * curveOrderSize) {
            throw new IllegalArgumentException("string length must be " + 2 * curveOrderSize + ", got " + key.length());
        }
        ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(new BigInteger(key, 16), (org.bouncycastle.jce.spec.ECParameterSpec)curveSpec);
        KeyFactory keyFactory = KeyFactory.getInstance(algo.getAlgorithm(), "BC");
        java.security.PrivateKey sk = keyFactory.generatePrivate((KeySpec)ecPrivateKeySpec);
        Intrinsics.checkNotNull((Object)sk);
        java.security.PublicKey pk = Crypto.derivePublicKey(sk);
        PublicKey publicKey = new PublicKey(pk, algo, Crypto.jsecPublicKeyToHexString(pk, curveFieldSize));
        return new PrivateKey(sk, algo, key, publicKey);
    }

    public static /* synthetic */ PrivateKey decodePrivateKey$default(String string, SignatureAlgorithm signatureAlgorithm, int n, Object object) {
        if ((n & 2) != 0) {
            signatureAlgorithm = SignatureAlgorithm.ECDSA_P256;
        }
        return Crypto.decodePrivateKey(string, signatureAlgorithm);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PublicKey decodePublicKey(@NotNull String key, @NotNull SignatureAlgorithm algo) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)algo), (String)"algo");
        Crypto.checkSupportedSignAlgo(algo);
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)algo.getCurve());
        Intrinsics.checkNotNull((Object)ecParameterSpec);
        int curveFieldSize = Crypto.getCurveFieldSize(Crypto.ecDomainFromECSpec((org.bouncycastle.jce.spec.ECParameterSpec)ecParameterSpec));
        if (key.length() != 4 * curveFieldSize) {
            throw new IllegalArgumentException("string length must be " + 2 * curveFieldSize + ", got " + key.length());
        }
        ECNamedCurveSpec params = new ECNamedCurveSpec(algo.getCurve(), ecParameterSpec.getCurve(), ecParameterSpec.getG(), ecParameterSpec.getN());
        byte[] byArray = new byte[]{4};
        ECPoint point = ECPointUtil.decodePoint((EllipticCurve)params.getCurve(), (byte[])ArraysKt.plus((byte[])byArray, (byte[])ExtensionsKt.hexToBytes(key)));
        ECPublicKeySpec keySpec = new ECPublicKeySpec(point, (ECParameterSpec)params);
        KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
        java.security.PublicKey publicKey = keyFactory.generatePublic(keySpec);
        Intrinsics.checkNotNull((Object)publicKey);
        return new PublicKey(publicKey, algo, key);
    }

    public static /* synthetic */ PublicKey decodePublicKey$default(String string, SignatureAlgorithm signatureAlgorithm, int n, Object object) {
        if ((n & 2) != 0) {
            signatureAlgorithm = SignatureAlgorithm.ECDSA_P256;
        }
        return Crypto.decodePublicKey(string, signatureAlgorithm);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Signer getSigner(@NotNull PrivateKey privateKey, @NotNull HashAlgorithm hashAlgo) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgo), (String)"hashAlgo");
        return new SignerImpl(privateKey, hashAlgo);
    }

    public static /* synthetic */ Signer getSigner$default(PrivateKey privateKey, HashAlgorithm hashAlgorithm, int n, Object object) {
        if ((n & 2) != 0) {
            hashAlgorithm = HashAlgorithm.SHA3_256;
        }
        return Crypto.getSigner(privateKey, hashAlgorithm);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Hasher getHasher(@NotNull HashAlgorithm hashAlgo) {
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgo), (String)"hashAlgo");
        return new HasherImpl(hashAlgo, null, null, 0, 14, null);
    }

    public static /* synthetic */ Hasher getHasher$default(HashAlgorithm hashAlgorithm, int n, Object object) {
        if ((n & 1) != 0) {
            hashAlgorithm = HashAlgorithm.SHA3_256;
        }
        return Crypto.getHasher(hashAlgorithm);
    }

    @JvmStatic
    @NotNull
    public static final ECDomainParameters ecDomainFromECSpec(@NotNull org.bouncycastle.jce.spec.ECParameterSpec spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        ECDomainParameters domain = new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN(), spec.getH());
        return domain;
    }

    @JvmStatic
    @NotNull
    public static final String jsecPrivateKeyToHexString(@NotNull java.security.PrivateKey sk, int curveOrderSize) {
        Intrinsics.checkNotNullParameter((Object)sk, (String)"sk");
        String hexString = "";
        if (!(sk instanceof ECPrivateKey)) {
            throw new IllegalArgumentException("PrivateKey must be an ECPublicKey");
        }
        byte[] paddedSKBytes = new byte[curveOrderSize];
        byte[] skBytes = ((ECPrivateKey)sk).getD().toByteArray();
        Intrinsics.checkNotNull((Object)skBytes);
        ArraysKt.copyInto$default((byte[])skBytes, (byte[])paddedSKBytes, (int)Math.max(curveOrderSize - skBytes.length, 0), (int)Math.max(skBytes.length - curveOrderSize, 0), (int)0, (int)8, null);
        hexString = ExtensionsKt.bytesToHex(paddedSKBytes);
        Random.Default.nextBytes(skBytes);
        Random.Default.nextBytes(paddedSKBytes);
        return hexString;
    }

    @JvmStatic
    @NotNull
    public static final String jsecPublicKeyToHexString(@NotNull java.security.PublicKey pk, int curveFieldSize) {
        Intrinsics.checkNotNullParameter((Object)pk, (String)"pk");
        if (!(pk instanceof ECPublicKey)) {
            throw new IllegalArgumentException("PublicKey must be an ECPublicKey");
        }
        byte[] paddedPKBytes = new byte[2 * curveFieldSize];
        byte[] xBytes = ((ECPublicKey)pk).getQ().getXCoord().getEncoded();
        byte[] yBytes = ((ECPublicKey)pk).getQ().getYCoord().getEncoded();
        Intrinsics.checkNotNull((Object)xBytes);
        ArraysKt.copyInto$default((byte[])xBytes, (byte[])paddedPKBytes, (int)Math.max(curveFieldSize - xBytes.length, 0), (int)Math.max(xBytes.length - curveFieldSize, 0), (int)0, (int)8, null);
        Intrinsics.checkNotNull((Object)yBytes);
        ArraysKt.copyInto$default((byte[])yBytes, (byte[])paddedPKBytes, (int)(curveFieldSize + Math.max(curveFieldSize - yBytes.length, 0)), (int)Math.max(yBytes.length - curveFieldSize, 0), (int)0, (int)8, null);
        String hexString = ExtensionsKt.bytesToHex(ArraysKt.plus((byte[])xBytes, (byte[])yBytes));
        return hexString;
    }

    @JvmStatic
    @NotNull
    public static final java.security.PublicKey derivePublicKey(@NotNull java.security.PrivateKey sk) {
        Intrinsics.checkNotNullParameter((Object)sk, (String)"sk");
        if (!(sk instanceof ECPrivateKey)) {
            throw new IllegalArgumentException("Private key must be an ECPrivateKey");
        }
        ECPrivateKey ecSK = (ECPrivateKey)sk;
        org.bouncycastle.jce.spec.ECParameterSpec curveParams = ecSK.getParameters();
        org.bouncycastle.math.ec.ECPoint bcPoint = curveParams.getCurve().getMultiplier().multiply(curveParams.getG(), ecSK.getD());
        org.bouncycastle.jce.spec.ECPublicKeySpec ECPointParams = new org.bouncycastle.jce.spec.ECPublicKeySpec(bcPoint, curveParams);
        KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
        java.security.PublicKey publicKey = keyFactory.generatePublic((KeySpec)ECPointParams);
        Intrinsics.checkNotNull((Object)publicKey);
        return publicKey;
    }

    @JvmStatic
    public static final void checkHashAlgoForSigning(@NotNull HashAlgorithm hashAlgo) {
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgo), (String)"hashAlgo");
        HashAlgorithm[] hashAlgorithmArray = new HashAlgorithm[]{HashAlgorithm.KECCAK256, HashAlgorithm.SHA2_256, HashAlgorithm.SHA3_256};
        if (!CollectionsKt.listOf((Object[])hashAlgorithmArray).contains((Object)hashAlgo)) {
            throw new IllegalArgumentException("Unsupported hash algorithm: " + hashAlgo.getAlgorithm());
        }
    }

    @JvmStatic
    public static final int getCurveOrderSize(@NotNull ECDomainParameters curve) {
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        int bitSize = curve.getN().bitLength();
        int byteSize = (bitSize + 7) / 8;
        return byteSize;
    }

    @JvmStatic
    public static final int getCurveFieldSize(@NotNull ECDomainParameters curve) {
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        int bitSize = curve.getCurve().getFieldSize();
        int byteSize = (bitSize + 7) / 8;
        return byteSize;
    }

    @JvmStatic
    @NotNull
    public static final byte[] formatSignature(@NotNull BigInteger r, @NotNull BigInteger s, int curveOrderSize) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        byte[] paddedSignature = new byte[2 * curveOrderSize];
        byte[] rBytes = r.toByteArray();
        byte[] sBytes = s.toByteArray();
        Intrinsics.checkNotNull((Object)rBytes);
        ArraysKt.copyInto$default((byte[])rBytes, (byte[])paddedSignature, (int)Math.max(curveOrderSize - rBytes.length, 0), (int)Math.max(rBytes.length - curveOrderSize, 0), (int)0, (int)8, null);
        Intrinsics.checkNotNull((Object)sBytes);
        ArraysKt.copyInto$default((byte[])sBytes, (byte[])paddedSignature, (int)(curveOrderSize + Math.max(curveOrderSize - sBytes.length, 0)), (int)Math.max(sBytes.length - curveOrderSize, 0), (int)0, (int)8, null);
        return paddedSignature;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final KeyPair generateKeyPair() {
        return Crypto.generateKeyPair$default(null, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PrivateKey decodePrivateKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Crypto.decodePrivateKey$default(key, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PublicKey decodePublicKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Crypto.decodePublicKey$default(key, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Signer getSigner(@NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        return Crypto.getSigner$default(privateKey, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Hasher getHasher() {
        return Crypto.getHasher$default(null, 1, null);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

