/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk.crypto;

import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.macs.KMAC;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.onflow.flow.sdk.HashAlgorithm;
import org.onflow.flow.sdk.Hasher;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/onflow/flow/sdk/crypto/HasherImpl;", "Lorg/onflow/flow/sdk/Hasher;", "hashAlgo", "Lorg/onflow/flow/sdk/HashAlgorithm;", "key", "", "customizer", "outputSize", "", "(Lorg/onflow/flow/sdk/HashAlgorithm;[B[BI)V", "kmac", "Lorg/bouncycastle/crypto/macs/KMAC;", "doFinal", "hash", "bytes", "update", "", "off", "len", "sdk"})
public final class HasherImpl
implements Hasher {
    @NotNull
    private final HashAlgorithm hashAlgo;
    @Nullable
    private final byte[] key;
    @Nullable
    private final byte[] customizer;
    private final int outputSize;
    @Nullable
    private KMAC kmac;

    public HasherImpl(@NotNull HashAlgorithm hashAlgo, @Nullable byte[] key, @Nullable byte[] customizer, int outputSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgo), (String)"hashAlgo");
        this.hashAlgo = hashAlgo;
        this.key = key;
        this.customizer = customizer;
        this.outputSize = outputSize;
        if (this.hashAlgo == HashAlgorithm.KMAC128) {
            if (this.outputSize < 32) {
                throw new IllegalArgumentException("KMAC128 output size must be at least 32 bytes");
            }
            if (this.key == null || this.key.length < 16) {
                throw new IllegalArgumentException("KMAC128 requires a key of at least 16 bytes");
            }
            KMAC kMAC = this.kmac = new KMAC(128, this.customizer);
            Intrinsics.checkNotNull((Object)kMAC);
            kMAC.init((CipherParameters)new KeyParameter(this.key));
        } else if (this.hashAlgo == HashAlgorithm.KECCAK256 || this.hashAlgo == HashAlgorithm.SHA3_256 || this.hashAlgo == HashAlgorithm.SHA2_256) {
            if (this.key != null) {
                throw new IllegalArgumentException("Key must be null");
            }
            if (this.customizer != null) {
                throw new IllegalArgumentException("Customizer must be null");
            }
            if (this.outputSize != this.hashAlgo.getOutputSize() / 8) {
                throw new IllegalArgumentException("Output size must be 32 bytes");
            }
        } else {
            throw new IllegalArgumentException("Unsupported hash algorithm: " + this.hashAlgo.getAlgorithm());
        }
    }

    public /* synthetic */ HasherImpl(HashAlgorithm hashAlgorithm, byte[] byArray, byte[] byArray2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            byArray = null;
        }
        if ((n2 & 4) != 0) {
            byArray2 = null;
        }
        if ((n2 & 8) != 0) {
            n = 32;
        }
        this(hashAlgorithm, byArray, byArray2, n);
    }

    @Override
    @NotNull
    public byte[] hash(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.hashAlgo.ordinal()]) {
            case 1 -> {
                Keccak.Digest256 keccakDigest = new Keccak.Digest256();
                byte[] var2_4 = keccakDigest.digest(bytes);
                Intrinsics.checkNotNull((Object)var2_4);
                yield var2_4;
            }
            case 2 -> {
                void var2_5;
                byte[] output = new byte[this.outputSize];
                KMAC v1 = this.kmac;
                Intrinsics.checkNotNull((Object)v1);
                v1.update(bytes, 0, bytes.length);
                KMAC v2 = this.kmac;
                Intrinsics.checkNotNull((Object)v2);
                v2.doFinal(output, 0, this.outputSize);
                yield var2_5;
            }
            default -> {
                MessageDigest digest = MessageDigest.getInstance(this.hashAlgo.getAlgorithm());
                byte[] var2_6 = digest.digest(bytes);
                Intrinsics.checkNotNull((Object)var2_6);
                yield var2_6;
            }
        };
    }

    public final void update(@NotNull byte[] bytes, int off, int len) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            KMAC kMAC = this.kmac;
            if (kMAC == null) break block0;
            kMAC.update(bytes, off, len);
        }
    }

    @NotNull
    public final byte[] doFinal(int outputSize) {
        byte[] output;
        block0: {
            output = new byte[outputSize];
            KMAC kMAC = this.kmac;
            if (kMAC == null) break block0;
            kMAC.doFinal(output, 0, outputSize);
        }
        return output;
    }

    @Override
    @NotNull
    public String hashAsHexString(@NotNull byte[] bytes) {
        return Hasher.DefaultImpls.hashAsHexString(this, bytes);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HashAlgorithm.values().length];
            try {
                nArray[HashAlgorithm.KECCAK256.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HashAlgorithm.KMAC128.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

