/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk.crypto;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.onflow.flow.sdk.SignatureAlgorithm;
import org.onflow.flow.sdk.crypto.PublicKey;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/onflow/flow/sdk/crypto/PrivateKey;", "", "key", "Ljava/security/PrivateKey;", "algo", "Lorg/onflow/flow/sdk/SignatureAlgorithm;", "hex", "", "publicKey", "Lorg/onflow/flow/sdk/crypto/PublicKey;", "(Ljava/security/PrivateKey;Lorg/onflow/flow/sdk/SignatureAlgorithm;Ljava/lang/String;Lorg/onflow/flow/sdk/crypto/PublicKey;)V", "getAlgo", "()Lorg/onflow/flow/sdk/SignatureAlgorithm;", "getHex", "()Ljava/lang/String;", "getKey", "()Ljava/security/PrivateKey;", "getPublicKey", "()Lorg/onflow/flow/sdk/crypto/PublicKey;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "sdk"})
public final class PrivateKey {
    @NotNull
    private final java.security.PrivateKey key;
    @NotNull
    private final SignatureAlgorithm algo;
    @NotNull
    private final String hex;
    @NotNull
    private final PublicKey publicKey;

    public PrivateKey(@NotNull java.security.PrivateKey key, @NotNull SignatureAlgorithm algo, @NotNull String hex, @NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)algo), (String)"algo");
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this.key = key;
        this.algo = algo;
        this.hex = hex;
        this.publicKey = publicKey;
    }

    @NotNull
    public final java.security.PrivateKey getKey() {
        return this.key;
    }

    @NotNull
    public final SignatureAlgorithm getAlgo() {
        return this.algo;
    }

    @NotNull
    public final String getHex() {
        return this.hex;
    }

    @NotNull
    public final PublicKey getPublicKey() {
        return this.publicKey;
    }

    @NotNull
    public final java.security.PrivateKey component1() {
        return this.key;
    }

    @NotNull
    public final SignatureAlgorithm component2() {
        return this.algo;
    }

    @NotNull
    public final String component3() {
        return this.hex;
    }

    @NotNull
    public final PublicKey component4() {
        return this.publicKey;
    }

    @NotNull
    public final PrivateKey copy(@NotNull java.security.PrivateKey key, @NotNull SignatureAlgorithm algo, @NotNull String hex, @NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)algo), (String)"algo");
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        return new PrivateKey(key, algo, hex, publicKey);
    }

    public static /* synthetic */ PrivateKey copy$default(PrivateKey privateKey, java.security.PrivateKey privateKey2, SignatureAlgorithm signatureAlgorithm, String string, PublicKey publicKey, int n, Object object) {
        if ((n & 1) != 0) {
            privateKey2 = privateKey.key;
        }
        if ((n & 2) != 0) {
            signatureAlgorithm = privateKey.algo;
        }
        if ((n & 4) != 0) {
            string = privateKey.hex;
        }
        if ((n & 8) != 0) {
            publicKey = privateKey.publicKey;
        }
        return privateKey.copy(privateKey2, signatureAlgorithm, string, publicKey);
    }

    @NotNull
    public String toString() {
        return "PrivateKey(key=" + this.key + ", algo=" + this.algo + ", hex=" + this.hex + ", publicKey=" + this.publicKey + ")";
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = result * 31 + this.algo.hashCode();
        result = result * 31 + this.hex.hashCode();
        result = result * 31 + this.publicKey.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PrivateKey)) {
            return false;
        }
        PrivateKey privateKey = (PrivateKey)other;
        if (!Intrinsics.areEqual((Object)this.key, (Object)privateKey.key)) {
            return false;
        }
        if (this.algo != privateKey.algo) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.hex, (Object)privateKey.hex)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.publicKey, (Object)privateKey.publicKey);
    }
}

