/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk.crypto;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.onflow.flow.sdk.HashAlgorithm;
import org.onflow.flow.sdk.SignatureAlgorithm;
import org.onflow.flow.sdk.crypto.Crypto;
import org.onflow.flow.sdk.crypto.HasherImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001J\u001e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lorg/onflow/flow/sdk/crypto/PublicKey;", "", "key", "Ljava/security/PublicKey;", "algo", "Lorg/onflow/flow/sdk/SignatureAlgorithm;", "hex", "", "(Ljava/security/PublicKey;Lorg/onflow/flow/sdk/SignatureAlgorithm;Ljava/lang/String;)V", "getAlgo", "()Lorg/onflow/flow/sdk/SignatureAlgorithm;", "getHex", "()Ljava/lang/String;", "getKey", "()Ljava/security/PublicKey;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "verify", "signature", "", "message", "hashAlgo", "Lorg/onflow/flow/sdk/HashAlgorithm;", "sdk"})
public final class PublicKey {
    @NotNull
    private final java.security.PublicKey key;
    @NotNull
    private final SignatureAlgorithm algo;
    @NotNull
    private final String hex;

    public PublicKey(@NotNull java.security.PublicKey key, @NotNull SignatureAlgorithm algo, @NotNull String hex) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)algo), (String)"algo");
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        this.key = key;
        this.algo = algo;
        this.hex = hex;
    }

    @NotNull
    public final java.security.PublicKey getKey() {
        return this.key;
    }

    @NotNull
    public final SignatureAlgorithm getAlgo() {
        return this.algo;
    }

    @NotNull
    public final String getHex() {
        return this.hex;
    }

    public final boolean verify(@NotNull byte[] signature, @NotNull byte[] message, @NotNull HashAlgorithm hashAlgo) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgo), (String)"hashAlgo");
        Crypto.checkSupportedSignAlgo(this.algo);
        Crypto.checkHashAlgoForSigning(hashAlgo);
        if (!(this.key instanceof ECPublicKey)) {
            throw new IllegalArgumentException("key in PublicKey must be an ECPublicKey");
        }
        ECPublicKey ecPK = (ECPublicKey)this.key;
        byte[] hash = new HasherImpl(hashAlgo, null, null, 0, 14, null).hash(message);
        ECDSASigner ecdsaObject = new ECDSASigner();
        ECParameterSpec eCParameterSpec = ecPK.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"getParameters(...)");
        ECDomainParameters domain = Crypto.ecDomainFromECSpec(eCParameterSpec);
        ECPublicKeyParameters cipherParams = new ECPublicKeyParameters(ecPK.getQ(), domain);
        ecdsaObject.init(false, (CipherParameters)cipherParams);
        int curveOrderSize = Crypto.getCurveOrderSize(domain);
        if (signature.length != 2 * curveOrderSize) {
            return false;
        }
        byte[] byArray = signature;
        int n = 0;
        BigInteger r = new BigInteger(1, ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)curveOrderSize));
        byte[] byArray2 = signature;
        int n2 = signature.length;
        BigInteger s = new BigInteger(1, ArraysKt.copyOfRange((byte[])byArray2, (int)curveOrderSize, (int)n2));
        return ecdsaObject.verifySignature(hash, r, s);
    }

    @NotNull
    public final java.security.PublicKey component1() {
        return this.key;
    }

    @NotNull
    public final SignatureAlgorithm component2() {
        return this.algo;
    }

    @NotNull
    public final String component3() {
        return this.hex;
    }

    @NotNull
    public final PublicKey copy(@NotNull java.security.PublicKey key, @NotNull SignatureAlgorithm algo, @NotNull String hex) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)algo), (String)"algo");
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        return new PublicKey(key, algo, hex);
    }

    public static /* synthetic */ PublicKey copy$default(PublicKey publicKey, java.security.PublicKey publicKey2, SignatureAlgorithm signatureAlgorithm, String string, int n, Object object) {
        if ((n & 1) != 0) {
            publicKey2 = publicKey.key;
        }
        if ((n & 2) != 0) {
            signatureAlgorithm = publicKey.algo;
        }
        if ((n & 4) != 0) {
            string = publicKey.hex;
        }
        return publicKey.copy(publicKey2, signatureAlgorithm, string);
    }

    @NotNull
    public String toString() {
        return "PublicKey(key=" + this.key + ", algo=" + this.algo + ", hex=" + this.hex + ")";
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = result * 31 + this.algo.hashCode();
        result = result * 31 + this.hex.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PublicKey)) {
            return false;
        }
        PublicKey publicKey = (PublicKey)other;
        if (!Intrinsics.areEqual((Object)this.key, (Object)publicKey.key)) {
            return false;
        }
        if (this.algo != publicKey.algo) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.hex, (Object)publicKey.hex);
    }
}

