/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk.crypto;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.jetbrains.annotations.NotNull;
import org.onflow.flow.sdk.HashAlgorithm;
import org.onflow.flow.sdk.Signer;
import org.onflow.flow.sdk.crypto.Crypto;
import org.onflow.flow.sdk.crypto.HasherImpl;
import org.onflow.flow.sdk.crypto.PrivateKey;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/onflow/flow/sdk/crypto/SignerImpl;", "Lorg/onflow/flow/sdk/Signer;", "privateKey", "Lorg/onflow/flow/sdk/crypto/PrivateKey;", "hashAlgo", "Lorg/onflow/flow/sdk/HashAlgorithm;", "(Lorg/onflow/flow/sdk/crypto/PrivateKey;Lorg/onflow/flow/sdk/HashAlgorithm;)V", "sign", "", "bytes", "sdk"})
public final class SignerImpl
implements Signer {
    @NotNull
    private final PrivateKey privateKey;
    @NotNull
    private final HashAlgorithm hashAlgo;

    public SignerImpl(@NotNull PrivateKey privateKey, @NotNull HashAlgorithm hashAlgo) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgo), (String)"hashAlgo");
        this.privateKey = privateKey;
        this.hashAlgo = hashAlgo;
        Crypto.checkSupportedSignAlgo(this.privateKey.getAlgo());
        Crypto.checkHashAlgoForSigning(this.hashAlgo);
    }

    @Override
    @NotNull
    public byte[] sign(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (!(this.privateKey.getKey() instanceof ECPrivateKey)) {
            throw new IllegalArgumentException("Private key must be an ECPrivateKey");
        }
        ECPrivateKey ecSK = (ECPrivateKey)this.privateKey.getKey();
        byte[] hash = new HasherImpl(this.hashAlgo, null, null, 0, 14, null).hash(bytes);
        ECDSASigner ecdsaObject = new ECDSASigner();
        ECParameterSpec eCParameterSpec = ecSK.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"getParameters(...)");
        ECDomainParameters domain = Crypto.ecDomainFromECSpec(eCParameterSpec);
        ECPrivateKeyParameters cipherParams = new ECPrivateKeyParameters(ecSK.getD(), domain);
        ecdsaObject.init(true, (CipherParameters)cipherParams);
        BigInteger[] RS = ecdsaObject.generateSignature(hash);
        int curveOrderSize = Crypto.getCurveOrderSize(domain);
        BigInteger bigInteger = RS[0];
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"get(...)");
        BigInteger bigInteger2 = RS[1];
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"get(...)");
        return Crypto.formatSignature(bigInteger, bigInteger2, curveOrderSize);
    }

    @Override
    @NotNull
    public byte[] signWithDomain(@NotNull byte[] bytes, @NotNull byte[] domain) {
        return Signer.DefaultImpls.signWithDomain(this, bytes, domain);
    }

    @Override
    @NotNull
    public byte[] signAsUser(@NotNull byte[] bytes) {
        return Signer.DefaultImpls.signAsUser(this, bytes);
    }

    @Override
    @NotNull
    public byte[] signAsTransaction(@NotNull byte[] bytes) {
        return Signer.DefaultImpls.signAsTransaction(this, bytes);
    }
}

