/*
 * Decompiled with CFR 0.152.
 */
package org.onflow.flow.sdk.impl;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.onflow.flow.sdk.AsyncFlowAccessApi;
import org.onflow.flow.sdk.FlowAccessApi;
import org.onflow.flow.sdk.FlowAccount;
import org.onflow.flow.sdk.FlowAddress;
import org.onflow.flow.sdk.FlowBlock;
import org.onflow.flow.sdk.FlowBlockHeader;
import org.onflow.flow.sdk.FlowChainId;
import org.onflow.flow.sdk.FlowCollection;
import org.onflow.flow.sdk.FlowEventResult;
import org.onflow.flow.sdk.FlowExecutionResult;
import org.onflow.flow.sdk.FlowId;
import org.onflow.flow.sdk.FlowScript;
import org.onflow.flow.sdk.FlowScriptResponse;
import org.onflow.flow.sdk.FlowSnapshot;
import org.onflow.flow.sdk.FlowTransaction;
import org.onflow.flow.sdk.FlowTransactionResult;
import org.onflow.flow.sdk.impl.AsyncFlowAccessApiImpl;
import org.onflow.flow.sdk.impl.AsyncFlowAccessApiImplKt;
import org.onflow.protobuf.access.Access;
import org.onflow.protobuf.access.AccessAPIGrpc;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J2\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J2\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J*\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001c\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\n0\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001c\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\n0\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J$\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\n0\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\n0\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u001f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\n0\t2\u0006\u0010 \u001a\u00020\u0015H\u0016J\u001e\u0010!\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\n0\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\n0\t2\u0006\u0010 \u001a\u00020\u0015H\u0016J\u001e\u0010$\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010%0\n0\t2\u0006\u0010 \u001a\u00020\u0015H\u0016J0\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'0\n0\t2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150,H\u0016J0\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'0\n0\t2\u0006\u0010)\u001a\u00020*2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000f0/H\u0016J\u001e\u00100\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001010\n0\t2\u0006\u0010 \u001a\u00020\u0015H\u0016J\u001c\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\n0\t2\u0006\u00103\u001a\u000204H\u0016J\u001c\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\n0\t2\u0006\u00103\u001a\u000204H\u0016J\u0014\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002070\n0\tH\u0016J\u0014\u00108\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002090\n0\tH\u0016J\u001e\u0010:\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010;0\n0\t2\u0006\u0010 \u001a\u00020\u0015H\u0016J\u001e\u0010<\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010=0\n0\t2\u0006\u0010 \u001a\u00020\u0015H\u0016J\"\u0010>\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0'0\n0\t2\u0006\u0010 \u001a\u00020\u0015H\u0016J\"\u0010?\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0'0\n0\t2\u0006\u0010 \u001a\u00020\u0015H\u0016J\u0014\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\tH\u0016J\u001c\u0010A\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\n0\t2\u0006\u0010B\u001a\u00020;H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/onflow/flow/sdk/impl/AsyncFlowAccessApiImpl;", "Lorg/onflow/flow/sdk/AsyncFlowAccessApi;", "Ljava/io/Closeable;", "api", "Lorg/onflow/protobuf/access/AccessAPIGrpc$AccessAPIFutureStub;", "(Lorg/onflow/protobuf/access/AccessAPIGrpc$AccessAPIFutureStub;)V", "close", "", "executeScriptAtBlockHeight", "Ljava/util/concurrent/CompletableFuture;", "Lorg/onflow/flow/sdk/FlowAccessApi$AccessApiCallResponse;", "Lorg/onflow/flow/sdk/FlowScriptResponse;", "script", "Lorg/onflow/flow/sdk/FlowScript;", "height", "", "arguments", "", "Lcom/google/protobuf/ByteString;", "executeScriptAtBlockId", "blockId", "Lorg/onflow/flow/sdk/FlowId;", "executeScriptAtLatestBlock", "getAccountAtLatestBlock", "Lorg/onflow/flow/sdk/FlowAccount;", "addresss", "Lorg/onflow/flow/sdk/FlowAddress;", "getAccountByAddress", "getAccountByBlockHeight", "getBlockByHeight", "Lorg/onflow/flow/sdk/FlowBlock;", "getBlockById", "id", "getBlockHeaderByHeight", "Lorg/onflow/flow/sdk/FlowBlockHeader;", "getBlockHeaderById", "getCollectionById", "Lorg/onflow/flow/sdk/FlowCollection;", "getEventsForBlockIds", "", "Lorg/onflow/flow/sdk/FlowEventResult;", "type", "", "ids", "", "getEventsForHeightRange", "range", "Lkotlin/ranges/ClosedRange;", "getExecutionResultByBlockId", "Lorg/onflow/flow/sdk/FlowExecutionResult;", "getLatestBlock", "sealed", "", "getLatestBlockHeader", "getLatestProtocolStateSnapshot", "Lorg/onflow/flow/sdk/FlowSnapshot;", "getNetworkParameters", "Lorg/onflow/flow/sdk/FlowChainId;", "getTransactionById", "Lorg/onflow/flow/sdk/FlowTransaction;", "getTransactionResultById", "Lorg/onflow/flow/sdk/FlowTransactionResult;", "getTransactionResultsByBlockId", "getTransactionsByBlockId", "ping", "sendTransaction", "transaction", "sdk"})
@SourceDebugExtension(value={"SMAP\nAsyncFlowAccessApiImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncFlowAccessApiImpl.kt\norg/onflow/flow/sdk/impl/AsyncFlowAccessApiImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,609:1\n1549#2:610\n1620#2,3:611\n*S KotlinDebug\n*F\n+ 1 AsyncFlowAccessApiImpl.kt\norg/onflow/flow/sdk/impl/AsyncFlowAccessApiImpl\n*L\n459#1:610\n459#1:611,3\n*E\n"})
public final class AsyncFlowAccessApiImpl
implements AsyncFlowAccessApi,
Closeable {
    @NotNull
    private final AccessAPIGrpc.AccessAPIFutureStub api;

    public AsyncFlowAccessApiImpl(@NotNull AccessAPIGrpc.AccessAPIFutureStub api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
    }

    @Override
    public void close() {
        Channel chan = this.api.getChannel();
        if (chan instanceof ManagedChannel) {
            ((ManagedChannel)chan).shutdownNow();
        }
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<Unit>> ping() {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<Object>> completionStage;
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.ping(Access.PingRequest.newBuilder().build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<Unit>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to ping", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.ping$lambda$0(ping.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<Unit>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to ping", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlockHeader>> getLatestBlockHeader(boolean sealed) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowBlockHeader>> completionStage;
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getLatestBlockHeader(Access.GetLatestBlockHeaderRequest.newBuilder().setIsSealed(sealed).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlockHeader>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get latest block header", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getLatestBlockHeader$lambda$1(getLatestBlockHeader.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlockHeader>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get latest block header", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlockHeader>> getBlockHeaderById(@NotNull FlowId id) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowBlockHeader>> completionStage;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getBlockHeaderByID(Access.GetBlockHeaderByIDRequest.newBuilder().setId(id.getByteStringValue()).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlockHeader>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get block header by ID", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getBlockHeaderById$lambda$2(getBlockHeaderById.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlockHeader>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get block header by ID", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlockHeader>> getBlockHeaderByHeight(long height) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowBlockHeader>> completionStage;
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getBlockHeaderByHeight(Access.GetBlockHeaderByHeightRequest.newBuilder().setHeight(height).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlockHeader>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get block header by height", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getBlockHeaderByHeight$lambda$3(getBlockHeaderByHeight.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlockHeader>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get block header by height", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlock>> getLatestBlock(boolean sealed) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowBlock>> completionStage;
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getLatestBlock(Access.GetLatestBlockRequest.newBuilder().setIsSealed(sealed).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlock>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get latest block", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getLatestBlock$lambda$4(getLatestBlock.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlock>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get latest block", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlock>> getBlockById(@NotNull FlowId id) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowBlock>> completionStage;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getBlockByID(Access.GetBlockByIDRequest.newBuilder().setId(id.getByteStringValue()).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlock>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get block by ID", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getBlockById$lambda$5(getBlockById.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlock>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get block by ID", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlock>> getBlockByHeight(long height) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowBlock>> completionStage;
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getBlockByHeight(Access.GetBlockByHeightRequest.newBuilder().setHeight(height).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlock>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get block by height", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getBlockByHeight$lambda$6(getBlockByHeight.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowBlock>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get block by height", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowCollection>> getCollectionById(@NotNull FlowId id) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowCollection>> completionStage;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getCollectionByID(Access.GetCollectionByIDRequest.newBuilder().setId(id.getByteStringValue()).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowCollection>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get collection by ID", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getCollectionById$lambda$7(getCollectionById.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowCollection>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get collection by ID", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowId>> sendTransaction(@NotNull FlowTransaction transaction) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowId>> completionStage;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.sendTransaction(Access.SendTransactionRequest.newBuilder().setTransaction(FlowTransaction.builder$default(transaction, null, 1, null).build()).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowId>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to send transaction", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.sendTransaction$lambda$8(sendTransaction.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowId>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to send transaction", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowTransaction>> getTransactionById(@NotNull FlowId id) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowTransaction>> completionStage;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getTransaction(Access.GetTransactionRequest.newBuilder().setId(id.getByteStringValue()).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowTransaction>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get transaction by ID", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getTransactionById$lambda$9(getTransactionById.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowTransaction>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get transaction by ID", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowTransactionResult>> getTransactionResultById(@NotNull FlowId id) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowTransactionResult>> completionStage;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getTransactionResult(Access.GetTransactionRequest.newBuilder().setId(id.getByteStringValue()).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowTransactionResult>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get transaction result by ID", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getTransactionResultById$lambda$10(getTransactionResultById.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowTransactionResult>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get transaction result by ID", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @Deprecated(message="Behaves identically to getAccountAtLatestBlock", replaceWith=@ReplaceWith(expression="getAccountAtLatestBlock", imports={}))
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowAccount>> getAccountByAddress(@NotNull FlowAddress addresss) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowAccount>> completionStage;
        Intrinsics.checkNotNullParameter((Object)addresss, (String)"addresss");
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getAccount(Access.GetAccountRequest.newBuilder().setAddress(addresss.getByteStringValue()).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowAccount>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get account by address", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getAccountByAddress$lambda$11(getAccountByAddress.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowAccount>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get account by address", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowAccount>> getAccountAtLatestBlock(@NotNull FlowAddress addresss) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowAccount>> completionStage;
        Intrinsics.checkNotNullParameter((Object)addresss, (String)"addresss");
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getAccountAtLatestBlock(Access.GetAccountAtLatestBlockRequest.newBuilder().setAddress(addresss.getByteStringValue()).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowAccount>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get account at latest block", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getAccountAtLatestBlock$lambda$12(getAccountAtLatestBlock.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowAccount>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get account at latest block", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowAccount>> getAccountByBlockHeight(@NotNull FlowAddress addresss, long height) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowAccount>> completionStage;
        Intrinsics.checkNotNullParameter((Object)addresss, (String)"addresss");
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getAccountAtBlockHeight(Access.GetAccountAtBlockHeightRequest.newBuilder().setAddress(addresss.getByteStringValue()).setBlockHeight(height).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowAccount>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get account by block height", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getAccountByBlockHeight$lambda$13(getAccountByBlockHeight.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowAccount>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get account by block height", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowScriptResponse>> executeScriptAtLatestBlock(@NotNull FlowScript script, @NotNull Iterable<? extends ByteString> arguments) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowScriptResponse>> completionStage;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.executeScriptAtLatestBlock(Access.ExecuteScriptAtLatestBlockRequest.newBuilder().setScript(script.getByteStringValue()).addAllArguments(arguments).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowScriptResponse>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to execute script at latest block", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.executeScriptAtLatestBlock$lambda$14(executeScriptAtLatestBlock.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowScriptResponse>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to execute script at latest block", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowScriptResponse>> executeScriptAtBlockId(@NotNull FlowScript script, @NotNull FlowId blockId, @NotNull Iterable<? extends ByteString> arguments) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowScriptResponse>> completionStage;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)blockId, (String)"blockId");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.executeScriptAtBlockID(Access.ExecuteScriptAtBlockIDRequest.newBuilder().setBlockId(blockId.getByteStringValue()).setScript(script.getByteStringValue()).addAllArguments(arguments).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowScriptResponse>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to execute script at block ID", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.executeScriptAtBlockId$lambda$15(executeScriptAtBlockId.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowScriptResponse>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to execute script at block ID", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowScriptResponse>> executeScriptAtBlockHeight(@NotNull FlowScript script, long height, @NotNull Iterable<? extends ByteString> arguments) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowScriptResponse>> completionStage;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.executeScriptAtBlockHeight(Access.ExecuteScriptAtBlockHeightRequest.newBuilder().setBlockHeight(height).setScript(script.getByteStringValue()).addAllArguments(arguments).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowScriptResponse>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to execute script at block height", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.executeScriptAtBlockHeight$lambda$16(executeScriptAtBlockHeight.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowScriptResponse>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to execute script at block height", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<List<FlowEventResult>>> getEventsForHeightRange(@NotNull String type, @NotNull ClosedRange<Long> range) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<List<FlowEventResult>>> completionStage;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getEventsForHeightRange(Access.GetEventsForHeightRangeRequest.newBuilder().setType(type).setStartHeight(((Number)((Object)range.getStart())).longValue()).setEndHeight(((Number)((Object)range.getEndInclusive())).longValue()).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<List<FlowEventResult>>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get events for height range", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getEventsForHeightRange$lambda$17(getEventsForHeightRange.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<List<FlowEventResult>>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get events for height range", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<List<FlowEventResult>>> getEventsForBlockIds(@NotNull String type, @NotNull Set<FlowId> ids) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<List<FlowEventResult>>> completionStage;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        try {
            Iterable iterable;
            try {
                Collection<ByteString> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                iterable = ids;
                Access.GetEventsForBlockIDsRequest.Builder builder = Access.GetEventsForBlockIDsRequest.newBuilder().setType(type);
                AccessAPIGrpc.AccessAPIFutureStub accessAPIFutureStub = this.api;
                boolean $i$f$map = false;
                void var7_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FlowId flowId = (FlowId)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getByteStringValue());
                }
                collection = (List)destination$iv$iv;
                iterable = accessAPIFutureStub.getEventsForBlockIDs(builder.addAllBlockIds((Iterable)collection).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<List<FlowEventResult>>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get events for block IDs", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            Iterable iterable2 = iterable;
            Intrinsics.checkNotNull((Object)iterable2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(iterable2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getEventsForBlockIds$lambda$19(getEventsForBlockIds.2.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<List<FlowEventResult>>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get events for block IDs", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowChainId>> getNetworkParameters() {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowChainId>> completionStage;
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getNetworkParameters(Access.GetNetworkParametersRequest.newBuilder().build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowChainId>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get network parameters", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getNetworkParameters$lambda$20(getNetworkParameters.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowChainId>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get network parameters", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowSnapshot>> getLatestProtocolStateSnapshot() {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowSnapshot>> completionStage;
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getLatestProtocolStateSnapshot(Access.GetLatestProtocolStateSnapshotRequest.newBuilder().build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowSnapshot>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get latest protocol state snapshot", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getLatestProtocolStateSnapshot$lambda$21(getLatestProtocolStateSnapshot.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowSnapshot>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get latest protocol state snapshot", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<List<FlowTransaction>>> getTransactionsByBlockId(@NotNull FlowId id) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<List<FlowTransaction>>> completionStage;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getTransactionsByBlockID(Access.GetTransactionsByBlockIDRequest.newBuilder().setBlockId(id.getByteStringValue()).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<List<FlowTransaction>>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get transactions by block ID", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getTransactionsByBlockId$lambda$22(getTransactionsByBlockId.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<List<FlowTransaction>>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get transactions by block ID", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<List<FlowTransactionResult>>> getTransactionResultsByBlockId(@NotNull FlowId id) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<List<FlowTransactionResult>>> completionStage;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getTransactionResultsByBlockID(Access.GetTransactionsByBlockIDRequest.newBuilder().setBlockId(id.getByteStringValue()).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<List<FlowTransactionResult>>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get transaction results by block ID", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getTransactionResultsByBlockId$lambda$23(getTransactionResultsByBlockId.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<List<FlowTransactionResult>>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get transaction results by block ID", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowExecutionResult>> getExecutionResultByBlockId(@NotNull FlowId id) {
        CompletionStage<FlowAccessApi.AccessApiCallResponse<FlowExecutionResult>> completionStage;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            ListenableFuture listenableFuture;
            try {
                listenableFuture = this.api.getExecutionResultByID(Access.GetExecutionResultByIDRequest.newBuilder().setId(id.getByteStringValue()).build());
            }
            catch (Exception e) {
                CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowExecutionResult>> completableFuture2 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get execution result by block ID", e));
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                return completableFuture2;
            }
            ListenableFuture listenableFuture2 = listenableFuture;
            Intrinsics.checkNotNull((Object)listenableFuture2);
            completionStage = AsyncFlowAccessApiImplKt.completableFuture(listenableFuture2).handle((arg_0, arg_1) -> AsyncFlowAccessApiImpl.getExecutionResultByBlockId$lambda$24(getExecutionResultByBlockId.1.INSTANCE, arg_0, arg_1));
            Intrinsics.checkNotNull(completionStage);
        }
        catch (Exception e) {
            CompletableFuture<FlowAccessApi.AccessApiCallResponse<FlowExecutionResult>> completableFuture3 = CompletableFuture.completedFuture(new FlowAccessApi.AccessApiCallResponse.Error("Failed to get execution result by block ID", e));
            Intrinsics.checkNotNull(completableFuture3);
            completionStage = completableFuture3;
        }
        return completionStage;
    }

    private static final FlowAccessApi.AccessApiCallResponse ping$lambda$0(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getLatestBlockHeader$lambda$1(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getBlockHeaderById$lambda$2(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getBlockHeaderByHeight$lambda$3(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getLatestBlock$lambda$4(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getBlockById$lambda$5(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getBlockByHeight$lambda$6(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getCollectionById$lambda$7(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse sendTransaction$lambda$8(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getTransactionById$lambda$9(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getTransactionResultById$lambda$10(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getAccountByAddress$lambda$11(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getAccountAtLatestBlock$lambda$12(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getAccountByBlockHeight$lambda$13(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse executeScriptAtLatestBlock$lambda$14(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse executeScriptAtBlockId$lambda$15(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse executeScriptAtBlockHeight$lambda$16(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getEventsForHeightRange$lambda$17(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getEventsForBlockIds$lambda$19(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getNetworkParameters$lambda$20(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getLatestProtocolStateSnapshot$lambda$21(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getTransactionsByBlockId$lambda$22(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getTransactionResultsByBlockId$lambda$23(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }

    private static final FlowAccessApi.AccessApiCallResponse getExecutionResultByBlockId$lambda$24(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlowAccessApi.AccessApiCallResponse)$tmp0.invoke(p0, (Object)p1);
    }
}

