/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.DeviceUser;
import com.tailf.jnc.Element;
import com.tailf.jnc.IOSubscriber;
import com.tailf.jnc.JNCException;
import com.tailf.jnc.NetconfSession;
import com.tailf.jnc.SSHConnection;
import com.tailf.jnc.SSHSession;
import com.tailf.jnc.YangException;
import com.tailf.jnc.YangXMLParser;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class Device
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String name;
    protected transient SSHConnection con = null;
    protected transient ArrayList<SessionConnData> connSessions;
    protected transient ArrayList<SessionTree> trees;
    protected ArrayList<Element> backlog;
    protected ArrayList<DeviceUser> users;
    protected String mgmt_ip;
    protected int mgmt_port;
    protected int defaultReadTimeout = 0;

    public Device(String string, DeviceUser deviceUser, String string2, int n) {
        this.name = string;
        this.users = new ArrayList();
        this.users.add(deviceUser);
        this.mgmt_ip = string2;
        this.mgmt_port = n;
        this.backlog = new ArrayList();
        this.connSessions = new ArrayList();
        this.trees = new ArrayList();
    }

    public Device(String string, String string2, int n) {
        this.name = string;
        this.users = new ArrayList();
        this.mgmt_ip = string2;
        this.mgmt_port = n;
        this.backlog = new ArrayList();
        this.connSessions = new ArrayList();
        this.trees = new ArrayList();
    }

    public void initTransients() {
        this.backlog = new ArrayList();
        this.connSessions = new ArrayList();
        this.trees = new ArrayList();
    }

    public void addUser(DeviceUser deviceUser) {
        this.users.add(deviceUser);
    }

    public ArrayList<DeviceUser> getUsers() {
        return this.users;
    }

    public void clearConfig(String string) {
        SessionTree sessionTree = this.getTreeData(string);
        sessionTree.configTree = null;
    }

    public Element getConfig(String string) {
        return this.getTreeData((String)string).configTree;
    }

    public void setReadTimeout(String string, int n) {
        SessionConnData sessionConnData = this.getConnData(string);
        sessionConnData.sshSession.setReadTimeout(n);
    }

    public long getReadTimeout(String string) {
        SessionConnData sessionConnData = this.getConnData(string);
        return sessionConnData.sshSession.getReadTimeout();
    }

    public boolean hasConfig(String string) {
        SessionTree sessionTree = this.getTreeData(string);
        return sessionTree.configTree != null;
    }

    public void setConfig(String string, Element element) {
        SessionTree sessionTree = this.getTreeData(string);
        sessionTree.configTree = element;
    }

    public boolean hasBacklog() {
        return this.backlog.size() > 0;
    }

    public void setDefaultReadTimeout(int n) {
        this.defaultReadTimeout = n;
    }

    public void closeSession(String string) {
        SessionConnData sessionConnData = this.removeConnData(string);
        if (sessionConnData.session != null) {
            try {
                sessionConnData.sshSession.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.clearConfig(string);
    }

    public void close() {
        Object object;
        int n;
        for (n = 0; n < this.connSessions.size(); ++n) {
            object = this.connSessions.get(n);
            try {
                ((SessionConnData)object).session.closeSession();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.connSessions = new ArrayList();
        for (n = 0; n < this.trees.size(); ++n) {
            object = this.trees.get(n);
            ((SessionTree)object).configTree = null;
        }
        if (this.con != null) {
            this.con.close();
            this.con = null;
        }
    }

    public boolean hasSession(String string) {
        return this.getSession(string) != null;
    }

    public NetconfSession getSession(String string) {
        SessionConnData sessionConnData = this.getConnData(string);
        return sessionConnData == null ? null : sessionConnData.session;
    }

    public SSHSession getSSHSession(String string) {
        SessionConnData sessionConnData = this.getConnData(string);
        return sessionConnData == null ? null : sessionConnData.sshSession;
    }

    public void connect(String string) throws IOException, JNCException {
        this.connect(string, 0);
    }

    public void connect(String string, int n) throws IOException, JNCException {
        DeviceUser deviceUser = null;
        for (int i = 0; i < this.users.size(); ++i) {
            DeviceUser deviceUser2 = this.users.get(i);
            if (!deviceUser2.getLocalUser().equals(string)) continue;
            deviceUser = deviceUser2;
            break;
        }
        if (deviceUser == null) {
            throw new JNCException(-1, "No such user: " + string);
        }
        this.con = new SSHConnection(this.mgmt_ip, this.mgmt_port, n);
        this.auth(deviceUser);
    }

    public void newSessionConfigTree(String string) {
        if (this.getTreeData(string) == null) {
            this.trees.add(new SessionTree(string));
        }
    }

    public void newSession(String string) throws JNCException, IOException, YangException {
        this.newSession(null, string);
    }

    public void newSession(IOSubscriber iOSubscriber, String string) throws JNCException, IOException {
        SessionConnData sessionConnData = this.getConnData(string);
        this.newSessionConfigTree(string);
        if (sessionConnData != null) {
            int n = -1032;
            throw new YangException(n, string);
        }
        YangXMLParser yangXMLParser = new YangXMLParser();
        SSHSession sSHSession = new SSHSession(this.con, this.defaultReadTimeout);
        if (iOSubscriber != null) {
            sSHSession.addSubscriber(iOSubscriber);
        }
        NetconfSession netconfSession = new NetconfSession(sSHSession, yangXMLParser);
        SessionConnData sessionConnData2 = new SessionConnData(string, sSHSession, netconfSession);
        this.connSessions.add(sessionConnData2);
        if (this.backlog.size() > 0) {
            this.runBacklog(string);
        }
    }

    public void addBackLog(Element element) {
        this.backlog.add(element);
    }

    public Element[] getBacklog() {
        if (this.backlog != null && this.backlog.size() > 0) {
            Element[] elementArray = new Element[this.backlog.size()];
            return this.backlog.toArray(elementArray);
        }
        return null;
    }

    public void runBacklog(String string) throws IOException, JNCException {
        System.out.println("Running backlog ");
        SessionConnData sessionConnData = this.getConnData(string);
        if (sessionConnData == null) {
            throw new YangException(-1032, string);
        }
        for (int i = 0; i < this.backlog.size(); ++i) {
            Element element = this.backlog.get(i);
            System.out.println("Bacloh " + element.toXMLString());
            sessionConnData.session.editConfig(element);
            this.backlog.remove(i);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Device: " + this.name + " " + this.mgmt_ip + ":" + this.mgmt_port + "\n");
        for (SessionConnData sessionConnData : this.connSessions) {
            stringBuffer.append("   session: ").append(sessionConnData.sessionName);
        }
        return stringBuffer.toString();
    }

    private SessionConnData getConnData(String string) {
        for (SessionConnData sessionConnData : this.connSessions) {
            if (!sessionConnData.sessionName.equals(string)) continue;
            return sessionConnData;
        }
        return null;
    }

    private SessionTree getTreeData(String string) {
        for (SessionTree sessionTree : this.trees) {
            if (!sessionTree.sessionName.equals(string)) continue;
            return sessionTree;
        }
        return null;
    }

    private SessionConnData removeConnData(String string) {
        for (int i = 0; i < this.connSessions.size(); ++i) {
            SessionConnData sessionConnData = this.connSessions.get(i);
            if (!sessionConnData.sessionName.equals(string)) continue;
            this.connSessions.remove(i);
            return sessionConnData;
        }
        return null;
    }

    private void auth(DeviceUser deviceUser) throws IOException, JNCException {
        if (deviceUser.getPassword() != null) {
            this.con.authenticateWithPassword(deviceUser.getRemoteuser(), deviceUser.getPassword());
        } else if (deviceUser.getPemPrivateKey() != null) {
            this.con.authenticateWithPublicKey(deviceUser.getRemoteuser(), deviceUser.getPemPrivateKey(), deviceUser.getKeyPassPhrase());
        } else if (deviceUser.getPemFile() != null) {
            this.con.authenticateWithPublicKeyFile(deviceUser.getRemoteuser(), deviceUser.getPemFile(), deviceUser.getKeyPassPhrase());
        }
    }

    private static class SessionTree {
        String sessionName;
        Element configTree;

        SessionTree(String string) {
            this.sessionName = string;
            this.configTree = null;
        }
    }

    private static class SessionConnData {
        String sessionName;
        SSHSession sshSession;
        NetconfSession session;

        SessionConnData(String string, SSHSession sSHSession, NetconfSession netconfSession) {
            this.sessionName = string;
            this.session = netconfSession;
            this.sshSession = sSHSession;
        }
    }
}

