/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Attribute;
import com.tailf.jnc.Element;
import com.tailf.jnc.JNCException;
import com.tailf.jnc.Prefix;
import com.tailf.jnc.PrefixMap;
import com.tailf.jnc.YangElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ElementHandler
extends DefaultHandler {
    public Element current;
    public Element top;
    public PrefixMap prefixes = null;
    public int unknownLevel = 0;
    private boolean leaf = false;
    private String leafNs;
    private String leafName;
    private String leafValue;

    ElementHandler() {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Element element;
        if (this.unknownLevel > 0) {
            this.unkownStartElement(string, string2, attributes);
            return;
        }
        Element element2 = this.current;
        try {
            element = YangElement.createInstance(this, element2, string, string2);
        }
        catch (JNCException jNCException) {
            jNCException.printStackTrace();
            throw new SAXException(jNCException.toString());
        }
        if (this.top == null) {
            this.top = element;
        }
        if (element == null && this.unknownLevel == 1) {
            this.unkownStartElement(string, string2, attributes);
            return;
        }
        if (element == null) {
            this.leaf = true;
            this.leafNs = string;
            this.leafName = string2;
            this.leafValue = "";
            return;
        }
        element.prefixes = this.prefixes;
        this.prefixes = null;
        this.addOtherAttributes(attributes, element);
        this.current = element;
    }

    private void unkownStartElement(String string, String string2, Attributes attributes) throws SAXException {
        Element element = new Element(string, string2);
        element.prefixes = this.prefixes;
        this.prefixes = null;
        this.addOtherAttributes(attributes, element);
        if (this.current == null) {
            this.top = element;
        } else {
            this.current.addChild(element);
        }
        this.current = element;
    }

    private void addOtherAttributes(Attributes attributes, Element element) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getURI(i);
            String string3 = attributes.getValue(i);
            Attribute attribute = new Attribute(string2, string, string3);
            element.addAttr(attribute);
        }
    }

    private void unknownEndElement() {
        if (this.current.hasChildren() && this.current.value != null) {
            this.current.value = null;
        }
        this.current = this.current.getParent();
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.unknownLevel > 0) {
            this.unknownEndElement();
            --this.unknownLevel;
            return;
        }
        if (this.leaf) {
            try {
                ((YangElement)this.current).setLeafValue(this.leafNs, this.leafName, this.leafValue);
            }
            catch (JNCException jNCException) {
                jNCException.printStackTrace();
                throw new SAXException(jNCException.toString());
            }
        } else if (this.current.hasChildren() && this.current.value != null) {
            this.current.value = null;
        }
        if (!this.leaf) {
            this.current = this.current.getParent();
        } else {
            this.leaf = false;
        }
    }

    private void unknownCharacters(char[] cArray, int n, int n2) {
        if (this.current.value == null) {
            this.current.value = "";
        }
        this.current.value = this.current.value + new String(cArray, n, n2);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.unknownLevel > 0) {
            this.unknownCharacters(cArray, n, n2);
            return;
        }
        if (this.leaf) {
            this.leafValue = this.leafValue + new String(cArray, n, n2);
        } else {
            if (this.current.value == null) {
                this.current.value = "";
            }
            this.current.value = this.current.value + new String(cArray, n, n2);
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) {
        if (this.prefixes == null) {
            this.prefixes = new PrefixMap();
        }
        this.prefixes.add(new Prefix(string, string2));
    }
}

