/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Capabilities;
import com.tailf.jnc.Element;
import com.tailf.jnc.JNCException;
import com.tailf.jnc.RevisionInfo;
import com.tailf.jnc.SchemaNode;
import com.tailf.jnc.SchemaTree;
import com.tailf.jnc.Tagpath;
import com.tailf.jnc.Transport;
import com.tailf.jnc.YangElement;

public class Leaf
extends Element {
    private static final long serialVersionUID = 1L;
    private Tagpath tp = null;
    private SchemaNode n = null;

    public Leaf(String string, String string2) {
        super(string, string2);
    }

    @Override
    protected void encode(Transport transport, boolean bl, Capabilities capabilities) throws JNCException {
        if (RevisionInfo.olderRevisionSupportEnabled && capabilities != null) {
            if (this.tp == null) {
                this.tp = this.tagpath();
            }
            if (this.n == null) {
                this.n = SchemaTree.lookup(this.namespace, this.tp);
            }
            String string = capabilities.getRevision(this.namespace);
            if (this.n != null && this.n.revInfo != null) {
                block6: for (RevisionInfo revisionInfo : this.n.revInfo) {
                    if (revisionInfo.introduced.compareTo(string) <= 0) continue;
                    switch (revisionInfo.type) {
                        case 8: {
                            return;
                        }
                        case 1: {
                            if (!revisionInfo.data.equals(this.getValue().toString())) continue block6;
                            throw new JNCException(-12, this.tp + " bad enum value for rev (" + string + ") " + revisionInfo.data);
                        }
                        case 2: {
                            if (!revisionInfo.data.equals(this.getValue().toString())) continue block6;
                            throw new JNCException(-12, this.tp + " bad bits value for rev (" + string + ") " + revisionInfo.data);
                        }
                        case 5: {
                            continue block6;
                        }
                    }
                }
            }
        }
        super.encode(transport, bl, capabilities);
    }

    @Override
    public Leaf clone() {
        Leaf leaf = new Leaf(this.namespace, this.name);
        this.cloneAttrs(leaf);
        this.cloneValue(leaf);
        return leaf;
    }

    public boolean isKey() {
        YangElement yangElement = (YangElement)this.getParent();
        String[] stringArray = yangElement.keyNames();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.name.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }
}

