/*
 * Decompiled with CFR 0.152.
 */
package com.tailf.jnc;

import com.tailf.jnc.Attribute;
import com.tailf.jnc.Capabilities;
import com.tailf.jnc.Element;
import com.tailf.jnc.JNCException;
import com.tailf.jnc.NodeSet;
import com.tailf.jnc.PrefixMap;
import com.tailf.jnc.Transport;
import com.tailf.jnc.XMLParser;
import java.io.IOException;
import java.util.ArrayList;

public class NetconfSession {
    public static final String GET_CONFIG_GT = "get-config>";
    public static final String SOURCE_GT = "source>";
    public static final String FILTER_GT = "filter>";
    public static final String FILTER = "filter ";
    public static final String GET_GT = "get>";
    public static final String EDIT_CONFIG_GT = "edit-config>";
    public static final String TARGET_GT = "target>";
    public static final String CONFIG_GT = "config>";
    public static final String COPY_CONFIG_GT = "copy-config>";
    public static final String VALIDATE_GT = "validate>";
    public static final String STREAM_GT = "stream>";
    public static final String START_TIME_GT = "startTime>";
    public static final String STOP_TIME_GT = "stopTime>";
    int message_id = 1;
    public static final int RUNNING = 0;
    public static final int STARTUP = 1;
    public static final int CANDIDATE = 2;
    public int sessionId;
    protected Capabilities capabilities;
    XMLParser parser;
    Transport out;
    Transport in;
    public static final int NOT_SET = 0;
    public static final int MERGE = 1;
    public static final int REPLACE = 2;
    public static final int NONE = 3;
    private int defaultOperation = 0;
    public static final int SET = 1;
    public static final int TEST_THEN_SET = 2;
    public static final int TEST_ONLY = 3;
    private int testOption = 0;
    public static final int STOP_ON_ERROR = 1;
    public static final int CONTINUE_ON_ERROR = 2;
    public static final int ROLLBACK_ON_ERROR = 3;
    private int errorOption = 0;
    private ArrayList<String> proprietaryClientCaps;
    Attribute withDefaultsAttr = null;
    private String nc;

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public boolean hasCapability(String string) {
        return this.capabilities.hasCapability(string);
    }

    public NetconfSession(Transport transport) throws JNCException, IOException {
        this.out = transport;
        this.in = transport;
        this.parser = new XMLParser();
        this.hello();
    }

    public NetconfSession(Transport transport, XMLParser xMLParser) throws JNCException, IOException {
        this.out = transport;
        this.in = transport;
        this.parser = xMLParser;
        this.hello();
    }

    public NetconfSession() throws JNCException {
        this.parser = new XMLParser();
    }

    public void setTransport(Transport transport) {
        this.out = transport;
        this.in = transport;
    }

    public Transport getTransport() {
        return this.in;
    }

    protected void hello() throws JNCException, IOException {
        NetconfSession.trace("hello: ");
        this.encode_hello(this.out);
        this.out.flush();
        StringBuffer stringBuffer = this.in.readOne();
        Element element = this.parser.parse(stringBuffer.toString());
        Element element2 = element.getFirst("self::hello/capabilities");
        if (element2 == null) {
            throw new JNCException(-7, "hello contains no capabilities");
        }
        NetconfSession.trace("capabilities: \n" + element2.toXMLString());
        this.capabilities = new Capabilities(element2);
        if (!this.capabilities.baseCapability) {
            throw new JNCException(-7, "server does not support NETCONF base capability: urn:ietf:params:netconf:base:1.0");
        }
        Element element3 = element.getFirst("self::hello/session-id");
        if (element3 == null) {
            throw new JNCException(-7, "hello contains no session identifier");
        }
        this.sessionId = Integer.parseInt((String)element3.value);
        NetconfSession.trace("sessionId = " + this.sessionId);
    }

    public Element rpc(String string) throws IOException, JNCException {
        this.out.print(string);
        this.out.flush();
        StringBuffer stringBuffer = this.in.readOne();
        return this.parser.parse(stringBuffer.toString());
    }

    public Element rpc(Element element) throws IOException, JNCException {
        element.encode(this.out, false, this.capabilities);
        this.out.flush();
        StringBuffer stringBuffer = this.in.readOne();
        return this.parser.parse(stringBuffer.toString());
    }

    public int sendRequest(String string) throws IOException {
        this.out.print(string);
        this.out.flush();
        return this.message_id - 1;
    }

    public int sendRequest(Element element) throws IOException, JNCException {
        element.encode(this.out, false, this.capabilities);
        this.out.flush();
        return this.message_id - 1;
    }

    public Element readReply() throws IOException, JNCException {
        StringBuffer stringBuffer = this.in.readOne();
        return this.parser.parse(stringBuffer.toString());
    }

    public NodeSet getConfig(Element element) throws JNCException, IOException {
        return this.getConfig(0, element);
    }

    public NodeSet getConfig() throws JNCException, IOException {
        return this.getConfig(0);
    }

    public NodeSet getConfig(int n) throws JNCException, IOException {
        NetconfSession.trace("getConfig: " + this.datastoreToString(n));
        int n2 = this.encode_getConfig(this.out, this.encode_datastore(n));
        this.out.flush();
        return this.recv_rpc_reply_data(n2);
    }

    public NodeSet callRpc(Element element) throws JNCException, IOException {
        NetconfSession.trace("call: " + element.toXMLString());
        int n = this.encode_rpc(this.out, element);
        this.out.flush();
        return this.recv_call_rpc_reply(element, n);
    }

    public NodeSet getConfig(String string) throws JNCException, IOException {
        return this.getConfig(0, string);
    }

    public NodeSet getConfig(int n, Element element) throws JNCException, IOException {
        NetconfSession.trace("getConfig: " + this.datastoreToString(n) + "\n" + element.toXMLString());
        int n2 = this.encode_getConfig(this.out, this.encode_datastore(n), element);
        this.out.flush();
        return this.recv_rpc_reply_data(n2);
    }

    public NodeSet getConfig(int n, String string) throws JNCException, IOException {
        NetconfSession.trace("getConfig: " + this.datastoreToString(n) + " \"" + string + "\"");
        if (!this.capabilities.xpathCapability) {
            throw new JNCException(-7, "the :xpath capability is not supported by server");
        }
        int n2 = this.encode_getConfig(this.out, this.encode_datastore(n), string);
        this.out.flush();
        return this.recv_rpc_reply_data(n2);
    }

    public NodeSet get() throws JNCException, IOException {
        NetconfSession.trace("get: \"\"");
        int n = this.encode_get(this.out, "");
        this.out.flush();
        return this.recv_rpc_reply_data(n);
    }

    public NodeSet get(Element element) throws JNCException, IOException {
        NetconfSession.trace("get: " + element.toXMLString());
        int n = this.encode_get(this.out, element);
        this.out.flush();
        return this.recv_rpc_reply_data(n);
    }

    public NodeSet get(String string) throws JNCException, IOException {
        NetconfSession.trace("get: \"" + string + "\"");
        if (!this.capabilities.hasXPath()) {
            throw new JNCException(-7, "the :xpath capability is not supported by server");
        }
        int n = this.encode_get(this.out, string);
        this.out.flush();
        return this.recv_rpc_reply_data(n);
    }

    public void editConfig(Element element) throws JNCException, IOException {
        this.editConfig(0, element);
    }

    public void editConfig(NodeSet nodeSet) throws JNCException, IOException {
        this.editConfig(0, nodeSet);
    }

    public void editConfig(int n, Element element) throws JNCException, IOException {
        NetconfSession.trace("editConfig: target=" + this.datastoreToString(n) + "\n" + element.toXMLString());
        int n2 = this.encode_editConfig(this.out, this.encode_datastore(n), element);
        this.out.flush();
        this.recv_rpc_reply_ok(n2);
    }

    public void editConfig(int n, NodeSet nodeSet) throws JNCException, IOException {
        NetconfSession.trace("editConfig: target=" + this.datastoreToString(n) + "\n" + nodeSet.toXMLString());
        int n2 = this.encode_editConfig(this.out, this.encode_datastore(n), nodeSet);
        this.out.flush();
        this.recv_rpc_reply_ok(n2);
    }

    public void editConfig(int n, String string) throws JNCException, IOException {
        NetconfSession.trace("editConfig: target=" + this.datastoreToString(n) + " source=" + string);
        int n2 = this.encode_editConfig(this.out, this.encode_datastore(n), this.encode_url(string));
        this.out.flush();
        this.recv_rpc_reply_ok(n2);
    }

    public void setDefaultOperation(int n) {
        this.defaultOperation = n;
    }

    public void setTestOption(int n) {
        this.testOption = n;
    }

    public void setErrorOption(int n) {
        this.errorOption = n;
    }

    public void copyConfig(Element element, int n) throws JNCException, IOException {
        this.copyConfig(new NodeSet(element), n);
    }

    public void copyConfig(NodeSet nodeSet, int n) throws JNCException, IOException {
        NetconfSession.trace("copyConfig: target=" + this.datastoreToString(n) + "\n" + nodeSet.toXMLString());
        this.encode_copyConfig(this.out, nodeSet, this.encode_datastore(n));
        this.out.flush();
        this.recv_rpc_reply_ok();
    }

    public void copyConfig(Element element, String string) throws JNCException, IOException {
        this.copyConfig(new NodeSet(element), string);
    }

    public void copyConfig(NodeSet nodeSet, String string) throws JNCException, IOException {
        NetconfSession.trace("copyConfig: target=" + string + "\n" + nodeSet.toXMLString());
        this.encode_copyConfig(this.out, nodeSet, this.encode_url(string));
        this.out.flush();
        this.recv_rpc_reply_ok();
    }

    public void copyConfig(int n, int n2) throws JNCException, IOException {
        NetconfSession.trace("copyConfig: " + this.datastoreToString(n) + " " + this.datastoreToString(n2));
        this.encode_copyConfig(this.out, this.encode_datastore(n), this.encode_datastore(n2));
        this.out.flush();
        this.recv_rpc_reply_ok();
    }

    public void copyConfig(int n, String string) throws JNCException, IOException {
        NetconfSession.trace("copyConfig: source=" + this.datastoreToString(n) + " target=" + string);
        this.encode_copyConfig(this.out, this.encode_datastore(n), this.encode_url(string));
        this.out.flush();
        this.recv_rpc_reply_ok();
    }

    public void copyConfig(String string, String string2) throws JNCException, IOException {
        NetconfSession.trace("copyConfig: source=" + string + " target=" + string2);
        this.encode_copyConfig(this.out, this.encode_url(string), this.encode_url(string2));
        this.out.flush();
        this.recv_rpc_reply_ok();
    }

    public void copyConfig(String string, int n) throws JNCException, IOException {
        NetconfSession.trace("copyConfig: source=" + string + " target=" + this.datastoreToString(n));
        this.encode_copyConfig(this.out, this.encode_url(string), this.encode_datastore(n));
        this.out.flush();
        this.recv_rpc_reply_ok();
    }

    public void deleteConfig(int n) throws JNCException, IOException {
        NetconfSession.trace("deleteConfig: " + this.datastoreToString(n));
        this.encode_deleteConfig(this.out, this.encode_datastore(n));
        this.out.flush();
        this.recv_rpc_reply_ok();
    }

    public void deleteConfig(String string) throws JNCException, IOException {
        NetconfSession.trace("deleteConfig: " + string);
        this.encode_deleteConfig(this.out, this.encode_url(string));
        this.out.flush();
        this.recv_rpc_reply_ok();
    }

    public void lock(int n) throws JNCException, IOException {
        NetconfSession.trace("lock: " + this.datastoreToString(n));
        this.encode_lock(this.out, this.encode_datastore(n));
        this.out.flush();
        this.recv_rpc_reply_ok();
    }

    public void unlock(int n) throws JNCException, IOException {
        NetconfSession.trace("unlock: " + this.datastoreToString(n));
        this.encode_unlock(this.out, this.encode_datastore(n));
        this.out.flush();
        this.recv_rpc_reply_ok();
    }

    public int lockPartial(String[] stringArray) throws JNCException, IOException {
        NetconfSession.trace("lockPartial");
        if (!this.capabilities.hasPartialLock()) {
            throw new JNCException(-7, "capability :partial-lock is not supported by server");
        }
        int n = this.encode_lockPartial(this.out, stringArray);
        this.out.flush();
        NodeSet nodeSet = this.recv_rpc_reply_lockPartial(n);
        try {
            Element element = nodeSet.first().getFirst("self::lock-id");
            return Integer.parseInt((String)element.value);
        }
        catch (Exception exception) {
            throw new JNCException(-7, "bad lock-id returned from partial-lock: " + nodeSet.toXMLString());
        }
    }

    public int lockPartial(String string) throws JNCException, IOException {
        return this.lockPartial(new String[]{string});
    }

    public void unlockPartial(int n) throws JNCException, IOException {
        NetconfSession.trace("partialUnlock: " + n);
        if (!this.capabilities.hasPartialLock()) {
            throw new JNCException(-7, "capability :partial-lock is not supported by server");
        }
        if (!this.capabilities.hasXPath()) {
            throw new JNCException(-7, "capability :xpath is not supported by server");
        }
        int n2 = this.encode_unlockPartial(this.out, n);
        this.out.flush();
        this.recv_rpc_reply_ok(n2);
    }

    public void commit() throws JNCException, IOException {
        NetconfSession.trace("commit");
        if (!this.capabilities.hasCandidate()) {
            throw new JNCException(-7, "the :candidate capability is not supported by server");
        }
        int n = this.encode_commit(this.out);
        this.out.flush();
        this.recv_rpc_reply_ok(n);
    }

    public void confirmedCommit(int n) throws JNCException, IOException {
        NetconfSession.trace("confirmedCommit: " + n);
        if (!this.capabilities.hasCandidate()) {
            throw new JNCException(-7, "the :candidate capability is not supported by server");
        }
        if (!this.capabilities.hasConfirmedCommit()) {
            throw new JNCException(-7, "the :confirmed-commit capability is not supported by server");
        }
        int n2 = this.encode_confirmedCommit(this.out, n);
        this.out.flush();
        this.recv_rpc_reply_ok(n2);
    }

    public void discardChanges() throws JNCException, IOException {
        NetconfSession.trace("discardChanges");
        if (!this.capabilities.hasCandidate()) {
            throw new JNCException(-7, "the :candidate capability is not supported by server");
        }
        int n = this.encode_discardChanges(this.out);
        this.out.flush();
        this.recv_rpc_reply_ok(n);
    }

    public void closeSession() throws JNCException, IOException {
        NetconfSession.trace("closeSession");
        int n = this.encode_closeSession(this.out);
        this.out.flush();
        this.recv_rpc_reply_ok(n);
    }

    public void killSession(int n) throws JNCException, IOException {
        NetconfSession.trace("killSession: " + n);
        if (n == this.sessionId) {
            throw new JNCException(-7, "illegal to use kill-session on own session id");
        }
        int n2 = this.encode_killSession(this.out, n);
        this.out.flush();
        this.recv_rpc_reply_ok(n2);
    }

    public void validate(Element element) throws JNCException, IOException {
        NetconfSession.trace("validate: " + element.toXMLString());
        if (!this.capabilities.hasValidate()) {
            throw new JNCException(-7, "capability :validate is not supported by server");
        }
        int n = this.encode_validate(this.out, element);
        this.out.flush();
        this.recv_rpc_reply_ok(n);
    }

    public void validate(int n) throws IOException, JNCException {
        NetconfSession.trace("validate: " + this.datastoreToString(n));
        if (!this.capabilities.hasValidate()) {
            throw new JNCException(-7, "capability :validate is not supported by server");
        }
        int n2 = this.encode_validate(this.out, this.encode_datastore(n));
        this.out.flush();
        this.recv_rpc_reply_ok(n2);
    }

    public void validate(String string) throws IOException, JNCException {
        NetconfSession.trace("validate: " + string);
        if (!this.capabilities.hasValidate()) {
            throw new JNCException(-7, "capability :validate is not supported by server");
        }
        int n = this.encode_validate(this.out, this.encode_url(string));
        this.out.flush();
        this.recv_rpc_reply_ok(n);
    }

    public void createSubscription() throws IOException, JNCException {
        this.createSubscription(null, (String)null, null, null);
    }

    public void createSubscription(String string) throws IOException, JNCException {
        this.createSubscription(string, (String)null, null, null);
    }

    public void createSubscription(String string, NodeSet nodeSet, String string2, String string3) throws IOException, JNCException {
        NetconfSession.trace("createSubscription: stream=" + string + " filter=" + nodeSet.toXMLString() + " from=" + string2 + " to=" + string3);
        if (!this.capabilities.hasNotification()) {
            throw new JNCException(-7, "capability :notification is not supported by server");
        }
        int n = this.encode_createSubscription(this.out, string, nodeSet, string2, string3);
        this.out.flush();
        this.recv_rpc_reply_ok(n);
    }

    public void createSubscription(String string, String string2, String string3, String string4) throws IOException, JNCException {
        NetconfSession.trace("createSubscription: stream=" + string + " filter=" + string2 + " from=" + string3 + " to=" + string4);
        if (!this.capabilities.hasNotification()) {
            throw new JNCException(-7, "capability :notification is not supported by server");
        }
        if (!this.capabilities.hasXPath()) {
            throw new JNCException(-7, "capability :xpath is not supported by server");
        }
        int n = this.encode_createSubscription(this.out, string, string2, string3, string4);
        this.out.flush();
        this.recv_rpc_reply_ok(n);
    }

    public NodeSet getStreams() throws JNCException, IOException {
        Element element = Element.create("urn:ietf:params:xml:ns:netmod:notification", "netconf/streams");
        return this.get(element);
    }

    public Element receiveNotification() throws IOException, JNCException {
        StringBuffer stringBuffer = this.in.readOne();
        NetconfSession.trace("notification= " + stringBuffer);
        if (stringBuffer.length() == 0) {
            throw new JNCException(-5, "empty input");
        }
        Element element = this.parser.parse(stringBuffer.toString());
        Element element2 = element.getFirst("self::notification");
        if (element2 != null) {
            return element;
        }
        throw new JNCException(-10, element);
    }

    public Element action(Element element) throws JNCException, IOException {
        NetconfSession.trace("action: " + element.toXMLString());
        this.encode_action(this.out, element);
        this.out.flush();
        return this.recv_rpc_reply_ok(null);
    }

    void recv_rpc_reply_ok() throws JNCException, IOException {
        this.recv_rpc_reply_ok(null);
    }

    void recv_rpc_reply_ok(int n) throws JNCException, IOException {
        this.recv_rpc_reply_ok(Integer.toString(n));
    }

    protected Element recv_rpc_reply_ok(String string) throws JNCException, IOException {
        Element element;
        Element element2;
        StringBuffer stringBuffer = this.in.readOne();
        NetconfSession.trace("reply= " + stringBuffer);
        if (stringBuffer.length() == 0) {
            throw new JNCException(-5, "empty input");
        }
        Element element3 = this.parser.parse(stringBuffer.toString());
        if (string != null) {
            element2 = element3.getFirst("self::rpc-reply");
            if (element2 != null) {
                this.check_mid(element2, string);
            }
            element = element2 != null ? element2.getFirst("self::rpc-reply/ok") : null;
        } else {
            element = element3.getFirst("self::rpc-reply/ok");
        }
        if (element != null) {
            return element;
        }
        element2 = element3.getFirst("self::rpc-reply/data");
        if (element2 != null) {
            return element2;
        }
        throw new JNCException(-6, element3);
    }

    NodeSet recv_rpc_reply_data(int n) throws JNCException, IOException {
        return this.recv_rpc_reply("/data", this.parser, Integer.toString(n));
    }

    NodeSet recv_rpc_reply_lockPartial(int n) throws JNCException, IOException {
        return this.recv_rpc_reply("", this.parser, Integer.toString(n));
    }

    NodeSet recv_call_rpc_reply(Element element, int n) throws JNCException, IOException {
        XMLParser xMLParser = new XMLParser();
        return this.recv_rpc_reply("", xMLParser, Integer.toString(n));
    }

    NodeSet recv_rpc_reply(String string) throws JNCException, IOException {
        return this.recv_rpc_reply(string, this.parser, null);
    }

    NodeSet recv_rpc_reply(String string, XMLParser xMLParser, String string2) throws JNCException, IOException {
        Element element;
        StringBuffer stringBuffer = this.in.readOne();
        NetconfSession.trace("reply= " + stringBuffer);
        Element element2 = xMLParser.parse(stringBuffer.toString());
        Element element3 = element2.getFirst("self::rpc-reply");
        if (element3 != null) {
            this.check_mid(element3, string2);
        }
        if ((element = element2.getFirst("self::rpc-reply" + string)) != null) {
            PrefixMap prefixMap = element.prefixes;
            if (prefixMap == null) {
                prefixMap = element2.prefixes;
            } else {
                prefixMap.merge(element2.prefixes);
            }
            if (prefixMap == null) {
                prefixMap = new PrefixMap();
            }
            if (element.children != null) {
                for (int i = 0; i < element.children.size(); ++i) {
                    Element element4 = element.children.getElement(i);
                    element4.parent = null;
                    if (element4.prefixes != null) {
                        element4.prefixes.merge(prefixMap);
                        continue;
                    }
                    element4.prefixes = (PrefixMap)prefixMap.clone();
                }
                return element.children;
            }
            return new NodeSet();
        }
        throw new JNCException(-6, element2);
    }

    protected void setCapability(String string) {
        if (this.proprietaryClientCaps == null) {
            this.proprietaryClientCaps = new ArrayList();
        }
        for (int i = 0; i < this.proprietaryClientCaps.size(); ++i) {
            String string2 = this.proprietaryClientCaps.get(i);
            if (!string2.equals(string)) continue;
            return;
        }
        this.proprietaryClientCaps.add(string);
    }

    void encode_hello(Transport transport) {
        transport.print("<hello xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">");
        transport.print("<capabilities>");
        transport.println("<capability>urn:ietf:params:netconf:base:1.0</capability>");
        if (this.proprietaryClientCaps != null) {
            for (int i = 0; i < this.proprietaryClientCaps.size(); ++i) {
                transport.print("<capability>");
                transport.print(this.proprietaryClientCaps.get(i));
                transport.println("</capability>");
            }
        }
        transport.println("</capabilities>");
        transport.print("</hello>");
    }

    protected int encode_rpc_begin(Transport transport) {
        return this.encode_rpc_begin(transport, null);
    }

    protected int encode_rpc_begin(Transport transport, Attribute attribute) {
        String string = Element.defaultPrefixes.nsToPrefix("urn:ietf:params:xml:ns:netconf:base:1.0");
        this.nc = this.mk_prefix_colon(string);
        String string2 = this.mk_xmlns_attr(string, "urn:ietf:params:xml:ns:netconf:base:1.0");
        transport.print("<" + this.nc + "rpc " + string2 + " " + this.nc + "message-id=\"");
        int n = this.message_id++;
        transport.print(n);
        transport.print("\"");
        if (attribute != null) {
            transport.print(" ");
            attribute.encode(transport);
        }
        transport.print(">");
        return n;
    }

    protected void encode_rpc_end(Transport transport) {
        transport.print("</" + this.nc + "rpc>");
    }

    int encode_getConfig(Transport transport, String string, Element element) throws JNCException {
        int n = this.encode_rpc_begin(transport, this.withDefaultsAttr);
        transport.println("<" + this.nc + GET_CONFIG_GT);
        transport.print("<" + this.nc + SOURCE_GT);
        transport.print(string);
        transport.println("</" + this.nc + SOURCE_GT);
        transport.println("<" + this.nc + FILTER + this.nc + "type=\"subtree\">");
        element.encode(transport, true, this.capabilities);
        transport.println("</" + this.nc + FILTER_GT);
        transport.println("</" + this.nc + GET_CONFIG_GT);
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_rpc(Transport transport, Element element) throws JNCException {
        int n = this.encode_rpc_begin(transport);
        element.encode(transport);
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_getConfig(Transport transport, String string, String string2) {
        int n = this.encode_rpc_begin(transport, this.withDefaultsAttr);
        transport.println("<" + this.nc + GET_CONFIG_GT);
        transport.print("<" + this.nc + SOURCE_GT);
        transport.print(string);
        transport.println("</" + this.nc + SOURCE_GT);
        if (string2 != null && string2.length() > 0) {
            transport.print("<" + this.nc + FILTER + this.nc + "type=\"xpath\" " + this.nc + "select=\"");
            transport.print(string2);
            transport.println("\"/>");
        }
        transport.println("</" + this.nc + GET_CONFIG_GT);
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_getConfig(Transport transport, String string) {
        int n = this.encode_rpc_begin(transport, this.withDefaultsAttr);
        transport.println("<" + this.nc + GET_CONFIG_GT);
        transport.print("<" + this.nc + SOURCE_GT);
        transport.print(string);
        transport.println("</" + this.nc + SOURCE_GT);
        transport.println("</" + this.nc + GET_CONFIG_GT);
        this.encode_rpc_end(transport);
        return n;
    }

    String datastoreToString(int n) {
        switch (n) {
            case 0: {
                return "RUNNING";
            }
            case 2: {
                return "CANDIDATE";
            }
            case 1: {
                return "STARTUP";
            }
        }
        return "UNKNOWN_DATASTORE(" + n + ")";
    }

    String encode_datastore(int n) throws JNCException {
        String string = Element.defaultPrefixes.nsToPrefix("urn:ietf:params:xml:ns:netconf:base:1.0");
        this.nc = this.mk_prefix_colon(string);
        switch (n) {
            case 0: {
                return "<" + this.nc + "running/>";
            }
            case 2: {
                return "<" + this.nc + "candidate/>";
            }
            case 1: {
                return "<" + this.nc + "startup/>";
            }
        }
        throw new JNCException(-7, "unknown datastore: " + n);
    }

    String encode_url(String string) throws JNCException {
        if (!this.isUrlOK(string)) {
            throw new JNCException(-7, "the url: \"" + string + "\" is not a supported :url scheme");
        }
        return "<url>" + string + "</url>";
    }

    private boolean isUrlOK(String string) {
        String[] stringArray = this.capabilities.getUrlSchemes();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i] + ":")) continue;
            return true;
        }
        return false;
    }

    int encode_get(Transport transport, Element element) throws JNCException {
        int n = this.encode_rpc_begin(transport, this.withDefaultsAttr);
        transport.println("<" + this.nc + GET_GT);
        transport.println("<" + this.nc + FILTER + this.nc + "type=\"subtree\">");
        element.encode(transport, true, this.capabilities);
        transport.println("</" + this.nc + FILTER_GT);
        transport.println("</" + this.nc + GET_GT);
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_get(Transport transport, String string) {
        int n = this.encode_rpc_begin(transport, this.withDefaultsAttr);
        transport.println("<" + this.nc + GET_GT);
        if (string != null && string.length() > 0) {
            transport.print("<" + this.nc + FILTER + this.nc + "type=\"xpath\" " + this.nc + "select=\"");
            transport.print(string);
            transport.println("\"/>");
        }
        transport.println("</" + this.nc + GET_GT);
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_editConfig(Transport transport, String string, Element element) throws JNCException {
        return this.encode_editConfig(transport, string, new NodeSet(element));
    }

    int encode_editConfig(Transport transport, String string, NodeSet nodeSet) throws JNCException {
        int n = this.encode_rpc_begin(transport);
        transport.println("<" + this.nc + EDIT_CONFIG_GT);
        transport.print("<" + this.nc + TARGET_GT);
        transport.print(string);
        transport.println("</" + this.nc + TARGET_GT);
        this.encode_defaultOperation(transport);
        this.encode_testOption(transport);
        this.encode_errorOption(transport);
        transport.println("<" + this.nc + CONFIG_GT);
        nodeSet.encode(transport, this.capabilities);
        transport.println("</" + this.nc + CONFIG_GT);
        transport.println("</" + this.nc + EDIT_CONFIG_GT);
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_editConfig(Transport transport, String string, String string2) throws JNCException {
        int n = this.encode_rpc_begin(transport);
        transport.println("<" + this.nc + EDIT_CONFIG_GT);
        transport.print("<" + this.nc + TARGET_GT);
        transport.print(string);
        transport.println("</" + this.nc + TARGET_GT);
        this.encode_defaultOperation(transport);
        this.encode_testOption(transport);
        this.encode_errorOption(transport);
        transport.println(string2);
        transport.println("</" + this.nc + EDIT_CONFIG_GT);
        this.encode_rpc_end(transport);
        return n;
    }

    void encode_defaultOperation(Transport transport) throws JNCException {
        switch (this.defaultOperation) {
            case 0: {
                return;
            }
            case 1: {
                transport.println("<" + this.nc + "default-operation>merge</" + this.nc + "default-operation>");
                return;
            }
            case 2: {
                transport.println("<" + this.nc + "default-operation>replace</" + this.nc + "default-operation>");
                return;
            }
            case 3: {
                transport.println("<" + this.nc + "default-operation>none</" + this.nc + "default-operation>");
                return;
            }
        }
        throw new JNCException(-7, "unknown default-operation value: " + this.defaultOperation);
    }

    void encode_testOption(Transport transport) throws JNCException {
        switch (this.testOption) {
            case 0: {
                return;
            }
            case 1: {
                if (!this.capabilities.hasValidate()) {
                    throw new JNCException(-7, "test-option is given but the :validate capability is not supported by server");
                }
                transport.println("<" + this.nc + "test-option>set</" + this.nc + "test-option>");
                return;
            }
            case 2: {
                if (!this.capabilities.hasValidate()) {
                    throw new JNCException(-7, "test-option is given but the :validate capability is not supported by server");
                }
                transport.println("<" + this.nc + "test-option>test-then-set</" + this.nc + "test-option>");
                return;
            }
            case 3: {
                if (!this.capabilities.hasValidate()) {
                    throw new JNCException(-7, "test-option is given but the :validate capability is not supported by server");
                }
                transport.println("<" + this.nc + "test-option>test-only</" + this.nc + "test-option>");
                return;
            }
        }
        throw new JNCException(-7, "unknown test-option value: " + this.testOption);
    }

    void encode_errorOption(Transport transport) throws JNCException {
        switch (this.errorOption) {
            case 0: {
                return;
            }
            case 1: {
                transport.println("<" + this.nc + "error-option>stop-on-error</" + this.nc + "error-option>");
                return;
            }
            case 2: {
                transport.println("<" + this.nc + "error-option>continue-on-error</" + this.nc + "error-option>");
                return;
            }
            case 3: {
                if (!this.capabilities.hasRollbackOnError()) {
                    throw new JNCException(-7, "the :rollback-on-error capability is used but not supported by server");
                }
                transport.println("<" + this.nc + "error-option>rollback-on-error</" + this.nc + "error-option>");
                return;
            }
        }
        throw new JNCException(-7, "unknown error-option value: " + this.errorOption);
    }

    int encode_copyConfig(Transport transport, Element element, String string) throws JNCException {
        return this.encode_copyConfig(transport, new NodeSet(element), string);
    }

    int encode_copyConfig(Transport transport, NodeSet nodeSet, String string) throws JNCException {
        int n = this.encode_rpc_begin(transport);
        transport.println("<" + this.nc + COPY_CONFIG_GT);
        transport.print("<" + this.nc + TARGET_GT);
        transport.print(string);
        transport.println("</" + this.nc + TARGET_GT);
        transport.println("<" + this.nc + SOURCE_GT);
        transport.println("<" + this.nc + CONFIG_GT);
        nodeSet.encode(transport, this.capabilities);
        transport.println("</" + this.nc + CONFIG_GT);
        transport.println("</" + this.nc + SOURCE_GT);
        transport.println("</" + this.nc + COPY_CONFIG_GT);
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_copyConfig(Transport transport, String string, String string2) throws JNCException {
        int n = this.encode_rpc_begin(transport, this.withDefaultsAttr);
        transport.println("<" + this.nc + COPY_CONFIG_GT);
        transport.print("<" + this.nc + TARGET_GT);
        transport.print(string2);
        transport.println("</" + this.nc + TARGET_GT);
        transport.print("<" + this.nc + SOURCE_GT);
        transport.print(string);
        transport.println("</" + this.nc + SOURCE_GT);
        transport.println("</" + this.nc + COPY_CONFIG_GT);
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_deleteConfig(Transport transport, String string) {
        int n = this.encode_rpc_begin(transport);
        transport.println("<" + this.nc + "delete-config>");
        transport.print("<" + this.nc + TARGET_GT);
        transport.print(string);
        transport.println("</" + this.nc + TARGET_GT);
        transport.println("</" + this.nc + "delete-config>");
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_lock(Transport transport, String string) {
        int n = this.encode_rpc_begin(transport);
        transport.println("<" + this.nc + "lock>");
        transport.print("<" + this.nc + TARGET_GT);
        transport.print(string);
        transport.println("</" + this.nc + TARGET_GT);
        transport.println("</" + this.nc + "lock>");
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_unlock(Transport transport, String string) {
        int n = this.encode_rpc_begin(transport);
        transport.println("<" + this.nc + "unlock>");
        transport.print("<" + this.nc + TARGET_GT);
        transport.print(string);
        transport.println("</" + this.nc + TARGET_GT);
        transport.println("</" + this.nc + "unlock>");
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_lockPartial(Transport transport, String[] stringArray) {
        String string = Element.defaultPrefixes.nsToPrefix("urn:ietf:params:xml:ns:netconf:partial-lock:1.0");
        String string2 = this.mk_prefix_colon(string);
        String string3 = this.mk_xmlns_attr(string, "urn:ietf:params:xml:ns:netconf:partial-lock:1.0");
        int n = this.encode_rpc_begin(transport);
        transport.println("<" + string2 + "partial-lock " + string3 + ">");
        for (int i = 0; i < stringArray.length; ++i) {
            transport.print("<" + string2 + "select>");
            transport.print(stringArray[i]);
            transport.println("</" + string2 + "select>");
        }
        transport.println("</" + string2 + "partial-lock>");
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_unlockPartial(Transport transport, int n) {
        String string = Element.defaultPrefixes.nsToPrefix("urn:ietf:params:xml:ns:netconf:partial-lock:1.0");
        String string2 = this.mk_prefix_colon(string);
        String string3 = this.mk_xmlns_attr(string, "urn:ietf:params:xml:ns:netconf:partial-lock:1.0");
        int n2 = this.encode_rpc_begin(transport);
        transport.println("<" + string2 + "partial-unlock " + string3 + ">");
        transport.print("<" + string2 + "lock-id>");
        transport.print(n);
        transport.println("</" + string2 + "lock-id>");
        transport.println("</" + string2 + "partial-unlock>");
        this.encode_rpc_end(transport);
        return n2;
    }

    int encode_commit(Transport transport) {
        int n = this.encode_rpc_begin(transport);
        transport.println("<" + this.nc + "commit/>");
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_confirmedCommit(Transport transport, int n) {
        int n2 = this.encode_rpc_begin(transport);
        transport.println("<" + this.nc + "commit>");
        transport.println("<" + this.nc + "confirmed/>");
        transport.print("<" + this.nc + "confirm-timeout>");
        transport.print(Integer.valueOf(n).toString());
        transport.println("</" + this.nc + "confirm-timeout>");
        transport.println("</" + this.nc + "commit>");
        this.encode_rpc_end(transport);
        return n2;
    }

    int encode_discardChanges(Transport transport) {
        int n = this.encode_rpc_begin(transport);
        transport.println("<" + this.nc + "discard-changes/>");
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_closeSession(Transport transport) {
        int n = this.encode_rpc_begin(transport);
        transport.println("<" + this.nc + "close-session/>");
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_killSession(Transport transport, int n) {
        int n2 = this.encode_rpc_begin(transport);
        transport.println("<" + this.nc + "kill-session>");
        transport.print("<" + this.nc + "session-id>");
        transport.print(n);
        transport.println("</" + this.nc + "session-id>");
        transport.println("</" + this.nc + "kill-session>");
        this.encode_rpc_end(transport);
        return n2;
    }

    int encode_validate(Transport transport, Element element) throws JNCException {
        int n = this.encode_rpc_begin(transport);
        transport.println("<" + this.nc + VALIDATE_GT);
        transport.println("<" + this.nc + SOURCE_GT);
        transport.println("<" + this.nc + CONFIG_GT);
        element.encode(transport, true, this.capabilities);
        transport.println("</" + this.nc + CONFIG_GT);
        transport.println("</" + this.nc + SOURCE_GT);
        transport.println("</" + this.nc + VALIDATE_GT);
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_validate(Transport transport, String string) {
        int n = this.encode_rpc_begin(transport);
        transport.println("<" + this.nc + VALIDATE_GT);
        transport.print("<" + this.nc + SOURCE_GT);
        transport.print(string);
        transport.println("</" + this.nc + SOURCE_GT);
        transport.println("</" + this.nc + VALIDATE_GT);
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_createSubscription(Transport transport, String string, String string2, String string3, String string4) {
        String string5 = Element.defaultPrefixes.nsToPrefix("urn:ietf:params:xml:ns:netconf:notification:1.0");
        String string6 = this.mk_prefix_colon(string5);
        String string7 = this.mk_xmlns_attr(string5, "urn:ietf:params:xml:ns:netconf:notification:1.0");
        int n = this.encode_rpc_begin(transport);
        transport.println("<" + string6 + "create-subscription " + string7 + ">");
        if (string != null) {
            transport.print("<" + string6 + STREAM_GT);
            transport.print(string);
            transport.println("</" + string6 + STREAM_GT);
        }
        if (string2 != null) {
            transport.print("<" + string6 + FILTER + string6 + "type='xpath'>");
            transport.print(string2);
            transport.println("</" + string6 + FILTER_GT);
        }
        if (string3 != null) {
            transport.print("<" + string6 + START_TIME_GT);
            transport.print(string3);
            transport.println("</" + string6 + START_TIME_GT);
        }
        if (string4 != null) {
            transport.print("<" + string6 + STOP_TIME_GT);
            transport.print(string4);
            transport.println("</" + string6 + STOP_TIME_GT);
        }
        transport.println("</" + string6 + "create-subscription>");
        this.encode_rpc_end(transport);
        return n;
    }

    int encode_createSubscription(Transport transport, String string, NodeSet nodeSet, String string2, String string3) throws JNCException {
        String string4 = Element.defaultPrefixes.nsToPrefix("urn:ietf:params:xml:ns:netconf:notification:1.0");
        String string5 = this.mk_prefix_colon(string4);
        int n = this.encode_rpc_begin(transport);
        transport.println("<" + string5 + "create-subscription>");
        if (string != null) {
            transport.print("<" + string5 + STREAM_GT);
            transport.print(string);
            transport.println("</" + string5 + STREAM_GT);
        }
        if (nodeSet != null) {
            transport.print("<" + string5 + FILTER + string5 + "type='subtree'>");
            nodeSet.encode(transport, this.capabilities);
            transport.println("</" + string5 + FILTER_GT);
        }
        if (string2 != null) {
            transport.print("<" + string5 + START_TIME_GT);
            transport.print(string2);
            transport.println("</" + string5 + START_TIME_GT);
        }
        if (string3 != null) {
            transport.print("<" + string5 + STOP_TIME_GT);
            transport.print(string3);
            transport.println("</" + string5 + STOP_TIME_GT);
        }
        transport.println("</" + string5 + "create-subscription>");
        this.encode_rpc_end(transport);
        return n;
    }

    void encode_action(Transport transport, Element element) throws JNCException {
        String string = Element.defaultPrefixes.nsToPrefix("http://tail-f.com/ns/netconf/actions/1.0");
        String string2 = this.mk_prefix_colon(string);
        String string3 = this.mk_xmlns_attr(string, "http://tail-f.com/ns/netconf/actions/1.0");
        this.encode_rpc_begin(transport);
        transport.println("<" + string2 + "action " + string3 + ">");
        transport.print("<" + string2 + "data>");
        element.encode(transport);
        transport.println("</" + string2 + "data>");
        transport.println("</" + string2 + "action>");
        this.encode_rpc_end(transport);
    }

    String mk_prefix_colon(String string) {
        if (string == null) {
            return "unknown:";
        }
        return string.isEmpty() ? "" : string + ":";
    }

    String mk_xmlns_attr(String string, String string2) {
        if (string == null) {
            return "xmlns:unknown=\"" + string2 + "\"";
        }
        if (string.equals("")) {
            return "xmlns=\"" + string2 + "\"";
        }
        return "xmlns:" + string + "=\"" + string2 + "\"";
    }

    private static void trace(String string) {
        if (Element.debugLevel >= 2) {
            System.err.println("*NetconfSession: " + string);
        }
    }

    void check_mid(Element element, String string) throws JNCException {
        if (string == null) {
            return;
        }
        String string2 = element.getAttrValue("message-id");
        if (string2 == null || !string2.equals(string)) {
            throw new JNCException(-13, "After sending rpc with message-id=" + string + ", received rpc-reply with message-id=" + string2);
        }
    }
}

